/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.CompareFunction;
import org.jagatoo.opengl.enums.PerspectiveCorrectionMode;
import org.jagatoo.opengl.enums.TextureCombineFunction;
import org.jagatoo.opengl.enums.TextureCombineMode;
import org.jagatoo.opengl.enums.TextureCombineSource;
import org.jagatoo.opengl.enums.TextureCompareMode;
import org.jagatoo.opengl.enums.TextureMode;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix4f;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.states.StateNode;
import org.xith3d.render.states.StateTrackable;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.utility.comparator.ComparatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureAttributes
extends NodeComponent
implements StateTrackable<TextureAttributes> {
    private StateNode stateNode = null;
    private long stateId = -1L;
    public static final TextureMode MODULATE = TextureMode.MODULATE;
    public static final TextureMode REPLACE = TextureMode.REPLACE;
    public static final TextureMode BLEND = TextureMode.BLEND;
    public static final TextureMode DECAL = TextureMode.DECAL;
    public static final PerspectiveCorrectionMode NICEST = PerspectiveCorrectionMode.NICEST;
    public static final PerspectiveCorrectionMode FASTEST = PerspectiveCorrectionMode.FASTEST;
    public static final TextureCombineMode COMBINE_REPLACE = TextureCombineMode.REPLACE;
    public static final TextureCombineMode COMBINE_MODULATE = TextureCombineMode.MODULATE;
    public static final TextureCombineMode COMBINE_ADD = TextureCombineMode.ADD;
    public static final TextureCombineMode COMBINE_ADD_SIGNED = TextureCombineMode.ADD_SIGNED;
    public static final TextureCombineMode COMBINE_SUBTRACT = TextureCombineMode.SUBTRACT;
    public static final TextureCombineMode COMBINE_INTERPOLATE = TextureCombineMode.INTERPOLATE;
    public static final TextureCombineMode COMBINE_DOT3 = TextureCombineMode.DOT3;
    public static final TextureCombineMode COMBINE = TextureCombineMode.DOT3;
    public static final TextureCombineSource COMBINE_OBJECT_COLOR = TextureCombineSource.OBJECT_COLOR;
    public static final TextureCombineSource COMBINE_TEXTURE_COLOR = TextureCombineSource.TEXTURE_COLOR;
    public static final TextureCombineSource COMBINE_CONSTANT_COLOR = TextureCombineSource.CONSTANT_COLOR;
    public static final TextureCombineSource COMBINE_PREVIOUS_TEXTURE_UNIT = TextureCombineSource.PREVIOUS_TEXTURE_UNIT;
    public static final TextureCombineSource COMBINE_TEXTURE0 = TextureCombineSource.TEXTURE0;
    public static final TextureCombineSource COMBINE_TEXTURE1 = TextureCombineSource.TEXTURE1;
    public static final TextureCombineFunction COMBINE_SRC_COLOR = TextureCombineFunction.SRC_COLOR;
    public static final TextureCombineFunction COMBINE_ONE_MINUS_SRC_COLOR = TextureCombineFunction.ONE_MINUS_SRC_COLOR;
    public static final TextureCombineFunction COMBINE_SRC_ALPHA = TextureCombineFunction.SRC_ALPHA;
    public static final TextureCombineFunction COMBINE_ONE_MINUS_SRC_ALPHA = TextureCombineFunction.ONE_MINUS_SRC_ALPHA;
    private TextureMode textureMode = TextureMode.MODULATE;
    private Colorf texBlendColor = null;
    private PerspectiveCorrectionMode perspCorrectionMode = PerspectiveCorrectionMode.NICEST;
    private Transform3D transform = null;
    private TextureCombineMode combineRGBMode = TextureCombineMode.MODULATE;
    private TextureCombineMode combineAlphaMode = TextureCombineMode.MODULATE;
    private int[] combineRGBSource = new int[]{TextureCombineSource.PREVIOUS_TEXTURE_UNIT.ordinal(), TextureCombineSource.TEXTURE_COLOR.ordinal(), COMBINE_CONSTANT_COLOR.ordinal()};
    private int[] combineAlphaSource = new int[]{TextureCombineSource.TEXTURE_COLOR.ordinal(), TextureCombineSource.PREVIOUS_TEXTURE_UNIT.ordinal(), TextureCombineSource.CONSTANT_COLOR.ordinal()};
    private int[] combineRGBFunction = new int[]{TextureCombineFunction.SRC_COLOR.ordinal(), TextureCombineFunction.SRC_COLOR.ordinal(), TextureCombineFunction.SRC_COLOR.ordinal()};
    private int[] combineAlphaFunction = new int[]{TextureCombineFunction.SRC_ALPHA.ordinal(), TextureCombineFunction.SRC_ALPHA.ordinal(), TextureCombineFunction.SRC_ALPHA.ordinal()};
    private int combineRGBScale = 1;
    private int combineAlphaScale = 1;
    private TextureCompareMode compareMode = TextureCompareMode.NONE;
    private CompareFunction compareFunc = CompareFunction.LOWER_OR_EQUAL;

    public void setCombineAlphaSource(int index, TextureCombineSource value) {
        this.combineAlphaSource[index] = value.ordinal();
        this.setChanged(true);
    }

    public TextureCombineSource getCombineAlphaSource(int index) {
        return TextureCombineSource.values()[this.combineAlphaSource[index]];
    }

    public void setCombineRGBSource(int index, TextureCombineSource value) {
        this.combineRGBSource[index] = value.ordinal();
        this.setChanged(true);
    }

    public TextureCombineSource getCombineRGBSource(int index) {
        return TextureCombineSource.values()[this.combineRGBSource[index]];
    }

    public final void setTextureMode(TextureMode mode) {
        this.textureMode = mode;
        this.setChanged(true);
    }

    public TextureMode getTextureMode() {
        return this.textureMode;
    }

    public final void setTextureBlendColor(Colorf color) {
        if (this.texBlendColor == null && color != null) {
            this.texBlendColor = new Colorf(color);
            this.setChanged(true);
        } else if (this.texBlendColor != null && color == null) {
            this.texBlendColor = null;
            this.setChanged(true);
        } else if (this.texBlendColor != null && color != null) {
            this.texBlendColor.set(color);
            this.setChanged(true);
        }
    }

    public final void getTextureBlendColor(Colorf color) {
        color.set(this.texBlendColor);
    }

    public final Colorf getTextureBlendColor() {
        return this.texBlendColor;
    }

    public final void setTextureTransform(Transform3D transform) {
        this.transform = transform;
        this.setChanged(true);
    }

    public final void setTextureTransform(Matrix4f matrix) {
        if (matrix == null) {
            this.transform = null;
        } else if (this.transform == null) {
            this.transform = new Transform3D(matrix);
        } else {
            this.transform.set(matrix);
        }
        this.setChanged(true);
    }

    public final Transform3D getTextureTransform() {
        return this.transform;
    }

    public final void setPerspectiveCorrectionMode(PerspectiveCorrectionMode mode) {
        this.perspCorrectionMode = mode;
        this.setChanged(true);
    }

    public final PerspectiveCorrectionMode getPerspectiveCorrectionMode() {
        return this.perspCorrectionMode;
    }

    public void setCombineRGBMode(TextureCombineMode combineRgbMode) {
        this.combineRGBMode = combineRgbMode;
        this.setChanged(true);
    }

    public TextureCombineMode getCombineRGBMode() {
        return this.combineRGBMode;
    }

    public void setCombineAlphaMode(TextureCombineMode combineAlphaMode) {
        this.combineAlphaMode = combineAlphaMode;
        this.setChanged(true);
    }

    public TextureCombineMode getCombineAlphaMode() {
        return this.combineAlphaMode;
    }

    public void setCombineRGBFunction(int index, TextureCombineFunction combineRgbFunction) {
        this.combineRGBFunction[index] = combineRgbFunction.ordinal();
        this.setChanged(true);
    }

    public TextureCombineFunction getCombineRGBFunction(int index) {
        return TextureCombineFunction.values()[this.combineRGBFunction[index]];
    }

    public void setCombineAlphaFunction(int index, TextureCombineFunction combineAlphaFunction) {
        this.combineAlphaFunction[index] = combineAlphaFunction.ordinal();
        this.setChanged(true);
    }

    public TextureCombineFunction getCombineAlphaFunction(int index) {
        return TextureCombineFunction.values()[this.combineAlphaFunction[index]];
    }

    public int getCombineRGBScale() {
        return this.combineRGBScale;
    }

    public void setCombineRGBScale(int combineRgbScale) {
        this.combineRGBScale = combineRgbScale;
        this.setChanged(true);
    }

    public int getCombineAlphaScale() {
        return this.combineAlphaScale;
    }

    public void setCombineAlphaScale(int combineAlphaScale) {
        this.combineAlphaScale = combineAlphaScale;
        this.setChanged(true);
    }

    public void setCompareMode(TextureCompareMode compareMode) {
        if (compareMode == null) {
            throw new IllegalArgumentException("compareMode must not be null");
        }
        this.compareMode = compareMode;
    }

    public final TextureCompareMode getCompareMode() {
        return this.compareMode;
    }

    public void setCompareFunction(CompareFunction compareFunc) {
        if (compareFunc == null) {
            throw new IllegalArgumentException("compareFunc must not be null");
        }
        this.compareFunc = compareFunc;
    }

    public final CompareFunction getCompareFunction() {
        return this.compareFunc;
    }

    private static final int[] copy(int[] a) {
        if (a == null) {
            return null;
        }
        int[] b = new int[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent nodeOriginal, boolean forceDuplicate) {
        super.duplicateNodeComponent(nodeOriginal, forceDuplicate);
        TextureAttributes original = (TextureAttributes)nodeOriginal;
        this.perspCorrectionMode = original.perspCorrectionMode;
        this.textureMode = original.textureMode;
        if (forceDuplicate) {
            this.setTextureBlendColor(original.texBlendColor);
            if (this.transform == null) {
                if (original.transform != null) {
                    this.transform = new Transform3D(original.transform);
                }
            } else if (original.transform == null) {
                this.transform = null;
            } else {
                this.transform.set(original.transform);
            }
        } else {
            this.texBlendColor = original.texBlendColor;
            this.transform = original.transform;
        }
        this.combineRGBMode = original.combineRGBMode;
        this.combineRGBScale = original.combineRGBScale;
        this.combineAlphaMode = original.combineAlphaMode;
        this.combineAlphaScale = original.combineAlphaScale;
        this.combineRGBFunction = TextureAttributes.copy(original.combineRGBFunction);
        this.combineRGBSource = TextureAttributes.copy(original.combineRGBSource);
        this.combineAlphaFunction = TextureAttributes.copy(original.combineAlphaFunction);
        this.combineAlphaSource = TextureAttributes.copy(original.combineAlphaSource);
        this.compareMode = original.compareMode;
        this.compareFunc = original.compareFunc;
    }

    @Override
    public TextureAttributes cloneNodeComponent(boolean forceDuplicate) {
        TextureAttributes ta = new TextureAttributes();
        ta.duplicateNodeComponent(this, forceDuplicate);
        return ta;
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    @Override
    public final void setStateNode(StateNode node) {
        this.stateNode = node;
        this.stateId = node.getId();
    }

    @Override
    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final long getStateId() {
        return this.stateId;
    }

    @Override
    public TextureAttributes getCopy() {
        return this.cloneNodeComponent(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextureAttributes)) {
            return false;
        }
        TextureAttributes ro = (TextureAttributes)o;
        if (this.textureMode != ro.textureMode) {
            return false;
        }
        if (this.perspCorrectionMode != ro.perspCorrectionMode) {
            return false;
        }
        if (ComparatorHelper.compare(this.texBlendColor, ro.texBlendColor) != 0) {
            return false;
        }
        if (ComparatorHelper.compare(this.transform, ro.transform) != 0) {
            return false;
        }
        if (this.combineRGBMode != ro.combineRGBMode) {
            return false;
        }
        if (this.combineAlphaMode != ro.combineAlphaMode) {
            return false;
        }
        if (this.combineRGBScale != ro.combineRGBScale) {
            return false;
        }
        if (this.combineAlphaScale != ro.combineAlphaScale) {
            return false;
        }
        if (ComparatorHelper.compare(this.combineRGBFunction, ro.combineRGBFunction) != 0) {
            return false;
        }
        if (ComparatorHelper.compare(this.combineAlphaFunction, ro.combineAlphaFunction) != 0) {
            return false;
        }
        if (ComparatorHelper.compare(this.combineRGBSource, ro.combineRGBSource) != 0) {
            return false;
        }
        if (ComparatorHelper.compare(this.combineAlphaSource, ro.combineAlphaSource) != 0) {
            return false;
        }
        return this.compareMode == ro.compareMode;
    }

    @Override
    public int compareTo(TextureAttributes o) {
        if (this == o) {
            return 0;
        }
        if (this.textureMode.ordinal() < o.textureMode.ordinal()) {
            return -1;
        }
        if (this.textureMode.ordinal() > o.textureMode.ordinal()) {
            return 1;
        }
        if (this.perspCorrectionMode.ordinal() < o.perspCorrectionMode.ordinal()) {
            return -1;
        }
        if (this.perspCorrectionMode.ordinal() > o.perspCorrectionMode.ordinal()) {
            return 1;
        }
        int val = ComparatorHelper.compare(this.texBlendColor, o.texBlendColor);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compare(this.transform, o.transform);
        if (val != 0) {
            return val;
        }
        if (this.combineRGBMode.ordinal() < o.combineRGBMode.ordinal()) {
            return -1;
        }
        if (this.combineRGBMode.ordinal() > o.combineRGBMode.ordinal()) {
            return 1;
        }
        if (this.combineAlphaMode.ordinal() < o.combineAlphaMode.ordinal()) {
            return -1;
        }
        if (this.combineAlphaMode.ordinal() > o.combineAlphaMode.ordinal()) {
            return 1;
        }
        if (this.combineRGBScale < o.combineRGBScale) {
            return -1;
        }
        if (this.combineRGBScale > o.combineRGBScale) {
            return 1;
        }
        if (this.combineAlphaScale < o.combineAlphaScale) {
            return -1;
        }
        if (this.combineAlphaScale > o.combineAlphaScale) {
            return 1;
        }
        val = ComparatorHelper.compare(this.combineRGBFunction, o.combineRGBFunction);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compare(this.combineAlphaFunction, o.combineAlphaFunction);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compare(this.combineRGBSource, o.combineRGBSource);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compare(this.combineAlphaSource, o.combineAlphaSource);
        if (val != 0) {
            return val;
        }
        val = this.compareMode.ordinal() - o.compareMode.ordinal();
        if (val != 0) {
            return val;
        }
        val = this.compareFunc.ordinal() - o.compareFunc.ordinal();
        if (val != 0) {
            return val;
        }
        return 0;
    }

    public TextureAttributes() {
        super(false);
    }

    public TextureAttributes(TextureMode textureMode, Transform3D transform, Colorf textureBlendColor, PerspectiveCorrectionMode perspCorrectionMode) {
        this();
        this.perspCorrectionMode = perspCorrectionMode;
        this.textureMode = textureMode;
        this.setTextureBlendColor(textureBlendColor);
        this.transform = transform;
    }

    private TextureAttributes(TextureMode textureMode, Transform3D transform, Colorf textureBlendColor, Colorf blendColor, PerspectiveCorrectionMode perspCorrectionMode, TextureCombineMode combineRgbMode, int combineRgbScale, TextureCombineMode combineAlphaMode, int combineAlphaScale, int[] combineRgbFunction, int[] combineRgbSource, int[] combineAlphaFunction, int[] combineAlphaSource) {
        this();
        this.textureMode = textureMode;
        this.transform = transform;
        this.setTextureBlendColor(textureBlendColor);
        this.perspCorrectionMode = perspCorrectionMode;
        this.combineRGBMode = combineRgbMode;
        this.combineRGBScale = combineRgbScale;
        this.combineAlphaMode = combineAlphaMode;
        this.combineAlphaScale = combineAlphaScale;
        this.combineRGBFunction = TextureAttributes.copy(combineRgbFunction);
        this.combineRGBSource = TextureAttributes.copy(combineRgbSource);
        this.combineAlphaFunction = TextureAttributes.copy(combineAlphaFunction);
        this.combineAlphaSource = TextureAttributes.copy(combineAlphaSource);
    }
}

