/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.jagatoo.image.BufferedImageFactory;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.opengl.enums.TextureImageInternalFormat;
import org.jagatoo.util.image.ImageUtility;
import org.jagatoo.util.nio.BufferUtils;
import org.openmali.types.twodee.Rect2i;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.TextureImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureImage2D
extends TextureImage {
    private ByteBuffer dataBuffer = null;
    private byte[] data = null;
    private byte[] pixelRow1 = null;
    private byte[] pixelRow2 = null;
    private int pixelBytes = 0;
    private final ArrayList<Rect2i> updateList = new ArrayList();
    private final TexCoord2f texCoordUR = new TexCoord2f();
    private final Rect2i userClipRect = new Rect2i(0, 0, 128, 128);
    private final Rect2i clipRect = new Rect2i(0, 0, 128, 128);
    private boolean readOnly = true;
    private final boolean yUp;
    private BufferedImage bufferedImage = null;

    protected final boolean getYUp() {
        return this.yUp;
    }

    public final TexCoord2f getTextureCoordinateUR(TexCoord2f tcUR) {
        tcUR.set((TexCoordf)this.texCoordUR);
        return tcUR;
    }

    public final <T extends Tuple2f> T getTextureCoordinateUR(T tcUR) {
        tcUR.set(this.texCoordUR.getS(), this.texCoordUR.getT());
        return tcUR;
    }

    public final int getPixelSize() {
        return this.pixelBytes;
    }

    public final int getDataSize() {
        if (this.data == null && this.dataBuffer == null) {
            return this.getWidth() * this.getHeight() * this.pixelBytes;
        }
        if (this.data == null) {
            return this.dataBuffer.capacity();
        }
        return this.data.length;
    }

    public final ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public final void getData(ByteBuffer bb) {
        bb.position(0);
        bb.limit(bb.capacity());
        if (!this.hasData()) {
            bb.flip();
            return;
        }
        if (this.getFormat().isCompressed()) {
            bb.put(this.data, 0, this.data.length);
        } else {
            switch (this.pixelBytes) {
                case 4: {
                    for (int i = 0; i < this.data.length; i += 4) {
                        bb.put(this.data[i + 3]);
                        bb.put(this.data[i + 2]);
                        bb.put(this.data[i + 1]);
                        bb.put(this.data[i + 0]);
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.data.length; i += 3) {
                        bb.put(this.data[i + 2]);
                        bb.put(this.data[i + 1]);
                        bb.put(this.data[i + 0]);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.data.length; i += 2) {
                        bb.put(this.data[i + 1]);
                        bb.put(this.data[i + 0]);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.data.length; ++i) {
                        bb.put(this.data[i + 0]);
                    }
                    break;
                }
            }
        }
        bb.flip();
    }

    public final int getData(byte[] data) {
        byte[] trg = data;
        if (!this.hasData()) {
            return 0;
        }
        if (this.getFormat().isCompressed()) {
            if (this.dataBuffer == null) {
                System.arraycopy(this.data, 0, trg, 0, this.data.length);
                return this.data.length;
            }
            this.dataBuffer.position(0);
            this.dataBuffer.get(trg, 0, this.dataBuffer.limit());
            this.dataBuffer.position(0);
            return this.dataBuffer.limit();
        }
        int b = 0;
        if (this.dataBuffer == null) {
            byte[] src = this.data;
            int n = src.length;
            switch (this.pixelBytes) {
                case 4: {
                    for (int i = 0; i < n; i += 4) {
                        trg[b++] = src[i + 3];
                        trg[b++] = src[i + 2];
                        trg[b++] = src[i + 1];
                        trg[b++] = src[i + 0];
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < n; i += 3) {
                        trg[b++] = src[i + 2];
                        trg[b++] = src[i + 1];
                        trg[b++] = src[i + 0];
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n; i += 2) {
                        trg[b++] = src[i + 1];
                        trg[b++] = src[i + 0];
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < n; ++i) {
                        trg[b++] = src[i + 0];
                    }
                    break;
                }
            }
            return n;
        }
        int n = this.dataBuffer.limit();
        switch (this.pixelBytes) {
            case 4: {
                for (int i = 0; i < n; i += 4) {
                    trg[b++] = this.dataBuffer.get(i + 3);
                    trg[b++] = this.dataBuffer.get(i + 2);
                    trg[b++] = this.dataBuffer.get(i + 1);
                    trg[b++] = this.dataBuffer.get(i + 0);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n; i += 3) {
                    trg[b++] = this.dataBuffer.get(i + 2);
                    trg[b++] = this.dataBuffer.get(i + 1);
                    trg[b++] = this.dataBuffer.get(i + 0);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n; i += 2) {
                    trg[b++] = this.dataBuffer.get(i + 1);
                    trg[b++] = this.dataBuffer.get(i + 0);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n; ++i) {
                    trg[b++] = this.dataBuffer.get(i + 0);
                }
                break;
            }
        }
        this.dataBuffer.position(0);
        return n;
    }

    public void freeLocalData() {
        this.dataBuffer = null;
        this.data = null;
        this.bufferedImage = null;
    }

    public void update(int x, int y, int width, int height) {
        if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight() || width > this.getWidth() || height > this.getHeight() || x + width > this.getWidth() || y + height > this.getHeight()) {
            throw new IllegalArgumentException("Rectangle outside of image");
        }
        Rect2i rect = Rect2i.fromPool();
        if (this.yUp) {
            rect.set(x, this.getHeight() - height - y, width, height);
        } else {
            rect.set(x, y, width, height);
        }
        if (this.updateList.size() > 0) {
            int mostSimilar = -1;
            int mostSimMatchFact = 0;
            for (int i = 0; i < this.updateList.size(); ++i) {
                int matchFact;
                Rect2i r = this.updateList.get(i);
                if (rect.isCoveredBy(r)) {
                    Rect2i.toPool((Rect2i)rect);
                    return;
                }
                if (rect.intersects(r) || (matchFact = rect.getMatchFactor(r)) >= mostSimMatchFact) continue;
                mostSimMatchFact = matchFact;
                mostSimilar = i;
            }
            if (mostSimilar >= 0) {
                this.updateList.get(mostSimilar).combine(rect);
                Rect2i.toPool((Rect2i)rect);
                return;
            }
        }
        this.updateList.add(rect);
    }

    public final void update(Rect2i r) {
        this.update(r.getLeft(), r.getTop(), r.getWidth(), r.getHeight());
    }

    public final ArrayList<Rect2i> getUpdateList() {
        return this.updateList;
    }

    public final void clearUpdateList() {
        for (int i = this.updateList.size() - 1; i >= 0; --i) {
            Rect2i.toPool((Rect2i)this.updateList.get(i));
        }
        this.updateList.clear();
    }

    void fixUpdateListAfterSizeChange() {
        for (int i = 0; i < this.updateList.size(); ++i) {
            Rect2i r = this.updateList.get(i);
            r.setLocation(Math.min(r.getLeft(), this.getWidth()), Math.min(r.getTop(), this.getHeight()));
            r.setSize(Math.min(r.getLeft() + r.getWidth(), this.getWidth()) - r.getLeft(), Math.min(r.getTop() + r.getHeight(), this.getHeight()) - r.getTop());
        }
    }

    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public BufferedImage getBufferedImage() {
        if (this.getFormat().isCompressed()) {
            return null;
        }
        if (this.bufferedImage == null) {
            if (this.data == null) {
                if (this.readOnly) {
                    byte[] dbbData = new byte[this.dataBuffer.limit()];
                    this.getData(dbbData);
                    this.bufferedImage = BufferedImageFactory.createSharedBufferedImage((int)this.getWidth(), (int)this.getHeight(), (int)this.pixelBytes, (boolean)this.hasAlpha(), null, (byte[])dbbData);
                } else {
                    int[] nArray;
                    if (this.getFormat().hasAlpha()) {
                        int[] nArray2 = new int[4];
                        nArray2[0] = 0;
                        nArray2[1] = 1;
                        nArray2[2] = 2;
                        nArray = nArray2;
                        nArray2[3] = 3;
                    } else {
                        int[] nArray3 = new int[3];
                        nArray3[0] = 0;
                        nArray3[1] = 1;
                        nArray = nArray3;
                        nArray3[2] = 2;
                    }
                    int[] pixelOffsets = nArray;
                    this.bufferedImage = BufferedImageFactory.createDirectBufferedImage((int)this.getWidth(), (int)this.getHeight(), (boolean)this.getFormat().hasAlpha(), (int[])pixelOffsets, (ByteBuffer)this.dataBuffer);
                }
            } else {
                this.bufferedImage = BufferedImageFactory.createSharedBufferedImage((int)this.getWidth(), (int)this.getHeight(), (int)this.pixelBytes, (boolean)this.hasAlpha(), null, (byte[])this.data);
            }
        }
        return this.bufferedImage;
    }

    protected Graphics2D createGraphics2D() {
        BufferedImage bi = this.getBufferedImage();
        return bi.createGraphics();
    }

    private void clampClipRect(int texWidth, int texHeight) {
        this.clipRect.set(this.userClipRect);
        this.clipRect.clamp(0, 0, texWidth, texHeight);
    }

    public void setClipRect(int x, int y, int width, int height) {
        this.userClipRect.set(x, y, width, height);
        this.clampClipRect(this.getWidth(), this.getHeight());
    }

    public final void setClipRect(Rect2i clipRect) {
        this.setClipRect(clipRect.getLeft(), clipRect.getTop(), clipRect.getWidth(), clipRect.getHeight());
    }

    public final <Rect2i_ extends Rect2i> Rect2i_ getClipRect(Rect2i_ rect) {
        rect.set(this.userClipRect);
        return rect;
    }

    final Rect2i getEffectiveClipRect() {
        return this.clipRect;
    }

    protected final void setImageData(byte[] data, int dataLength, boolean useBuffer) {
        this.clampClipRect(this.getWidth(), this.getHeight());
        if (data == null && dataLength <= 0) {
            this.dataBuffer = null;
            this.data = null;
            this.bufferedImage = null;
            this.setHasData(false);
            return;
        }
        if (useBuffer) {
            if (this.dataBuffer == null || this.dataBuffer.capacity() < dataLength) {
                this.dataBuffer = BufferUtils.createByteBuffer((int)dataLength);
            }
            this.data = null;
        } else {
            if (this.data == null || this.data.length < dataLength) {
                this.data = new byte[dataLength];
            }
            this.dataBuffer = null;
        }
        this.bufferedImage = null;
        if (this.getFormat().isCompressed()) {
            if (data != null && dataLength > 0) {
                int imgSize = dataLength;
                this.pixelBytes = imgSize / (this.getWidth() * this.getHeight());
                if (useBuffer) {
                    this.dataBuffer.position(0);
                    this.dataBuffer.put(data, 0, dataLength);
                    this.dataBuffer.flip();
                } else {
                    System.arraycopy(data, 0, this.data, 0, dataLength);
                }
            }
        } else {
            if (data == null) {
                this.setHasData(true);
                return;
            }
            if (useBuffer) {
                this.dataBuffer.position(0);
                this.dataBuffer.put(data, 0, dataLength);
                this.dataBuffer.flip();
            } else {
                switch (this.pixelBytes) {
                    case 4: {
                        for (int i = 0; i < dataLength; i += 4) {
                            this.data[i + 0] = data[i + 3];
                            this.data[i + 1] = data[i + 2];
                            this.data[i + 2] = data[i + 1];
                            this.data[i + 3] = data[i + 0];
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < dataLength; i += 3) {
                            this.data[i + 0] = data[i + 2];
                            this.data[i + 1] = data[i + 1];
                            this.data[i + 2] = data[i + 0];
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < dataLength; i += 2) {
                            this.data[i + 0] = data[i + 1];
                            this.data[i + 1] = data[i + 0];
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < dataLength; ++i) {
                            this.data[i + 0] = data[i + 0];
                        }
                        break;
                    }
                }
            }
        }
        this.setHasData(true);
    }

    public final void setImageData(byte[] data, int dataLength) {
        this.setImageData(data, dataLength, true);
    }

    protected final void setImageData(byte[] data, boolean useBuffer) {
        this.setImageData(data, data != null ? data.length : 0, useBuffer);
    }

    public final void setImageData(byte[] data) {
        this.setImageData(data, true);
    }

    private final boolean needsDataResize(int width, int height, boolean allowBiggerTexture) {
        if (width > this.getWidth() || height > this.getHeight()) {
            return true;
        }
        if (allowBiggerTexture) {
            return false;
        }
        int lWidth = this.getWidth() >> 1;
        int lHeight = this.getHeight() >> 1;
        return width <= lWidth || height <= lHeight;
    }

    protected boolean initImageData(int width, int height, int orgWidth, int orgHeight, boolean allowBiggerTexture, boolean usebuffer) {
        boolean sizeChanged;
        int newDataLength = orgWidth * orgHeight * this.pixelBytes;
        int oldDataLength = this.getOriginalWidth() * this.getOriginalHeight() * this.pixelBytes;
        if (newDataLength == oldDataLength) {
            if (usebuffer && this.dataBuffer != null) {
                return false;
            }
            if (!usebuffer && this.data != null) {
                return false;
            }
        }
        boolean bl = sizeChanged = (width != this.getWidth() || height != this.getHeight()) && this.needsDataResize(width, height, allowBiggerTexture);
        if (sizeChanged) {
            this.setSize(width, height);
        }
        if (orgWidth != this.getOriginalWidth() || orgHeight != this.getOriginalHeight()) {
            this.setOriginalSize(orgWidth, orgHeight);
        }
        this.texCoordUR.set((float)orgWidth / (float)this.getWidth(), (float)orgHeight / (float)this.getHeight());
        if (sizeChanged) {
            this.setImageData(null, width * height * this.pixelBytes, usebuffer);
        }
        return sizeChanged;
    }

    public final boolean initImageData(int orgWidth, int orgHeight, boolean allowBiggerTexture, boolean usebuffer) {
        int width = ImageUtility.roundUpPower2((int)orgWidth);
        int height = ImageUtility.roundUpPower2((int)orgHeight);
        return this.initImageData(width, height, orgWidth, orgHeight, allowBiggerTexture, usebuffer);
    }

    public final boolean initImageData(int orgWidth, int orgHeight, boolean allowBiggerTexture) {
        return this.initImageData(orgWidth, orgHeight, allowBiggerTexture, this.dataBuffer != null);
    }

    public final boolean initImageData(boolean allowBiggerTexture, boolean usebuffer) {
        return this.initImageData(this.getWidth(), this.getHeight(), this.getOriginalWidth(), this.getOriginalHeight(), allowBiggerTexture, usebuffer);
    }

    protected void setImageData(BufferedImage image, boolean useBuffer) {
        int orgWidth = image.getWidth();
        int orgHeight = image.getWidth();
        int width = ImageUtility.roundUpPower2((int)orgWidth);
        int height = ImageUtility.roundUpPower2((int)orgHeight);
        this.setSize(width, height);
        this.setOriginalSize(orgWidth, orgHeight);
        this.texCoordUR.set((float)orgWidth / (float)width, (float)orgHeight / (float)height);
        if (useBuffer) {
            this.data = null;
        } else {
            this.dataBuffer = null;
        }
        this.pixelBytes = this.getFormat().getPixelSize();
        if (useBuffer) {
            this.dataBuffer = BufferUtils.createByteBuffer((int)(width * height * this.pixelBytes));
            WritableRaster raster = image.getRaster();
            ColorModel cm = image.getColorModel();
            Object o = null;
            int i = 0;
            for (int x = 0; x < width; ++x) {
                block7: for (int y = 0; y < height; ++y) {
                    o = raster.getDataElements(x, y, o);
                    switch (this.pixelBytes) {
                        case 4: {
                            byte r = (byte)cm.getRed(o);
                            byte g = (byte)cm.getGreen(o);
                            byte b = (byte)cm.getBlue(o);
                            byte a = (byte)cm.getAlpha(o);
                            this.dataBuffer.put(i++, r);
                            this.dataBuffer.put(i++, g);
                            this.dataBuffer.put(i++, b);
                            this.dataBuffer.put(i++, a);
                            continue block7;
                        }
                        case 3: {
                            byte r = (byte)cm.getRed(o);
                            byte g = (byte)cm.getGreen(o);
                            byte b = (byte)cm.getBlue(o);
                            this.dataBuffer.put(i++, r);
                            this.dataBuffer.put(i++, g);
                            this.dataBuffer.put(i++, b);
                            continue block7;
                        }
                        case 2: {
                            byte r = (byte)cm.getRed(o);
                            byte g = (byte)cm.getGreen(o);
                            this.dataBuffer.put(i++, r);
                            this.dataBuffer.put(i++, g);
                            continue block7;
                        }
                        case 1: {
                            byte r = (byte)cm.getRed(o);
                            this.dataBuffer.put(i++, r);
                            continue block7;
                        }
                    }
                }
            }
            this.dataBuffer.position(0);
            this.dataBuffer.limit(this.dataBuffer.capacity());
        } else {
            this.data = new byte[width * height * this.pixelBytes];
            int i = this.getDataOffset(0, 0);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int argb = image.getRGB(x, y);
                    if (this.pixelBytes == 4) {
                        this.data[i++] = (byte)((argb & 0xFF000000) >> 24);
                        this.data[i++] = (byte)((argb & 0xFF0000) >> 16);
                        this.data[i++] = (byte)((argb & 0xFF00) >> 8);
                        this.data[i++] = (byte)(argb & 0xFF);
                        continue;
                    }
                    if (this.pixelBytes != 3) continue;
                    this.data[i++] = (byte)((argb & 0xFF0000) >> 16);
                    this.data[i++] = (byte)((argb & 0xFF00) >> 8);
                    this.data[i++] = (byte)(argb & 0xFF);
                }
            }
        }
        this.setHasData(true);
    }

    public void setImageData(BufferedImage image) {
        this.setImageData(image, true);
    }

    private final int getDataOffset(int x, int y) {
        if (this.yUp) {
            return y * this.getWidth() * this.pixelBytes + x * this.pixelBytes;
        }
        return (this.getHeight() - y - 1) * this.getWidth() * this.pixelBytes + x * this.pixelBytes;
    }

    protected final void setPixel(int offset, byte[] data) {
        if (this.data == null) {
            this.dataBuffer.position(offset);
            this.dataBuffer.put(data, 0, this.pixelBytes);
            this.dataBuffer.position(0);
        } else {
            System.arraycopy(data, 0, this.data, offset, this.pixelBytes);
        }
    }

    public final void setPixel(int x, int y, byte[] data, boolean markDirty, Rect2i dirtyRect) {
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return;
        }
        this.setPixel(this.getDataOffset(x, y), data);
        if (markDirty) {
            this.update(x, y, 1, 1);
        }
        if (dirtyRect != null) {
            dirtyRect.set(x, y, 1, 1);
        }
    }

    private final byte[] getPixel(int offset, byte[] data) {
        if (this.data == null) {
            this.dataBuffer.position(offset);
            this.dataBuffer.get(data, 0, this.pixelBytes);
            this.dataBuffer.position(0);
        } else {
            System.arraycopy(this.data, offset, data, 0, this.pixelBytes);
        }
        return data;
    }

    public final byte[] getPixel(int x, int y, byte[] data) {
        return this.getPixel(this.getDataOffset(x, y), data);
    }

    public final void setPixelLine(int trgByteOffset, byte[] data, int srcByteOffset, int length) {
        int n = length * this.pixelBytes;
        if (this.data == null) {
            this.dataBuffer.position(trgByteOffset);
            this.dataBuffer.put(data, srcByteOffset, n);
            this.dataBuffer.position(0);
        } else {
            switch (this.pixelBytes) {
                case 4: {
                    for (int i = 0; i < n; i += 4) {
                        this.data[trgByteOffset + i + 0] = data[srcByteOffset + i + 3];
                        this.data[trgByteOffset + i + 1] = data[srcByteOffset + i + 2];
                        this.data[trgByteOffset + i + 2] = data[srcByteOffset + i + 1];
                        this.data[trgByteOffset + i + 3] = data[srcByteOffset + i + 0];
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < n; i += 3) {
                        this.data[trgByteOffset + i + 0] = data[srcByteOffset + i + 2];
                        this.data[trgByteOffset + i + 1] = data[srcByteOffset + i + 1];
                        this.data[trgByteOffset + i + 2] = data[srcByteOffset + i + 0];
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n; i += 2) {
                        this.data[trgByteOffset + i + 0] = data[srcByteOffset + i + 1];
                        this.data[trgByteOffset + i + 1] = data[srcByteOffset + i + 0];
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < n; ++i) {
                        this.data[trgByteOffset + i + 0] = data[srcByteOffset + i + 0];
                    }
                    break;
                }
            }
        }
    }

    public final void setPixelLine(int x, int y, int length, byte[] data, int srcByteOffset, boolean markDirty, Rect2i dirtyRect) {
        this.setPixelLine(this.getDataOffset(x, y), data, srcByteOffset, length);
        if (markDirty) {
            this.update(x, y, length, 1);
        }
        if (dirtyRect != null) {
            dirtyRect.set(x, y, length, 1);
        }
    }

    public final void setPixelLine(int x, int y, byte[] data, int srcOffset, int length) {
        this.setPixelLine(this.getDataOffset(x, y), data, srcOffset, length);
    }

    public final byte[] getPixelLine(int offset, int length, byte[] data) {
        int n = length * this.pixelBytes;
        if (this.data == null) {
            this.dataBuffer.position(offset);
            this.dataBuffer.get(data, 0, n);
            this.dataBuffer.position(0);
        } else {
            switch (this.pixelBytes) {
                case 4: {
                    for (int i = 0; i < n; i += 4) {
                        data[i + 0] = this.data[offset + i + 3];
                        data[i + 1] = this.data[offset + i + 2];
                        data[i + 2] = this.data[offset + i + 1];
                        data[i + 3] = this.data[offset + i + 0];
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < n; i += 3) {
                        data[i + 0] = this.data[offset + i + 2];
                        data[i + 1] = this.data[offset + i + 1];
                        data[i + 2] = this.data[offset + i + 0];
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n; i += 2) {
                        data[i + 0] = this.data[offset + i + 1];
                        data[i + 1] = this.data[offset + i + 0];
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < n; ++i) {
                        data[i + 0] = this.data[offset + i + 0];
                    }
                    break;
                }
            }
        }
        return data;
    }

    public final byte[] getPixelLine(int x, int y, int length, byte[] data) {
        return this.getPixelLine(this.getDataOffset(x, y), length, data);
    }

    private static final byte[] combinePixels(byte[] src, int srcByteOffset, int srcPixelSize, TextureImage2D trgIC, int trgPixelSize, byte[] trg, int trgByteOffset, int numPixels, boolean overwrite) {
        block9: {
            block10: {
                block8: {
                    if (srcPixelSize != 3) break block8;
                    if (trgPixelSize == 3) {
                        return src;
                    }
                    int j = srcByteOffset;
                    int k = 0;
                    for (int i = 0; i < numPixels; ++i) {
                        trg[k + 0] = src[j + 0];
                        trg[k + 1] = src[j + 1];
                        trg[k + 2] = src[j + 2];
                        trg[k + 3] = -1;
                        j += srcPixelSize;
                        k += trgPixelSize;
                    }
                    break block9;
                }
                if (srcPixelSize != 4) break block9;
                if (trgPixelSize != 3) break block10;
                if (!overwrite) {
                    trgIC.getPixelLine(trgByteOffset, numPixels, trg);
                }
                int j = srcByteOffset;
                int k = 0;
                for (int i = 0; i < numPixels; ++i) {
                    int srcR = src[j + 0] & 0xFF;
                    int srcG = src[j + 1] & 0xFF;
                    int srcB = src[j + 2] & 0xFF;
                    int srcA = src[j + 3] & 0xFF;
                    if (overwrite) {
                        trg[k + 0] = (byte)(srcR * srcA / 255);
                        trg[k + 1] = (byte)(srcG * srcA / 255);
                        trg[k + 2] = (byte)(srcB * srcA / 255);
                    } else {
                        int trgR = trg[k + 0] & 0xFF;
                        int trgG = trg[k + 1] & 0xFF;
                        int trgB = trg[k + 2] & 0xFF;
                        trg[k + 0] = (byte)(srcR * srcA / 255 + trgR * (255 - srcA) / 255);
                        trg[k + 1] = (byte)(srcG * srcA / 255 + trgG * (255 - srcA) / 255);
                        trg[k + 2] = (byte)(srcB * srcA / 255 + trgB * (255 - srcA) / 255);
                    }
                    j += srcPixelSize;
                    k += trgPixelSize;
                }
                break block9;
            }
            if (trgPixelSize != 4) break block9;
            if (overwrite) {
                return src;
            }
            trgIC.getPixelLine(trgByteOffset, numPixels, trg);
            int j = srcByteOffset;
            int k = 0;
            for (int i = 0; i < numPixels; ++i) {
                int srcR = src[j + 0] & 0xFF;
                int srcG = src[j + 1] & 0xFF;
                int srcB = src[j + 2] & 0xFF;
                int srcA = src[j + 3] & 0xFF;
                int trgR = trg[k + 0] & 0xFF;
                int trgG = trg[k + 1] & 0xFF;
                int trgB = trg[k + 2] & 0xFF;
                int trgA = trg[k + 3] & 0xFF;
                trg[k + 0] = (byte)(srcR * srcA / 255 + trgR * (255 - srcA) / 255);
                trg[k + 1] = (byte)(srcG * srcA / 255 + trgG * (255 - srcA) / 255);
                trg[k + 2] = (byte)(srcB * srcA / 255 + trgB * (255 - srcA) / 255);
                trg[k + 3] = (byte)(srcA * srcA / 255 + trgA * (255 - srcA) / 255);
                j += srcPixelSize;
                k += trgPixelSize;
            }
        }
        return trg;
    }

    private final byte[] getPixelLineBuffer1(int size) {
        if (this.pixelRow1 == null || this.pixelRow1.length < size) {
            this.pixelRow1 = new byte[Math.max(size, this.getWidth() * this.getPixelSize())];
        }
        return this.pixelRow1;
    }

    private final byte[] getPixelLineBuffer2(int size) {
        if (this.pixelRow2 == null || this.pixelRow2.length < size) {
            this.pixelRow2 = new byte[Math.max(size, this.getWidth() * this.getPixelSize())];
        }
        return this.pixelRow2;
    }

    private void copyImageDataFrom(TextureImage2D srcTI, int srcX, int srcY, int srcWidth, int srcHeight, int trgX, int trgY, int trgWidth, int trgHeight, boolean overwrite, boolean markDirty, Rect2i dirtyRect) {
        if (trgX + trgWidth < this.clipRect.getLeft() || trgY + trgHeight < this.clipRect.getTop() || trgX >= this.clipRect.getLeft() + this.clipRect.getWidth() || trgY >= this.clipRect.getTop() + this.clipRect.getHeight()) {
            if (dirtyRect != null) {
                dirtyRect.set(-1, -1, 0, 0);
            }
            return;
        }
        if (trgX < this.clipRect.getLeft()) {
            int oldTrgX = trgX;
            trgX = this.clipRect.getLeft() - (this.clipRect.getLeft() - trgX) % srcWidth;
            trgWidth -= trgX - oldTrgX;
        }
        if (trgY < this.clipRect.getTop()) {
            int oldTrgY = trgY;
            trgY = this.clipRect.getTop() - (this.clipRect.getTop() - trgY) % srcHeight;
            trgHeight -= trgY - oldTrgY;
        }
        if (trgX + trgWidth > this.clipRect.getLeft() + this.clipRect.getWidth()) {
            trgWidth = (int)Math.ceil((double)(this.clipRect.getLeft() + this.clipRect.getWidth() - trgX) / (double)srcWidth) * srcWidth;
        }
        int srcPixelSize = srcTI.getPixelSize();
        int trgPixelSize = this.getPixelSize();
        byte[] srcBuffer = this.getPixelLineBuffer1(srcWidth * srcPixelSize);
        byte[] trgBuffer = this.getPixelLineBuffer2(srcWidth * trgPixelSize);
        int y_ = this.yUp ? 0 : this.getHeight() - this.getOriginalHeight();
        int x0 = Math.max(this.clipRect.getLeft(), trgX);
        int x1 = Math.min(this.clipRect.getLeft() + this.clipRect.getWidth() - 1, trgX + trgWidth - 1);
        int y0 = Math.max(this.clipRect.getTop(), trgY);
        int y1 = Math.min(this.clipRect.getTop() + this.clipRect.getHeight() - 1, trgY + trgHeight - 1);
        for (int j = y0; j <= y1; ++j) {
            int srcJ = srcY + (j - trgY) % srcHeight;
            srcTI.getPixelLine(srcX, srcJ, srcWidth, srcBuffer);
            int trgX_ = trgX;
            int trgWidth_ = trgWidth;
            int trgLength_ = srcWidth;
            while (trgX_ < trgX + trgWidth) {
                if (trgWidth_ < srcWidth) {
                    trgLength_ = trgWidth_;
                }
                if (trgX_ + trgLength_ >= x1) {
                    trgLength_ = x1 - trgX_ + 1;
                }
                int trgX__ = Math.max(x0, trgX_);
                int trgByteOffset = this.getDataOffset(trgX__, y_ + j);
                int srcPixelOffset = trgX__ - trgX_;
                byte[] pixels = TextureImage2D.combinePixels(srcBuffer, srcPixelOffset * srcPixelSize, srcPixelSize, this, trgPixelSize, trgBuffer, trgByteOffset, trgLength_ - srcPixelOffset, overwrite);
                if (srcPixelSize == trgPixelSize && overwrite) {
                    this.setPixelLine(trgByteOffset, pixels, srcPixelOffset * srcPixelSize, trgLength_ - srcPixelOffset);
                } else {
                    this.setPixelLine(trgByteOffset, pixels, 0, trgLength_ - srcPixelOffset);
                }
                trgX_ += srcWidth;
                trgWidth_ -= srcWidth;
            }
        }
        if (markDirty) {
            this.update(x0, y0, x1 - x0 + 1, y1 - y0 + 1);
        }
        if (dirtyRect != null) {
            dirtyRect.set(x0, y0, x1 - x0 + 1, y1 - y0 + 1);
        }
    }

    public final void drawImage(TextureImage2D srcTI, int srcX, int srcY, int srcWidth, int srcHeight, int trgX, int trgY, int trgWidth, int trgHeight, boolean markDirty, Rect2i dirtyRect) {
        this.copyImageDataFrom(srcTI, srcX, srcY, srcWidth, srcHeight, trgX, trgY, trgWidth, trgHeight, false, markDirty, dirtyRect);
    }

    public final void drawImage(TextureImage2D srcTI, int srcX, int srcY, int srcWidth, int srcHeight, int trgX, int trgY, boolean markDirty, Rect2i dirtyRect) {
        this.drawImage(srcTI, srcX, srcY, srcWidth, srcHeight, trgX, trgY, srcWidth, srcHeight, markDirty, dirtyRect);
    }

    public final void drawImage(TextureImage2D ti, Rect2i srcRect, int trgX, int trgY, boolean markDirty, Rect2i dirtyRect) {
        this.drawImage(ti, srcRect.getLeft(), srcRect.getTop(), srcRect.getWidth(), srcRect.getHeight(), trgX, trgY, markDirty, dirtyRect);
    }

    public final void drawImage(TextureImage2D ti, int trgX, int trgY, boolean markDirty, Rect2i dirtyRect) {
        this.drawImage(ti, 0, 0, ti.getOriginalWidth(), ti.getOriginalHeight(), trgX, trgY, markDirty, dirtyRect);
    }

    public void fillRectangle(Colorf color, int offsetX, int offsetY, int width, int height, boolean markDirty, Rect2i dirtyRect) {
        if (!color.hasAlpha()) {
            this.clear(color, offsetX, offsetY, width, height, markDirty, dirtyRect);
            return;
        }
        int srcPixelSize = 4;
        byte[] pixel = this.getPixelLineBuffer1(srcPixelSize);
        pixel[0] = color.getRedByte();
        pixel[1] = color.getGreenByte();
        pixel[2] = color.getBlueByte();
        pixel[3] = (byte)(-1 - color.getAlphaByte());
        int trgPixelSize = this.getPixelSize();
        byte[] trgBuffer = this.getPixelLineBuffer2(trgPixelSize);
        int x0 = Math.max(this.clipRect.getLeft(), offsetX);
        int x1 = Math.min(this.clipRect.getLeft() + this.clipRect.getWidth(), offsetX + width);
        int y0 = Math.max(this.clipRect.getTop(), offsetY);
        int y1 = Math.min(this.clipRect.getTop() + this.clipRect.getHeight(), offsetY + height);
        int y_ = this.getHeight() - this.getOriginalHeight();
        for (int j = y0; j < y1; ++j) {
            for (int i = x0; i < x1; ++i) {
                int trgOffset = this.getDataOffset(i, y_ + j);
                byte[] newPixel = TextureImage2D.combinePixels(pixel, 0, this.pixelBytes, this, this.pixelBytes, trgBuffer, trgOffset, 1, false);
                this.setPixel(trgOffset, newPixel);
            }
        }
        if (markDirty) {
            this.update(x0, y0, x1 - x0 + 1, y1 - y0 + 1);
        }
        if (dirtyRect != null) {
            dirtyRect.set(x0, y0, x1 - x0 + 1, y1 - y0 + 1);
        }
    }

    public final void fillFullRectangle(Colorf color, boolean markDirty, Rect2i dirtyRect) {
        this.fillRectangle(color, 0, 0, this.getOriginalWidth(), this.getOriginalHeight(), markDirty, dirtyRect);
    }

    public void drawPixelLine(byte[] pixels, int pixelSize, int startX, int startY, int length, boolean markDirty, Rect2i dirtyRect) {
        if (pixelSize < 4) {
            this.clearPixelLine(pixels, pixelSize, startX, startY, length, markDirty, dirtyRect);
            return;
        }
        if (this.clipRect.getLeft() > startX + length - 1 || this.clipRect.getLeft() + this.clipRect.getWidth() - 1 < startX) {
            if (dirtyRect != null) {
                dirtyRect.set(-1, -1, 0, 0);
            }
            return;
        }
        if (this.clipRect.getTop() > startY || this.clipRect.getTop() + this.clipRect.getHeight() - 1 < startY) {
            if (dirtyRect != null) {
                dirtyRect.set(-1, -1, 0, 0);
            }
            return;
        }
        int trgPixelSize = this.getPixelSize();
        byte[] trgBuffer = this.getPixelLineBuffer2(trgPixelSize);
        int x0 = Math.max(this.clipRect.getLeft(), startX);
        int x1 = Math.min(this.clipRect.getLeft() + this.clipRect.getWidth() - 1, startX + length - 1);
        length = x1 - x0 + 1;
        int y_ = this.getHeight() - this.getOriginalHeight();
        int srcByteOffset = (x0 - startX) * pixelSize;
        int trgByteOffset = this.getDataOffset(x0, y_ + startY);
        byte[] newPixels = TextureImage2D.combinePixels(pixels, srcByteOffset, pixelSize, this, trgPixelSize, trgBuffer, trgByteOffset, length, false);
        this.setPixelLine(trgByteOffset, newPixels, srcByteOffset, length);
        if (markDirty) {
            this.update(x0, startY, x1 - x0 + 1, 1);
        }
        if (dirtyRect != null) {
            dirtyRect.set(x0, startY, x1 - x0 + 1, 1);
        }
    }

    public final void clear(TextureImage2D srcTI, int srcX, int srcY, int srcWidth, int srcHeight, int trgX, int trgY, int trgWidth, int trgHeight, boolean markDirty, Rect2i dirtyRect) {
        this.copyImageDataFrom(srcTI, srcX, srcY, srcWidth, srcHeight, trgX, trgY, trgWidth, trgHeight, true, markDirty, dirtyRect);
    }

    public final void clear(TextureImage2D srcTI, int trgX, int trgY, int trgWidth, int trgHeight, boolean markDirty, Rect2i dirtyRect) {
        this.copyImageDataFrom(srcTI, 0, 0, srcTI.getOriginalWidth(), srcTI.getOriginalHeight(), trgX, trgY, trgWidth, trgHeight, true, markDirty, dirtyRect);
    }

    public final void clear(TextureImage2D srcTI, int srcX, int srcY, int srcWidth, int srcHeight, int trgX, int trgY, boolean markDirty, Rect2i dirtyRect) {
        this.clear(srcTI, srcX, srcY, srcWidth, srcHeight, trgX, trgY, srcWidth, srcHeight, markDirty, dirtyRect);
    }

    public final void clear(TextureImage2D srcTI, Rect2i srcRect, int trgX, int trgY, boolean markDirty, Rect2i dirtyRect) {
        this.clear(srcTI, srcRect.getLeft(), srcRect.getTop(), srcRect.getWidth(), srcRect.getHeight(), trgX, trgY, markDirty, dirtyRect);
    }

    public final void clear(TextureImage2D srcTI, int trgX, int trgY, boolean markDirty, Rect2i dirtyRect) {
        this.clear(srcTI, 0, 0, srcTI.getOriginalWidth(), srcTI.getOriginalHeight(), trgX, trgY, markDirty, dirtyRect);
    }

    public final void clear(TextureImage2D srcTI, boolean markDirty, Rect2i dirtyRect) {
        this.clear(srcTI, 0, 0, srcTI.getOriginalWidth(), srcTI.getOriginalHeight(), 0, 0, markDirty, dirtyRect);
    }

    public void clearOutline(Color color, int offsetX, int offsetY, int width, int height, int lineWidth, boolean markDirty, Rect2i dirtyRect) {
        int j;
        byte[] pixel = this.getPixelLineBuffer1(this.pixelBytes);
        switch (this.pixelBytes) {
            case 4: {
                int i;
                pixel[0] = (byte)color.getRed();
                pixel[1] = (byte)color.getGreen();
                pixel[2] = (byte)color.getBlue();
                pixel[3] = (byte)color.getAlpha();
                for (i = 4; i < width * 4; i += 4) {
                    System.arraycopy(pixel, 0, pixel, i, 4);
                }
                break;
            }
            case 3: {
                int i;
                pixel[0] = (byte)color.getRed();
                pixel[1] = (byte)color.getGreen();
                pixel[2] = (byte)color.getBlue();
                for (i = 3; i < width * 3; i += 3) {
                    System.arraycopy(pixel, 0, pixel, i, 3);
                }
                break;
            }
        }
        int x0 = Math.max(this.clipRect.getLeft(), offsetX);
        int x1 = Math.min(this.clipRect.getLeft() + this.clipRect.getWidth(), offsetX + width - 1);
        int w = x1 - x0 + 1;
        int y0 = Math.max(this.clipRect.getTop(), offsetY);
        int y1 = Math.min(this.clipRect.getTop() + this.clipRect.getHeight(), offsetY + height - 1);
        int h = y1 - y0 + 1;
        int y_ = this.yUp ? 0 : this.getHeight() - this.getOriginalHeight();
        int stride = this.getWidth() * this.pixelBytes;
        int dataOffset = this.getDataOffset(x0, y_ + y0);
        for (j = 0; j < lineWidth; ++j) {
            this.setPixelLine(dataOffset, pixel, 0, w);
            dataOffset += stride;
        }
        for (j = lineWidth * 2; j < h; ++j) {
            this.setPixelLine(dataOffset, pixel, 0, lineWidth);
            this.setPixelLine(dataOffset + (w - lineWidth) * this.pixelBytes, pixel, 0, lineWidth);
            dataOffset += stride;
        }
        for (j = 0; j < lineWidth; ++j) {
            this.setPixelLine(dataOffset, pixel, 0, w);
            dataOffset += stride;
        }
        if (markDirty) {
            dirtyRect.set(x0, y0, w, lineWidth);
            dirtyRect.set(x0, y0 + lineWidth, lineWidth, h - lineWidth - lineWidth);
            dirtyRect.set(x1 - lineWidth + 1, y0 + lineWidth, lineWidth, h - lineWidth - lineWidth);
            dirtyRect.set(x0, y1 - lineWidth + 1, w, lineWidth);
        }
        if (dirtyRect != null) {
            dirtyRect.set(x0, y0, w, h);
        }
    }

    public void clear(Colorf color, int offsetX, int offsetY, int width, int height, boolean markDirty, Rect2i dirtyRect) {
        byte[] pixel = this.getPixelLineBuffer1(this.getPixelSize());
        switch (this.getPixelSize()) {
            case 4: {
                pixel[0] = color.getRedByte();
                pixel[1] = color.getGreenByte();
                pixel[2] = color.getBlueByte();
                pixel[3] = (byte)(-1 - color.getAlphaByte());
                break;
            }
            case 3: {
                pixel[0] = color.getRedByte();
                pixel[1] = color.getGreenByte();
                pixel[2] = color.getBlueByte();
                break;
            }
            case 2: {
                pixel[0] = color.getRedByte();
                pixel[1] = (byte)(-1 - color.getAlphaByte());
                break;
            }
            case 1: {
                pixel[0] = (byte)(-1 - color.getAlphaByte());
            }
        }
        int x0 = Math.max(this.clipRect.getLeft(), offsetX);
        int x1 = Math.min(this.clipRect.getLeft() + this.clipRect.getWidth() - 1, offsetX + width - 1);
        int w = x1 - x0 + 1;
        int y0 = Math.max(this.clipRect.getTop(), offsetY);
        int y1 = Math.min(this.clipRect.getTop() + this.clipRect.getHeight() - 1, offsetY + height - 1);
        int h = y1 - y0 + 1;
        if (w <= 0 || h <= 0) {
            if (dirtyRect != null) {
                dirtyRect.set(-1, -1, 0, 0);
            }
            return;
        }
        int y_ = this.yUp ? 0 : this.getHeight() - this.getOriginalHeight();
        for (int j = y0; j <= y1; ++j) {
            for (int i = x0; i <= x1; ++i) {
                this.setPixel(i, y_ + j, pixel, false, null);
            }
        }
        if (markDirty) {
            this.update(x0, y0, w, h);
        }
        if (dirtyRect != null) {
            dirtyRect.set(x0, y0, w, h);
        }
    }

    public final void clear(Colorf color, boolean markDirty, Rect2i dirtyRect) {
        this.clear(color, 0, 0, this.getOriginalWidth(), this.getOriginalHeight(), markDirty, dirtyRect);
    }

    public final void clear(int offsetX, int offsetY, int width, int height, boolean markDirty, Rect2i dirtyRect) {
        this.clear(Colorf.BLACK_TRANSPARENT, offsetX, offsetY, width, height, markDirty, dirtyRect);
    }

    public final void clear(boolean markDirty, Rect2i dirtyRect) {
        this.clear(Colorf.BLACK_TRANSPARENT, 0, 0, this.getOriginalWidth(), this.getOriginalHeight(), markDirty, dirtyRect);
    }

    public void clearPixelLine(byte[] pixels, int pixelSize, int startX, int startY, int length, boolean markDirty, Rect2i dirtyRect) {
        if (this.clipRect.getLeft() > startX + length - 1 || this.clipRect.getLeft() + this.clipRect.getWidth() - 1 < startX) {
            return;
        }
        if (this.clipRect.getTop() > startY || this.clipRect.getTop() + this.clipRect.getHeight() - 1 < startY) {
            return;
        }
        int x0 = Math.max(this.clipRect.getLeft(), startX);
        int x1 = Math.min(this.clipRect.getLeft() + this.clipRect.getWidth() - 1, startX + length - 1);
        length = x1 - x0 + 1;
        int y_ = this.getHeight() - this.getOriginalHeight();
        int srcByteOffset = (x0 - startX) * pixelSize;
        int trgByteOffset = this.getDataOffset(x0, y_ + startY);
        this.setPixelLine(trgByteOffset, pixels, srcByteOffset, length);
        if (markDirty) {
            this.update(x0, startY, x1 - x0 + 1, 1);
        }
        if (dirtyRect != null) {
            dirtyRect.set(x0, startY, x1 - x0 + 1, 1);
        }
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public TextureImage2D cloneNodeComponent(boolean forceDuplicate) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, int orgWidth, int orgHeight, boolean yUp, TextureImageInternalFormat internalFormat) {
        super(format, width, height, orgWidth, orgHeight, internalFormat);
        this.setClipRect(0, 0, width, height);
        this.pixelBytes = format.getPixelSize();
        this.yUp = yUp;
        this.setHasData(false);
        this.texCoordUR.set((float)orgWidth / (float)width, (float)orgHeight / (float)height);
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, int orgWidth, int orgHeight, boolean yUp) {
        this(format, width, height, orgWidth, orgHeight, yUp, TextureImageInternalFormat.getFallbackInternalFormat((TextureImageFormat)format));
    }

    protected TextureImage2D(TextureImageFormat format, int width, int height, int orgWidth, int orgHeight, byte[] data, int dataLength, boolean useBuffer, TextureImageInternalFormat internalFormat) {
        this(format, width, height, orgWidth, orgHeight, false, internalFormat);
        if (format.isCompressed()) {
            int imgSize = dataLength;
            this.pixelBytes = imgSize / (width * height);
            this.setHasData(true);
        } else if (dataLength <= 0) {
            this.data = null;
            this.dataBuffer = null;
            this.setHasData(false);
        }
        this.setImageData(data, dataLength, useBuffer);
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, int orgWidth, int orgHeight, byte[] data, int dataLength, TextureImageInternalFormat internalFormat) {
        this(format, width, height, orgWidth, orgHeight, data, dataLength, true, internalFormat);
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, int orgWidth, int orgHeight, byte[] data, TextureImageInternalFormat internalFormat) {
        this(format, width, height, orgWidth, orgHeight, data, data != null ? data.length : 0, true, internalFormat);
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, int orgWidth, int orgHeight, byte[] data, int dataLength) {
        this(format, width, height, orgWidth, orgHeight, data, dataLength, true, TextureImageInternalFormat.getFallbackInternalFormat((TextureImageFormat)format));
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, int orgWidth, int orgHeight, byte[] data) {
        this(format, width, height, orgWidth, orgHeight, data, data != null ? data.length : 0);
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, boolean yUp, TextureImageInternalFormat internalFormat) {
        this(format, width, height, width, height, yUp, internalFormat);
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, boolean yUp) {
        this(format, width, height, width, height, yUp);
    }

    protected TextureImage2D(TextureImageFormat format, int width, int height, byte[] data, int dataLength, boolean useBuffer, TextureImageInternalFormat internalFormat) {
        this(format, width, height, width, height, data, dataLength, useBuffer, internalFormat);
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, byte[] data, int dataLength, TextureImageInternalFormat internalFormat) {
        this(format, width, height, width, height, data, dataLength, internalFormat);
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, byte[] data, TextureImageInternalFormat internalFormat) {
        this(format, width, height, width, height, data, internalFormat);
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, byte[] data, int dataLength) {
        this(format, width, height, width, height, data, dataLength);
    }

    public TextureImage2D(TextureImageFormat format, int width, int height, byte[] data) {
        this(format, width, height, width, height, data);
    }

    public TextureImage2D(TextureImageFormat format, int orgWidth, int orgHeight, BufferedImage image, boolean yUp) {
        this(format, image.getWidth(), image.getHeight(), orgWidth, orgHeight, yUp);
        this.setImageData(image, true);
    }

    public TextureImage2D(TextureImageFormat format, BufferedImage image, boolean yUp) {
        this(format, image.getWidth(), image.getHeight(), image, yUp);
    }

    public TextureImage2D(TextureImageFormat format, BufferedImage image) {
        this(format, image.getWidth(), image.getHeight(), image, false);
    }
}

