/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;
import org.xith3d.scenegraph.primitives.Sphere;

public class Cone
extends Shape3D {
    private static GeometryType geomConstructTypeHint = GeometryType.TRIANGLE_ARRAY;
    private static final float PI_FOURTH = 0.7853982f;
    private static final float O1 = 0.7853982f;
    private static final float O2 = 1.5707964f;
    private static final float O3 = 2.3561945f;
    private static final float O4 = (float)Math.PI;
    private static final float O5 = 3.926991f;
    private static final float O6 = 4.712389f;
    private static final float O7 = 5.4977875f;
    private static final float O8 = (float)Math.PI * 2;

    public static void setGeometryConstructionTypeHint(GeometryType hint) {
        switch (hint) {
            case TRIANGLE_ARRAY: {
                geomConstructTypeHint = hint;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Currently " + Sphere.class.getSimpleName() + " does not support " + (Object)((Object)hint));
            }
        }
    }

    public static GeometryType getGeometryConstructionTypeHint() {
        return geomConstructTypeHint;
    }

    private static final Vector3f compNormal(Point3f vertex, Point3f tip, float height) {
        if (height == 0.0f) {
            return new Vector3f(0.0f, 1.0f, 0.0f);
        }
        Vector3f tmp1 = Vector3f.fromPool();
        Vector3f tmp2 = Vector3f.fromPool();
        tmp1.sub((TupleNf)vertex, (TupleNf)tip);
        tmp2.sub((TupleNf)vertex, (TupleNf)Point3f.ZERO);
        Vector3f normal = new Vector3f();
        normal.cross(tmp2, tmp1);
        normal.cross(tmp1, normal);
        normal.normalize();
        Vector3f.toPool((Vector3f)tmp2);
        Vector3f.toPool((Vector3f)tmp1);
        return normal;
    }

    private static final TexCoord2f getTexCoord(float angle) {
        float s = 0.0f;
        float t = 0.0f;
        if (angle <= 0.7853982f) {
            s = 1.0f;
            t = FastMath.sin((float)(angle * 2.0f));
            t *= 0.5f;
            t += 0.5f;
        } else if (angle <= 1.5707964f) {
            t = 1.0f;
            s = FastMath.sin((float)((1.5707964f - angle) * 2.0f));
            s *= 0.5f;
            s += 0.5f;
        } else if (angle <= 2.3561945f) {
            t = 1.0f;
            s = FastMath.sin((float)((angle - 1.5707964f) * 2.0f));
            s *= -0.5f;
            s += 0.5f;
        } else if (angle <= (float)Math.PI) {
            s = 0.0f;
            t = FastMath.sin((float)(((float)Math.PI - angle) * 2.0f));
            t *= 0.5f;
            t += 0.5f;
        } else if (angle <= 3.926991f) {
            s = 0.0f;
            t = FastMath.sin((float)((angle - (float)Math.PI) * 2.0f));
            t *= -0.5f;
            t += 0.5f;
        } else if (angle <= 4.712389f) {
            t = 0.0f;
            s = FastMath.sin((float)((4.712389f - angle) * 2.0f));
            s *= -0.5f;
            s += 0.5f;
        } else if (angle <= 5.4977875f) {
            t = 0.0f;
            s = FastMath.sin((float)((angle - 4.712389f) * 2.0f));
            s *= 0.5f;
            s += 0.5f;
        } else {
            s = 1.0f;
            t = FastMath.sin((float)(((float)Math.PI * 2 - angle) * 2.0f));
            t *= -0.5f;
            t += 0.5f;
        }
        return new TexCoord2f(s, t);
    }

    public static GeometryConstruct createGeometryConstructTA(float radius, float height, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        if (slices < 3) {
            throw new IllegalArgumentException("slices < 3");
        }
        Point3f[] vertices = new Point3f[3 * slices];
        Vector3f[] normals = new Vector3f[3 * slices];
        TexCoord2f[] texture = new TexCoord2f[3 * slices];
        Point3f tip = new Point3f(0.0f, height, 0.0f);
        int index = 0;
        for (int i = 0; i < slices; ++i) {
            float angle0 = (float)(i + 0) * ((float)Math.PI * 2 / (float)slices);
            float angle1 = (float)(i + 1) * ((float)Math.PI * 2 / (float)slices);
            vertices[index] = new Point3f(FastMath.cos((float)angle0) * radius, 0.0f, -FastMath.sin((float)angle0) * radius);
            normals[index] = Cone.compNormal(vertices[index], tip, height);
            texture[index] = Cone.getTexCoord(angle0);
            vertices[++index] = new Point3f((Tuple3f)tip);
            normals[index] = new Vector3f((Tuple3f)normals[index - 1]);
            texture[index] = new TexCoord2f(0.5f, 0.5f);
            vertices[++index] = new Point3f(FastMath.cos((float)angle1) * radius, 0.0f, -FastMath.sin((float)angle1) * radius);
            normals[index] = Cone.compNormal(vertices[index], tip, height);
            texture[index] = Cone.getTexCoord(angle1);
            ++index;
        }
        return new GeometryConstruct(GeometryType.TRIANGLE_ARRAY, (Tuple3f[])vertices, normals, texture);
    }

    public static TriangleArray createGeometryTA(float radius, float height, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gc = Cone.createGeometryConstructTA(radius, height, slices, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createTriangleArray(gc);
    }

    public static Geometry createGeometry(float radius, float height, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        switch (Cone.getGeometryConstructionTypeHint()) {
            case TRIANGLE_ARRAY: {
                return Cone.createGeometryTA(radius, height, slices, features, colorAlpha, texCoordsSize);
            }
        }
        throw new Error(Cone.getGeometryConstructionTypeHint().getCorrespondingClass().getSimpleName() + " creation is not yet implemented.");
    }

    public Cone(float radius, float height, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        super(Cone.createGeometry(radius, height, slices, features, colorAlpha, texCoordsSize));
    }

    public Cone(int slices, int features, boolean colorAlpha, int texCoordsSize) {
        this(1.0f, 1.0f, slices, features, colorAlpha, texCoordsSize);
    }

    public Cone(float radius, float height, int slices, Texture texture) {
        this(radius, height, slices, 9, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Cone(int slices, Texture texture) {
        this(1.0f, 1.0f, slices, 9, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Cone(float radius, float height, int slices, String texture) {
        this(radius, height, slices, TextureLoader.getInstance().getTexture(texture));
    }

    public Cone(int slices, String texture) {
        this(1.0f, 1.0f, slices, TextureLoader.getInstance().getTexture(texture));
    }

    public Cone(float radius, float height, int slices, Colorf color) {
        this(radius, height, slices, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Cone(int slices, Colorf color) {
        this(1.0f, 1.0f, slices, color);
    }

    public Cone(float radius, float height, int slices, Appearance app) {
        this(radius, height, slices, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Cone(int slices, Appearance app) {
        this(1.0f, 1.0f, slices, app);
    }
}

