/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.FastMath;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Billboard;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.TriangleStripArray;

public class FixedSizedBillboard
extends Shape3D
implements Billboard {
    private long lastFrameId = -9223372036854775807L;
    private final float width;
    private final float height;
    private final Point3f center;
    private final Point3f[] vertices;
    private Dim2i sizeOnScreen;
    private final float defaultBoundingRadius;
    private final Vector3f radiusPoint = new Vector3f();

    public void setTexture(Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        if (texture != null) {
            Appearance appearance = this.getAppearance(true);
            appearance.setTexture(texture);
            if (texture.getFormat() == TextureFormat.RGBA) {
                TransparencyAttributes transparency = appearance.getTransparencyAttributes(true);
                transparency.setMode(TransparencyAttributes.BLENDED);
                transparency.setTransparency(0.0f);
                appearance.setTransparencyAttributes(transparency);
            }
            this.setTexturePosition(texLowerLeft, texUpperRight);
        } else {
            Appearance appearance = this.getAppearance();
            if (appearance != null) {
                appearance.setTexture((Texture)null);
            }
        }
    }

    public void setTexturePosition(Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        TexCoord2f[] textureCoordinates = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(1.0f, 1.0f)};
        if (texLowerLeft != null) {
            textureCoordinates[0].setS(texLowerLeft.getX());
            textureCoordinates[0].setT(texLowerLeft.getY());
            textureCoordinates[1].setT(texLowerLeft.getY());
            textureCoordinates[2].setS(texLowerLeft.getX());
        }
        if (texUpperRight != null) {
            textureCoordinates[1].setS(texUpperRight.getX());
            textureCoordinates[2].setT(texUpperRight.getY());
            textureCoordinates[3].setS(texUpperRight.getX());
            textureCoordinates[3].setT(texUpperRight.getY());
        }
        TriangleStripArray geometry = this.getGeometry();
        geometry.setTextureCoordinates(0, 0, (TexCoordf<?>[])textureCoordinates);
    }

    public Sized2iRO getSizeOnScreen() {
        if (this.sizeOnScreen == null) {
            return null;
        }
        if (this.sizeOnScreen.getWidth() <= 0 || this.sizeOnScreen.getHeight() <= 0) {
            return null;
        }
        return this.sizeOnScreen;
    }

    public void setSizeOnScreen(int width, int height) {
        if (this.sizeOnScreen == null) {
            this.sizeOnScreen = new Dim2i();
        }
        this.sizeOnScreen.set(width, height);
    }

    public void updateFaceToCamera(Matrix3f viewRotation, long frameId, long nanoTime, long nanoStep) {
        if (frameId <= this.lastFrameId) {
            return;
        }
        this.lastFrameId = frameId;
        this.setDefaultVerticesValues();
        this.radiusPoint.set(this.vertices[0].getX(), 0.0f, 0.0f);
        for (int i = 0; i < this.vertices.length; ++i) {
            viewRotation.transform((Tuple3f)this.vertices[i]);
        }
        viewRotation.transform((Tuple3f)this.radiusPoint);
        ((BoundingSphere)this.getBounds()).setRadius(this.radiusPoint.length());
        this.setBoundsDirty();
        this.getGeometry().setCoordinates(0, (Tuple3f[])this.vertices);
    }

    public TriangleStripArray getGeometry() {
        return (TriangleStripArray)super.getGeometry();
    }

    private static TriangleStripArray createGeometry(Tuple3f[] coordinates) {
        TriangleStripArray geometry = new TriangleStripArray(4);
        geometry.setCoordinates(0, coordinates);
        geometry.setOptimization(Geometry.Optimization.NONE);
        return geometry;
    }

    private void setDefaultVerticesValues() {
        float x0 = this.center.getX();
        float y0 = this.center.getY();
        float z0 = this.center.getZ();
        float w0 = this.sizeOnScreen != null ? 0.5f : this.width / 2.0f;
        float h0 = this.sizeOnScreen != null ? 0.5f : this.height / 2.0f;
        this.vertices[0].set(x0 - w0, y0 - h0, z0);
        this.vertices[1].set(x0 + w0, y0 - h0, z0);
        this.vertices[2].set(x0 - w0, y0 + h0, z0);
        this.vertices[3].set(x0 + w0, y0 + h0, z0);
    }

    private static Point3f[] createVertices() {
        return new Point3f[]{new Point3f(), new Point3f(), new Point3f(), new Point3f()};
    }

    public FixedSizedBillboard(Tuple3f center, float width, float height) {
        this.center = center == null ? new Point3f() : new Point3f(center);
        this.width = width;
        this.height = height;
        this.vertices = FixedSizedBillboard.createVertices();
        this.sizeOnScreen = null;
        this.defaultBoundingRadius = FastMath.sqrt((float)(width * width + height * height)) / 2.0f;
        this.setDefaultVerticesValues();
        this.setGeometry(FixedSizedBillboard.createGeometry((Tuple3f[])this.vertices));
        this.setBounds((Bounds)new BoundingSphere((Tuple3f)this.center, this.defaultBoundingRadius));
    }
}

