/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;
import org.xith3d.scenegraph.primitives.Sphere;

public class Hemisphere
extends Shape3D {
    private static GeometryType geomConstructTypeHint = GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY;

    public static void setGeometryConstructionTypeHint(GeometryType hint) {
        switch (hint) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: 
            case INDEXED_TRIANGLE_ARRAY: 
            case TRIANGLE_STRIP_ARRAY: 
            case TRIANGLE_ARRAY: {
                geomConstructTypeHint = hint;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Currently " + Sphere.class.getSimpleName() + " does not support " + (Object)((Object)hint));
            }
        }
    }

    public static GeometryType getGeometryConstructionTypeHint() {
        return geomConstructTypeHint;
    }

    public static GeometryConstruct createGeometryConstructITSA(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        if (stacks < 2 || slices < 3) {
            throw new IllegalArgumentException("insufficient stacks or slices");
        }
        Point3f[] vertices = null;
        int[] indices = null;
        Vector3f[] normals = null;
        TexCoord2f[] texCoords = null;
        int stackLen = slices * 2 + 2;
        if ((features & 2) > 0) {
            normals = new Vector3f[(slices + 1) * (stacks + 1)];
        }
        if ((features & 8) != 0 && texCoordsSize == 2) {
            texCoords = new TexCoord2f[(slices + 1) * (stacks + 1)];
        }
        vertices = new Point3f[(slices + 1) * (stacks + 1)];
        indices = new int[stackLen * stacks];
        for (int j = 0; j < stacks + 1; ++j) {
            float angleXZl = (float)j * 1.5707964f / (float)stacks;
            float low = FastMath.sin((float)angleXZl);
            for (int i = 0; i < slices + 1; ++i) {
                float angleXY = (float)i * ((float)Math.PI * 2) / (float)slices;
                float x = FastMath.cos((float)angleXY);
                float y = FastMath.sin((float)angleXY);
                float cl = FastMath.cos((float)angleXZl);
                int k = j * (slices + 1) + i;
                vertices[k] = new Point3f(x * cl, low, -y * cl);
                if (j < stacks) {
                    int idx = j * stackLen + i * 2;
                    indices[idx + 0] = k;
                    indices[idx + 1] = k + slices + 1;
                }
                if (normals != null) {
                    normals[k] = new Vector3f((Tuple3f)vertices[k]);
                }
                if (texCoords == null) continue;
                float tx = (float)i * 1.0f / (float)slices;
                texCoords[k] = new TexCoord2f(tx, (float)(j + 0) * 1.0f / (float)stacks);
            }
        }
        Colorf[] colors = null;
        if ((features & 4) != 0) {
            colors = GeomFactory.generateColors(colorAlpha, (Tuple3f[])vertices);
        }
        int[] stripLengths = new int[stacks];
        for (int i = 0; i < stacks; ++i) {
            stripLengths[i] = indices.length / stacks;
        }
        return new GeometryConstruct(GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY, (Tuple3f[])vertices, normals, texCoords, colors, indices, stripLengths);
    }

    public static IndexedTriangleStripArray createGeometryITSA(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Hemisphere.createGeometryConstructITSA(slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createIndexedTriangleStripArray(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructITA(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Hemisphere.createGeometryConstructITSA(slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2ITA(gcITSA);
    }

    public static IndexedTriangleArray createGeometryITA(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Hemisphere.createGeometryConstructITSA(slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createITAfromITSA(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructTSA(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Hemisphere.createGeometryConstructITSA(slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2TSA(gcITSA);
    }

    public static TriangleStripArray createGeometryTSA(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Hemisphere.createGeometryConstructITSA(slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createTSAfromITSA(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructTA(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Hemisphere.createGeometryConstructITSA(slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2TA(gcITSA);
    }

    public static TriangleArray createGeometryTA(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Hemisphere.createGeometryConstructITSA(slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createTAfromITSA(gcITSA);
    }

    public static Geometry createGeometry(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        switch (Hemisphere.getGeometryConstructionTypeHint()) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: {
                return Hemisphere.createGeometryITSA(slices, stacks, features, colorAlpha, texCoordsSize);
            }
            case INDEXED_TRIANGLE_ARRAY: {
                return Hemisphere.createGeometryITA(slices, stacks, features, colorAlpha, texCoordsSize);
            }
            case TRIANGLE_STRIP_ARRAY: {
                return Hemisphere.createGeometryTSA(slices, stacks, features, colorAlpha, texCoordsSize);
            }
            case TRIANGLE_ARRAY: {
                return Hemisphere.createGeometryTA(slices, stacks, features, colorAlpha, texCoordsSize);
            }
        }
        throw new Error(Hemisphere.getGeometryConstructionTypeHint().getCorrespondingClass().getSimpleName() + " creation is not yet implemented.");
    }

    public Hemisphere(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        super(Hemisphere.createGeometry(slices, stacks, features, colorAlpha, texCoordsSize));
    }

    public Hemisphere(float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        this(slices, stacks, features, colorAlpha, texCoordsSize);
        StaticTransform.scale(this, radius);
    }

    public Hemisphere(float radius, int slices, int stacks, Texture texture) {
        this(radius, slices, stacks, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Hemisphere(float radius, int slices, int stacks, String texture) {
        this(radius, slices, stacks, TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP));
    }

    public Hemisphere(int slices, int stacks, Texture texture) {
        this(slices, stacks, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Hemisphere(int slices, int stacks, String texture) {
        this(slices, stacks, TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP));
    }

    public Hemisphere(int slices, int stacks, Colorf color) {
        this(slices, stacks, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Hemisphere(float radius, int slices, int stacks, Colorf color) {
        this(slices, stacks, color);
        StaticTransform.scale(this, radius);
    }

    public Hemisphere(int slices, int stacks, Appearance app) {
        this(slices, stacks, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Hemisphere(float radius, int slices, int stacks, Appearance app) {
        this(slices, stacks, app);
        StaticTransform.scale(this, radius);
    }
}

