/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.spatial.VertexContainer;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.PointArray;
import org.xith3d.scenegraph.PointAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph._SG_PrivilegedAccess;

public class Points
extends Shape3D {
    public float minBoundsRadius = 0.1f;
    private float[] coords;
    private Tuple3f[] points;

    public PointArray getGeometry() {
        return (PointArray)super.getGeometry();
    }

    protected void updateBoundsCheap(boolean onlyDirty, boolean childrenToo, boolean parentToo, boolean onlyWorld) {
        PointArray geom;
        if (this.isIgnoreBounds() || !this.boundsDirty && onlyDirty) {
            return;
        }
        if (this.boundsAutoCompute && !onlyWorld && (geom = this.getGeometry()) != null) {
            if (geom.isBoundsDirty() || !onlyDirty) {
                Bounds b = _SG_PrivilegedAccess.getCachedBounds(geom);
                BoundingSphere bsph = b == null ? new BoundingSphere() : (BoundingSphere)b;
                bsph.compute((VertexContainer)geom);
                if (bsph.getRadius() < this.minBoundsRadius) {
                    bsph.setRadius(this.minBoundsRadius);
                }
                _SG_PrivilegedAccess.setCachedBounds((Bounds)bsph, geom);
            }
            this.untransformedBounds.set(_SG_PrivilegedAccess.getCachedBounds(geom));
            this.bounds.set(_SG_PrivilegedAccess.getCachedBounds(geom));
        }
        super.updateBoundsCheap(onlyDirty, childrenToo, parentToo, onlyWorld);
    }

    private void setCoordinates() {
        if (this.coords == null || this.coords.length != this.points.length) {
            this.coords = new float[this.points.length * 3];
        }
        for (int i = 0; i < this.points.length; ++i) {
            this.coords[i * 3 + 0] = this.points[i].getX();
            this.coords[i * 3 + 1] = this.points[i].getY();
            this.coords[i * 3 + 2] = this.points[i].getZ();
        }
        this.getGeometry().setCoordinates(0, this.coords);
        this.setBoundsDirty();
    }

    public void setCoordinates(Tuple3f[] points) {
        this.points = points;
        this.setCoordinates();
    }

    public void setCoordinates(Tuple3f point) {
        if (this.points == null) {
            this.points = new Tuple3f[]{new Point3f()};
        } else if (this.points.length != 1) {
            this.points = new Tuple3f[]{new Point3f()};
        }
        this.points[0].set((TupleNf)point);
        this.setCoordinates();
    }

    public Tuple3f[] getCoordinates() {
        return this.points;
    }

    public Tuple3f getPoint() {
        if (this.points == null) {
            throw new NullPointerException("This PointArray doesn't contain any coordinates.");
        }
        if (this.points.length != 1) {
            throw new UnsupportedOperationException("This PointArray consists of more than one point.");
        }
        return this.points[0];
    }

    public void setColor(Colorf color) {
        this.getAppearance().getColoringAttributes().setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance().getTransparencyAttributes(true).setTransparency(color.getAlpha());
        } else {
            this.getAppearance().setTransparencyAttributes(null);
        }
    }

    public Colorf getColor() {
        return this.getAppearance().getColoringAttributes().getColor();
    }

    public void setSize(float size) {
        this.getAppearance().getPointAttributes().setPointSize(size);
    }

    public float getSize() {
        return this.getAppearance().getPointAttributes().getPointSize();
    }

    public void setAntialiasingEnabled(boolean enabled) {
        this.getAppearance().getPointAttributes().setPointAntialiasingEnabled(enabled);
    }

    public boolean isAntialiasingEnabled() {
        return this.getAppearance().getPointAttributes().isPointAntialiasingEnabled();
    }

    public Points(Tuple3f[] points, float size, boolean antiAliasing, Colorf color) {
        boolean ib = this.isIgnoreBounds();
        this.setIgnoreBounds(true);
        this.setGeometry(new PointArray(points.length));
        this.setIgnoreBounds(ib);
        this.setCoordinates(points);
        this.setAppearance(new Appearance());
        ColoringAttributes ca = new ColoringAttributes();
        ca.setShadeModel(ColoringAttributes.SHADE_FLAT);
        this.getAppearance().setColoringAttributes(ca);
        this.setColor(color);
        this.getAppearance().setPointAttributes(new PointAttributes());
        this.setSize(size);
        this.setAntialiasingEnabled(antiAliasing);
        this.updateBounds(true);
    }

    public Points(Tuple3f[] points, float size, Colorf color) {
        this(points, size, false, color);
    }

    public Points(Tuple3f point, float size, boolean antiAliasing, Colorf color) {
        this(new Tuple3f[]{point}, size, antiAliasing, color);
    }

    public Points(Tuple3f point, float size, Colorf color) {
        this(point, size, false, color);
    }
}

