/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Billboard;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.scenegraph.utils.CopyListener;

public class RectBillboard
extends Rectangle
implements Billboard {
    private long lastFrameId = -9223372036854775807L;
    protected Tuple3f[] zeroVertices;
    protected Point3f[] transformedVertices = new Point3f[]{new Point3f(), new Point3f(), new Point3f(), new Point3f()};

    public Sized2iRO getSizeOnScreen() {
        return null;
    }

    public void updateFaceToCamera(Matrix3f viewRotation, long frameId, long nanoTime, long nanoStep) {
        if (frameId <= this.lastFrameId) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            this.transformedVertices[i].set((TupleNf)this.zeroVertices[i]);
            viewRotation.transform((Tuple3f)this.transformedVertices[i]);
        }
        this.getGeometry().setCoordinates(0, (Tuple3f[])this.transformedVertices);
        this.lastFrameId = frameId;
    }

    private static void copy(RectBillboard src, RectBillboard dest) {
        dest.setAppearance(src.getAppearance());
        dest.setGeometry(src.getGeometry());
        dest.setBoundsAutoCompute(false);
        dest.setBounds(src.getBounds());
        dest.boundsDirty = true;
        dest.updateBounds(false);
        dest.setPickable(src.isPickable());
        dest.setRenderable(src.isRenderable());
    }

    public void absorbDetails(Node node) {
        RectBillboard.copy((RectBillboard)node, this);
    }

    public RectBillboard sharedCopy(CopyListener listener) {
        boolean gib = Node.globalIgnoreBounds;
        Node.globalIgnoreBounds = this.isIgnoreBounds();
        RectBillboard result = new RectBillboard(this.getWidth(), this.getHeight(), this.getTexture());
        Node.globalIgnoreBounds = gib;
        result.setColor(this.getColor());
        result.setAlpha(this.getAlpha());
        RectBillboard.copy(this, result);
        if (listener != null) {
            listener.onNodeCopied(this, result, true);
        }
        return result;
    }

    public RectBillboard sharedCopy() {
        return (RectBillboard)super.sharedCopy();
    }

    public RectBillboard(float width, float height, Tuple3f offset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        super(width, height, offset, texture, texLowerLeft, texUpperRight, color);
        this.getGeometry().setOptimization(Geometry.Optimization.NONE);
        this.zeroVertices = RectBillboard.createVertexCoords(width, height, (Tuple3f)(offset != null ? offset : new Vector3f(0.0f, 0.0f, 0.0f)));
    }

    public RectBillboard(float width, float height, Tuple3f offset, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        this(width, height, offset, TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP), texLowerLeft, texUpperRight, color);
    }

    public RectBillboard(float width, float height, String texture) {
        this(width, height, (Tuple3f)null, texture, null, null, null);
    }

    public RectBillboard(float width, float height, Tuple3f offset, String texture) {
        this(width, height, offset, texture, null, null, null);
    }

    public RectBillboard(float width, float height, float zOffset, String texture) {
        this(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), texture, null, null, null);
    }

    public RectBillboard(float width, float height, float zOffset) {
        this(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), (Texture)null, null, null, null);
    }

    public RectBillboard(float width, float height, Tuple3f offset) {
        this(width, height, offset, (Texture)null, null, null, null);
    }

    public RectBillboard(float width, float height) {
        this(width, height, null, (Texture)null, null, null, null);
    }

    public RectBillboard(float width, float height, Tuple3f offset, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, offset, texture, texLowerLeft, texUpperRight, null);
    }

    public RectBillboard(float width, float height, Texture texture) {
        this(width, height, (Tuple3f)null, texture, null, null, null);
    }

    public RectBillboard(float width, float height, Tuple3f offset, Texture texture) {
        this(width, height, offset, texture, null, null, null);
    }

    public RectBillboard(float width, float height, float zOffset, Texture texture) {
        this(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), texture, null, null, null);
    }

    public RectBillboard(float width, float height, float zOffset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), texture, texLowerLeft, texUpperRight, null);
    }

    public RectBillboard(float width, float height, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, (Tuple3f)null, texture, texLowerLeft, texUpperRight, null);
    }

    public RectBillboard(float width, float height, Tuple3f offset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, offset, texture, texLowerLeft, texUpperRight, null);
    }

    public RectBillboard(float width, float height, Tuple3f offset, Colorf color) {
        this(width, height, offset, (Texture)null, null, null, color);
    }

    public RectBillboard(float width, float height, float zOffset, Colorf color) {
        this(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), (Texture)null, null, null, color);
    }

    public RectBillboard(float width, float height, Colorf color) {
        this(width, height, null, (Texture)null, null, null, color);
    }

    public RectBillboard(float width, float height, Rectangle.ZeroPointLocation zpl, Texture texture) {
        this(width, height, RectBillboard.createPosition(width, height, zpl, 0.0f, new Vector3f()), texture, null, null, null);
    }

    public RectBillboard(Texture texture, float width, float height, Rectangle.ZeroPointLocation zpl, float zOffset) {
        this(width, height, RectBillboard.createPosition(width, height, zpl, zOffset, new Vector3f()), texture, null, null, null);
    }

    public RectBillboard(float width, float height, Rectangle.ZeroPointLocation zpl, float zOffset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, RectBillboard.createPosition(width, height, zpl, zOffset, new Vector3f()), texture, texLowerLeft, texUpperRight, null);
    }

    public RectBillboard(float width, float height, Rectangle.ZeroPointLocation zpl, String texture) {
        this(width, height, RectBillboard.createPosition(width, height, zpl, 0.0f, new Vector3f()), texture, null, null);
    }

    public RectBillboard(float width, float height, Rectangle.ZeroPointLocation zpl, float zOffset, String texture) {
        this(width, height, RectBillboard.createPosition(width, height, zpl, zOffset, new Vector3f()), texture, null, null);
    }

    public RectBillboard(float width, float height, Rectangle.ZeroPointLocation zpl, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, RectBillboard.createPosition(width, height, zpl, 0.0f, new Vector3f()), texture, texLowerLeft, texUpperRight, null);
    }

    public RectBillboard(float width, float height, Rectangle.ZeroPointLocation zpl, float zOffset) {
        this(width, height, RectBillboard.createPosition(width, height, zpl, zOffset, new Vector3f()), (Texture)null, null, null, null);
    }

    public RectBillboard(float width, float height, Rectangle.ZeroPointLocation zpl) {
        this(width, height, RectBillboard.createPosition(width, height, zpl, 0.0f, new Vector3f()), (Texture)null, null, null, null);
    }

    public RectBillboard(float width, float height, Rectangle.ZeroPointLocation zpl, float zOffset, Colorf color) {
        this(width, height, RectBillboard.createPosition(width, height, zpl, zOffset, new Vector3f()), (Texture)null, null, null, color);
    }

    public RectBillboard(float width, float height, Rectangle.ZeroPointLocation zpl, Colorf color) {
        this(width, height, RectBillboard.createPosition(width, height, zpl, 0.0f, new Vector3f()), (Texture)null, null, null, color);
    }
}

