/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.jagatoo.opengl.enums.TextureFormat;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.render.BackgroundRenderPass;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Sphere;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkySphere
extends BackgroundRenderPass {
    public static final int DEFAULT_SKY_SLICES = 16;
    public static final int DEFAULT_SKY_STACKS = 16;

    private static Texture getTextureOrNull(String texture) {
        if (texture == null) {
            return null;
        }
        Texture2D tex = TextureLoader.getInstance().getTexture(texture, null, TextureFormat.RGB, Texture.MipmapMode.BASE_LEVEL, true, false, false);
        tex.enableAutoFreeLocalData();
        return tex;
    }

    public static <G extends GroupNode> G createSkySphereGroup(int slices, int stacks, Texture texture, G group) {
        Sphere sphere = new Sphere(5.0f, slices, stacks, 9, false, 2);
        sphere.getGeometry().setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        Appearance appearance = sphere.getAppearance(true);
        appearance.setTexture(texture);
        PolygonAttributes polygonAttributes = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK);
        appearance.setPolygonAttributes(polygonAttributes);
        sphere.setAppearance(appearance);
        group.addChild(sphere);
        group.setPickableRecursive(false);
        return group;
    }

    public static BranchGroup createSkySphereGroup(int slices, int stacks, Texture texture) {
        return SkySphere.createSkySphereGroup(slices, stacks, texture, new BranchGroup());
    }

    public static final BranchGroup createSkySphereGroup(int slices, int stacks, String textureName) {
        return SkySphere.createSkySphereGroup(slices, stacks, SkySphere.getTextureOrNull(textureName));
    }

    public static final BranchGroup createSkySphereGroup(Texture texture) {
        return SkySphere.createSkySphereGroup(16, 16, texture);
    }

    public static final BranchGroup createSkySphereGroup(String textureName) {
        return SkySphere.createSkySphereGroup(16, 16, textureName);
    }

    public SkySphere(int slices, int stacks, Texture texture) {
        super(SkySphere.createSkySphereGroup(slices, stacks, texture), new BaseRenderPassConfig(View.CameraMode.VIEW_FIXED_POSITION));
    }

    public SkySphere(int slices, int stacks, String textureName) {
        this(slices, stacks, SkySphere.getTextureOrNull(textureName));
    }

    public SkySphere(Texture texture) {
        this(16, 16, texture);
    }

    public SkySphere(String textureName) {
        this(16, 16, textureName);
    }
}

