/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.atmosphere.AtmosphereFactory;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.Updater;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;

public class Sphere
extends Shape3D {
    private static GeometryType geomConstructTypeHint = GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY;
    private float radius;

    public static void setGeometryConstructionTypeHint(GeometryType hint) {
        switch (hint) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: 
            case INDEXED_TRIANGLE_ARRAY: 
            case TRIANGLE_STRIP_ARRAY: 
            case TRIANGLE_ARRAY: {
                geomConstructTypeHint = hint;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Currently " + Sphere.class.getSimpleName() + " does not support " + (Object)((Object)hint));
            }
        }
    }

    public static GeometryType getGeometryConstructionTypeHint() {
        return geomConstructTypeHint;
    }

    public static GeometryConstruct createGeometryConstructITSA(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        int i;
        if (stacks < 2 || slices < 3) {
            throw new IllegalArgumentException("insufficient stacks or slices");
        }
        Point3f[] coords = null;
        int[] indices = null;
        Vector3f[] normals = null;
        TexCoord2f[] texCoords2 = null;
        TexCoord3f[] texCoords3 = null;
        int stackLen = slices * 2 + 2;
        if ((features & 2) > 0) {
            normals = new Vector3f[(slices + 1) * (stacks + 1)];
        }
        if ((features & 8) != 0) {
            if (texCoordsSize == 2) {
                texCoords2 = new TexCoord2f[(slices + 1) * (stacks + 1)];
            } else if (texCoordsSize == 3) {
                texCoords3 = new TexCoord3f[(slices + 1) * (stacks + 1)];
            }
        }
        coords = new Point3f[(slices + 1) * (stacks + 1)];
        indices = new int[stackLen * stacks];
        for (int j = 0; j < stacks + 1; ++j) {
            float angleXZl = ((float)j - (float)stacks / 2.0f) * (float)Math.PI / (float)stacks;
            float low = FastMath.sin((float)angleXZl);
            for (int i2 = 0; i2 < slices + 1; ++i2) {
                float angleXY = (float)i2 * ((float)Math.PI * 2) / (float)slices;
                float x = FastMath.cos((float)angleXY);
                float y = FastMath.sin((float)angleXY);
                float cl = FastMath.cos((float)angleXZl);
                int k = j * (slices + 1) + i2;
                coords[k] = new Point3f(x * cl * radius, low * radius, -y * cl * radius);
                if (j < stacks) {
                    int idx = j * stackLen + i2 * 2;
                    indices[idx + 0] = k;
                    indices[idx + 1] = k + slices + 1;
                }
                if (normals != null) {
                    normals[k] = new Vector3f((Tuple3f)coords[k]);
                    normals[k].normalize();
                }
                if (texCoords2 != null) {
                    float tx = (float)i2 * 1.0f / (float)slices;
                    texCoords2[k] = new TexCoord2f(tx, (float)(j + 0) * 1.0f / (float)stacks);
                }
                if (texCoords3 == null) continue;
                float tx = (float)i2 * 1.0f / (float)slices;
                texCoords3[k] = new TexCoord3f(tx, (float)(j + 0) * 1.0f / (float)stacks, 0.0f);
            }
        }
        Colorf[] colors = null;
        if ((features & 4) != 0) {
            colors = GeomFactory.generateColors(colorAlpha, (Tuple3f[])coords);
        }
        int[] stripLengths = new int[stacks];
        for (i = 0; i < stacks; ++i) {
            stripLengths[i] = indices.length / stacks;
        }
        if (centerX != 0.0f || centerY != 0.0f || centerZ != 0.0f) {
            for (i = 0; i < coords.length; ++i) {
                coords[i].add(centerX, centerY, centerZ);
            }
        }
        if (texCoords3 != null) {
            return new GeometryConstruct(GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY, (Tuple3f[])coords, normals, texCoords3, colors, indices, stripLengths);
        }
        return new GeometryConstruct(GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY, (Tuple3f[])coords, normals, texCoords2, colors, indices, stripLengths);
    }

    public static IndexedTriangleStripArray createGeometryITSA(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Sphere.createGeometryConstructITSA(centerX, centerY, centerZ, radius, slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createIndexedTriangleStripArray(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructITA(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Sphere.createGeometryConstructITSA(centerX, centerY, centerZ, radius, slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2ITA(gcITSA);
    }

    public static IndexedTriangleArray createGeometryITA(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Sphere.createGeometryConstructITSA(centerX, centerY, centerZ, radius, slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createITAfromITSA(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructTSA(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Sphere.createGeometryConstructITSA(centerX, centerY, centerZ, radius, slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2TSA(gcITSA);
    }

    public static TriangleStripArray createGeometryTSA(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Sphere.createGeometryConstructITSA(centerX, centerY, centerZ, radius, slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createTSAfromITSA(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructTA(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Sphere.createGeometryConstructITSA(centerX, centerY, centerZ, radius, slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2TA(gcITSA);
    }

    public static TriangleArray createGeometryTA(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Sphere.createGeometryConstructITSA(centerX, centerY, centerZ, radius, slices, stacks, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createTAfromITSA(gcITSA);
    }

    public static Geometry createGeometry(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        switch (Sphere.getGeometryConstructionTypeHint()) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: {
                return Sphere.createGeometryITSA(centerX, centerY, centerZ, radius, slices, stacks, features, colorAlpha, texCoordsSize);
            }
            case INDEXED_TRIANGLE_ARRAY: {
                return Sphere.createGeometryITA(centerX, centerY, centerZ, radius, slices, stacks, features, colorAlpha, texCoordsSize);
            }
            case TRIANGLE_STRIP_ARRAY: {
                return Sphere.createGeometryTSA(centerX, centerY, centerZ, radius, slices, stacks, features, colorAlpha, texCoordsSize);
            }
            case TRIANGLE_ARRAY: {
                return Sphere.createGeometryTA(centerX, centerY, centerZ, radius, slices, stacks, features, colorAlpha, texCoordsSize);
            }
        }
        throw new Error(Sphere.getGeometryConstructionTypeHint().getCorrespondingClass().getSimpleName() + " creation is not yet implemented.");
    }

    public void setRadius(float radius, boolean scaleGeometry) {
        if (radius == this.radius) {
            return;
        }
        float scale = radius / this.radius;
        this.radius = radius;
        if (scaleGeometry) {
            StaticTransform.scale(this, scale);
        }
    }

    public final void setRadius(float radius) {
        this.setRadius(radius, true);
    }

    public final float getRadius() {
        return this.radius;
    }

    public void addAtmosphere(float percentalAtmosphereRadius, PointLight light, Updater updater) {
        AtmosphereFactory atmosFact = EffectFactory.getInstance().getAtmosphereFactory();
        if (atmosFact == null) {
            throw new Error("No AtmosphereFactory registered at org.xith3d.effects.EffectFactory!");
        }
        atmosFact.prepareAtmosphere(this, this.getRadius() * percentalAtmosphereRadius, light, updater);
    }

    public Sphere(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        super(Sphere.createGeometry(centerX, centerY, centerZ, radius, slices, stacks, features, colorAlpha, texCoordsSize));
        this.radius = radius;
    }

    public Sphere(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, Texture texture) {
        this(centerX, centerY, centerZ, radius, slices, stacks, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Sphere(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, String texture) {
        this(centerX, centerY, centerZ, radius, slices, stacks, TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP));
    }

    public Sphere(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, Appearance app) {
        this(centerX, centerY, centerZ, radius, slices, stacks, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Sphere(float centerX, float centerY, float centerZ, float radius, int slices, int stacks, Colorf color) {
        this(centerX, centerY, centerZ, radius, slices, stacks, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Sphere(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        this(0.0f, 0.0f, 0.0f, 1.0f, slices, stacks, features, colorAlpha, texCoordsSize);
    }

    public Sphere(float radius, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        this(0.0f, 0.0f, 0.0f, radius, slices, stacks, features, colorAlpha, texCoordsSize);
    }

    public Sphere(float radius, int slices, int stacks, Texture texture) {
        this(0.0f, 0.0f, 0.0f, radius, slices, stacks, texture);
    }

    public Sphere(float radius, int slices, int stacks, String texture) {
        this(0.0f, 0.0f, 0.0f, radius, slices, stacks, texture);
    }

    public Sphere(float radius, int slices, int stacks, Appearance app) {
        this(0.0f, 0.0f, 0.0f, radius, slices, stacks, app);
    }

    public Sphere(int slices, int stacks, Texture texture) {
        this(0.0f, 0.0f, 0.0f, 1.0f, slices, stacks, texture);
    }

    public Sphere(int slices, int stacks, String texture) {
        this(0.0f, 0.0f, 0.0f, 1.0f, slices, stacks, texture);
    }

    public Sphere(int slices, int stacks, Appearance app) {
        this(0.0f, 0.0f, 0.0f, 1.0f, slices, stacks, app);
    }

    public Sphere(int slices, int stacks, Colorf color) {
        this(0.0f, 0.0f, 0.0f, 1.0f, slices, stacks, color);
    }

    public Sphere(float radius, int slices, int stacks, Colorf color) {
        this(0.0f, 0.0f, 0.0f, radius, slices, stacks, color);
    }

    public static Sphere createFromSphereBody(org.openmali.spatial.bodies.Sphere sampleSphere, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        return new Sphere(sampleSphere.getCenterX(), sampleSphere.getCenterY(), sampleSphere.getCenterZ(), sampleSphere.getRadius(), slices, stacks, features, colorAlpha, texCoordsSize);
    }

    public static Sphere createFromSphereBody(org.openmali.spatial.bodies.Sphere sampleSphere, int slices, int stacks, Texture texture) {
        return new Sphere(sampleSphere.getCenterX(), sampleSphere.getCenterY(), sampleSphere.getCenterZ(), sampleSphere.getRadius(), slices, stacks, texture);
    }

    public static Sphere createFromSphereBody(org.openmali.spatial.bodies.Sphere sampleSphere, int slices, int stacks, String texture) {
        return new Sphere(sampleSphere.getCenterX(), sampleSphere.getCenterY(), sampleSphere.getCenterZ(), sampleSphere.getRadius(), slices, stacks, texture);
    }

    public static Sphere createFromSphereBody(org.openmali.spatial.bodies.Sphere sampleSphere, int slices, int stacks, Appearance app) {
        return new Sphere(sampleSphere.getCenterX(), sampleSphere.getCenterY(), sampleSphere.getCenterZ(), sampleSphere.getRadius(), slices, stacks, app);
    }

    public static Sphere createFromSphereBody(org.openmali.spatial.bodies.Sphere sampleSphere, int slices, int stacks, Colorf color) {
        return new Sphere(sampleSphere.getCenterX(), sampleSphere.getCenterY(), sampleSphere.getCenterZ(), sampleSphere.getRadius(), slices, stacks, color);
    }
}

