/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.utils;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoord1f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.TexCoord4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Geometry;

public class GeomDrawUtil {
    private Geometry geom;
    public static final int CHANGE_COORDINATES = 1;
    public static final int CHANGE_NORMALS = 2;
    public static final int CHANGE_COLORS = 4;
    public static final int CHANGE_TEXCOORDS = 8;
    private int currIndex = -1;

    public void setGeom(Geometry geom) {
        if (geom == null) {
            throw new IllegalArgumentException("geom must not be null.");
        }
        this.geom = geom;
    }

    public GeomDrawUtil(Geometry geom) {
        this.setGeom(geom);
    }

    public void drawStart(int mask) {
        this.geom.setBoundsDirty();
        this.geom.setValidVertexCount(0);
        this.currIndex = -1;
        if ((mask & 1) != 0 && this.geom.getCoordinatesData() != null) {
            this.geom.getCoordinatesData().start();
        }
        if ((mask & 2) != 0 && this.geom.getNormalsData() != null) {
            this.geom.getNormalsData().start();
        }
        if ((mask & 4) != 0 && this.geom.getColorData() != null) {
            this.geom.getColorData().start();
        }
        if ((mask & 8) != 0) {
            int[] tuSetMap = this.geom.getTexCoordSetMap();
            for (int i = 0; i < tuSetMap.length; ++i) {
                if (this.geom.getTexCoordsData(tuSetMap[i]) == null) continue;
                this.geom.getTexCoordsData(tuSetMap[i]).start();
            }
        }
    }

    public void drawStart() {
        this.drawStart(15);
    }

    public int newVertex() {
        int v = this.geom.getValidVertexCount();
        this.geom.setValidVertexCount(v + 1);
        this.currIndex = v;
        return v;
    }

    public void setCoordinate(Tuple3f p) {
        this.geom.setCoordinate(this.currIndex, p);
        this.geom.setBoundsDirty();
    }

    public void setCoordinate(float x, float y, float z) {
        this.geom.setCoordinate(this.currIndex, x, y, z);
        this.geom.setBoundsDirty();
    }

    public void setNormal(float x, float y, float z) {
        this.geom.setNormal(this.currIndex, x, y, z);
    }

    public void setNormal(Vector3f normal) {
        this.geom.setNormal(this.currIndex, normal);
    }

    public void setColor(Colorf color) {
        if (color.hasAlpha()) {
            this.geom.setColor(this.currIndex, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        } else {
            this.geom.setColor(this.currIndex, color.getRed(), color.getGreen(), color.getBlue());
        }
    }

    public void setColor(float r, float g, float b) {
        this.geom.setColor(this.currIndex, r, g, b);
    }

    public void setColor(float r, float g, float b, float a) {
        this.geom.setColor(this.currIndex, r, g, b, a);
    }

    public void setColor(byte r, byte g, byte b) {
        this.geom.setColor(this.currIndex, r, g, b);
    }

    public void setColor(byte r, byte g, byte b, byte a) {
        this.geom.setColor(this.currIndex, r, g, b, a);
    }

    public void setTexCoord(int unit, TexCoord1f t) {
        this.geom.setTextureCoordinate(unit, this.currIndex, t.getS());
    }

    public void setTexCoord(int unit, TexCoord2f t) {
        this.geom.setTextureCoordinate(unit, this.currIndex, t.getS(), t.getT());
    }

    public void setTexCoord(int unit, TexCoord3f t) {
        this.geom.setTextureCoordinate(unit, this.currIndex, t.getS(), t.getT(), t.getP());
    }

    public void setTexCoord(int unit, TexCoord4f t) {
        this.geom.setTextureCoordinate(unit, this.currIndex, t.getS(), t.getT(), t.getP(), t.getQ());
    }

    public void setTexCoord(int unit, float s) {
        this.geom.setTextureCoordinate(unit, this.currIndex, s);
    }

    public void setTexCoord(int unit, float s, float t) {
        this.geom.setTextureCoordinate(unit, this.currIndex, s, t);
    }

    public void setTexCoord(int unit, float s, float t, float p) {
        this.geom.setTextureCoordinate(unit, this.currIndex, s, t, p);
    }

    public void setTexCoord(int unit, float s, float t, float p, float q) {
        this.geom.setTextureCoordinate(unit, this.currIndex, s, t, p, q);
    }

    public void drawEnd() {
    }
}

