/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.utils;

import java.util.ArrayList;
import java.util.HashMap;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.geometry.GeometryUtils;

public final class ShapeUtils {
    public static final void setShapesTransparency(Shape3D shape, float transparency, boolean allowNullTA, boolean allowUnblended) {
        if (transparency > 0.0f) {
            TransparencyAttributes ta = shape.getAppearance(true).getTransparencyAttributes(true);
            ta.setMode(TransparencyAttributes.BLENDED);
            ta.setTransparency(transparency);
            shape.getAppearance().setTransparencyAttributes(ta);
            if (shape.getAppearance().getColoringAttributes() != null) {
                _SG_PrivilegedAccess.setChanged(shape.getAppearance().getColoringAttributes(), true);
            }
        } else {
            Appearance app = shape.getAppearance();
            if (app == null) {
                return;
            }
            TransparencyAttributes ta = app.getTransparencyAttributes();
            if (ta == null) {
                return;
            }
            if (allowNullTA) {
                app.setTransparencyAttributes(null);
                return;
            }
            if (allowUnblended) {
                ta.setMode(TransparencyAttributes.NONE);
            }
            ta.setTransparency(0.0f);
        }
    }

    public static final float getShapesTransparency(Shape3D shape) {
        Appearance app = shape.getAppearance();
        if (app == null) {
            return 0.0f;
        }
        TransparencyAttributes ta = app.getTransparencyAttributes();
        if (ta == null) {
            return 0.0f;
        }
        if (ta.getMode() == TransparencyAttributes.NONE) {
            return 0.0f;
        }
        return ta.getTransparency();
    }

    public static void setTransparency(Node node, float transparency) {
        if (node instanceof Shape3D) {
            if (((Shape3D)node).getAppearance(true).getTransparencyAttributes() == null) {
                ((Shape3D)node).getAppearance(true).setTransparencyAttributes(new TransparencyAttributes(TransparencyAttributes.BLENDED, transparency));
            } else {
                ((Shape3D)node).getAppearance(true).getTransparencyAttributes().setTransparency(transparency);
            }
        } else if (node instanceof GroupNode) {
            GroupNode group = (GroupNode)node;
            int numChildren = group.numChildren();
            for (int i = 0; i < numChildren; ++i) {
                Node child = group.getChild(i);
                if (!(child instanceof Shape3D) && !(child instanceof GroupNode)) continue;
                ShapeUtils.setTransparency(child, transparency);
            }
        }
    }

    private static Group mergeShapes(boolean useIndex, Shape3D ... shapes) {
        HashMap<Appearance, ArrayList<Shape3D>> appShapeMap = new HashMap<Appearance, ArrayList<Shape3D>>();
        for (Shape3D shape : shapes) {
            Appearance app = shape.getAppearance();
            ArrayList<Shape3D> mappedShapes = (ArrayList<Shape3D>)appShapeMap.get(app);
            if (mappedShapes == null) {
                mappedShapes = new ArrayList<Shape3D>();
                appShapeMap.put(app, mappedShapes);
            }
            mappedShapes.add(shape);
        }
        Group group = new Group();
        for (ArrayList shapesList : appShapeMap.values()) {
            Geometry[] geoms = new Geometry[shapesList.size()];
            for (int i = 0; i < shapesList.size(); ++i) {
                geoms[i] = ((Shape3D)shapesList.get(i)).getGeometry();
            }
            Geometry geom = useIndex ? GeometryUtils.mergeGeometriesITA(geoms) : GeometryUtils.mergeGeometriesTA(geoms);
            group.addChild(new Shape3D(geom, ((Shape3D)shapesList.get(0)).getAppearance()));
        }
        return group;
    }

    public static Group mergeShapesTA(Shape3D ... shapes) {
        return ShapeUtils.mergeShapes(false, shapes);
    }

    public static Group mergeShapesITA(Shape3D ... shapes) {
        return ShapeUtils.mergeShapes(true, shapes);
    }
}

