/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.utils;

import java.util.Stack;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.BackgroundSound;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.ExponentialFog;
import org.xith3d.scenegraph.Fog;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.LinearFog;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.OrderedGroup;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.PointSound;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Sound;
import org.xith3d.scenegraph.SpotLight;
import org.xith3d.scenegraph.Switch;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.traversal.DetailedTraversalCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeCloner
implements DetailedTraversalCallback {
    private final Stack<GroupNode> nodeStack = new Stack();
    private GroupNode root = null;

    protected final void add(Node node) {
        if (!this.nodeStack.isEmpty()) {
            this.nodeStack.peek().addChild(node);
        }
        if (node instanceof GroupNode) {
            this.nodeStack.push((GroupNode)node);
            if (this.root == null) {
                this.root = (GroupNode)node;
            }
        }
    }

    @Override
    public boolean traversalOperationCommon(Node node) {
        return true;
    }

    @Override
    public boolean traversalOperationCommon(GroupNode node) {
        return true;
    }

    @Override
    public boolean traversalCheckGroupCommon(GroupNode group) {
        return true;
    }

    @Override
    public boolean traversalCheckGroup(BranchGroup bg) {
        return true;
    }

    @Override
    public boolean traversalCheckGroup(Group group) {
        return true;
    }

    @Override
    public boolean traversalCheckGroup(Switch sw) {
        return true;
    }

    @Override
    public boolean traversalCheckGroup(TransformGroup tg) {
        return true;
    }

    @Override
    public boolean traversalCheckGroup(OrderedGroup og) {
        return true;
    }

    @Override
    public boolean traversalOperation(Node node) {
        return true;
    }

    @Override
    public boolean traversalOperation(BranchGroup bg) {
        this.add(new BranchGroup());
        return true;
    }

    @Override
    public boolean traversalOperation(Group group) {
        this.add(new Group());
        return true;
    }

    @Override
    public boolean traversalOperation(TransformGroup tg) {
        this.add(new TransformGroup(tg.getTransform()));
        return true;
    }

    @Override
    public boolean traversalOperation(OrderedGroup og) {
        this.add(new OrderedGroup());
        return true;
    }

    @Override
    public boolean traversalOperation(Switch sw) {
        this.add(new Switch(sw.getWhichChild()));
        return true;
    }

    @Override
    public boolean traversalOperation(Shape3D shape) {
        this.add(new Shape3D(shape.getGeometry(), shape.getAppearance()));
        return true;
    }

    @Override
    public boolean traversalOperation(Light light) {
        if (light instanceof DirectionalLight) {
            DirectionalLight dirLight = (DirectionalLight)light;
            this.add(new DirectionalLight(dirLight.isEnabled(), dirLight.getColor(), dirLight.getDirection()));
        } else if (light instanceof SpotLight) {
            SpotLight spotLight = (SpotLight)light;
            this.add(new SpotLight(spotLight.isEnabled(), spotLight.getColor(), (Tuple3f)spotLight.getLocation(), spotLight.getAttenuation(), (Tuple3f)spotLight.getDirection(), spotLight.getSpreadAngle(), spotLight.getConcentration()));
        } else if (light instanceof PointLight) {
            PointLight pointLight = (PointLight)light;
            this.add(new PointLight(pointLight.isEnabled(), pointLight.getColor(), (Tuple3f)pointLight.getLocation(), pointLight.getAttenuation()));
        } else {
            throw new Error(light.getClass().getName() + " is not yet supported for cloning.");
        }
        return true;
    }

    @Override
    public boolean traversalOperation(Fog fog) {
        if (fog instanceof LinearFog) {
            LinearFog linFog = (LinearFog)fog;
            this.add(new LinearFog(linFog.getColor(), linFog.getFrontDistance(), linFog.getBackDistance()));
        } else if (fog instanceof ExponentialFog) {
            ExponentialFog expFog = (ExponentialFog)fog;
            this.add(new ExponentialFog(expFog.getColor(), expFog.getDensity()));
        } else {
            throw new Error(fog.getClass().getName() + " is not yet supported for cloning.");
        }
        return true;
    }

    @Override
    public boolean traversalOperation(Sound sound) {
        if (sound instanceof BackgroundSound) {
            BackgroundSound bgSound = (BackgroundSound)sound;
            this.add(new BackgroundSound(bgSound.getSoundContainer(), bgSound.getInitialGain()));
        } else if (sound instanceof PointSound) {
            PointSound pSound = (PointSound)sound;
            this.add(new PointSound(pSound.getSoundContainer(), pSound.getInitialGain()));
        } else {
            throw new Error(sound.getClass().getName() + " is not yet supported for cloning.");
        }
        return true;
    }

    @Override
    public boolean traversalOperationCommonAfter(Node node) {
        return true;
    }

    @Override
    public boolean traversalOperationCommonAfter(GroupNode group) {
        this.nodeStack.pop();
        return true;
    }

    @Override
    public boolean traversalOperationAfter(BranchGroup bg) {
        return true;
    }

    @Override
    public boolean traversalOperationAfter(Group group) {
        return true;
    }

    @Override
    public boolean traversalOperationAfter(TransformGroup tg) {
        return true;
    }

    @Override
    public boolean traversalOperationAfter(OrderedGroup og) {
        return true;
    }

    @Override
    public boolean traversalOperationAfter(Node node) {
        return true;
    }

    @Override
    public boolean traversalOperationAfter(Switch sw) {
        return true;
    }

    @Override
    public boolean traversalOperationAfter(Shape3D shape) {
        return true;
    }

    @Override
    public boolean traversalOperationAfter(Light light) {
        return true;
    }

    @Override
    public boolean traversalOperationAfter(Fog fog) {
        return true;
    }

    @Override
    public boolean traversalOperationAfter(Sound sound) {
        return true;
    }

    public <GroupNodeExtension extends GroupNode> GroupNodeExtension cloneTree(GroupNodeExtension root) {
        this.root = null;
        this.nodeStack.clear();
        root.traverse(this);
        GroupNode result = this.root;
        this.root = null;
        this.nodeStack.clear();
        return (GroupNodeExtension)result;
    }
}

