/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.schedops.movement;

import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animatable;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;

public abstract class Bullet
extends TransformGroup
implements Animatable {
    private Vector3f velocity = null;
    private Tuple3f location = null;
    private long birthTime = -1L;
    private long lifeTime = -1L;
    private long maxLifeTime;
    private boolean alive;

    public boolean isAnimating() {
        return false;
    }

    public void startAnimation(long gameTime, UpdatingThread.TimingMode timingMode) {
        this.birthTime = gameTime;
    }

    public void stopAnimation() {
        throw new UnsupportedOperationException("A Bullet's animation cannot be stopped. Use setAlive() instead.");
    }

    public boolean isPersistent() {
        return true;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public void setVelocity(Vector3f velocity) {
        this.velocity = velocity;
    }

    public Vector3f getVelocity() {
        return this.velocity;
    }

    public void setLocation(Tuple3f location) {
        this.location = location;
        Transform3D t3d = this.getTransform();
        t3d.setTranslation(location);
        this.setTransform(t3d);
    }

    public Tuple3f getLocation() {
        return this.location;
    }

    public float getSpeed() {
        return this.velocity.length();
    }

    public void setSpeed(float speed) {
        this.velocity.normalize();
        this.velocity.scale(speed);
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        this.lifeTime = gameTime - this.birthTime;
        if (this.lifeTime < this.maxLifeTime) {
            Tuple3f loc = this.getLocation();
            float factor = timingMode.getSecondsAsFloat(frameTime) * 2.0f;
            loc.set(loc.getX() + this.velocity.getX() * factor, loc.getY() + this.velocity.getY() * factor, loc.getZ() + this.velocity.getZ() * factor);
            this.setLocation(loc);
        } else {
            this.setAlive(false);
        }
    }

    public void setMaxLifeTime(long maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }

    public long getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
        if (!alive && this.getParent() != null) {
            this.detach();
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    public Bullet(Vector3f velocity, long maxLifeTime) {
        this.setVelocity(velocity);
        this.setLocation((Tuple3f)new Vector3f(0.0f, 0.0f, 0.0f));
        this.setAlive(true);
        this.setMaxLifeTime(maxLifeTime);
    }
}

