/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.schedops.movement;

import java.util.ArrayList;
import java.util.Random;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animatable;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.schedops.movement.TransformationDirectives;

public abstract class GroupAnimator
implements Animatable {
    private TransformationDirectives tfDirecs;
    protected final ArrayList<Transformable> transformNodes = new ArrayList();
    protected Transform3D t3dMain;
    private boolean isAnimating = false;
    private boolean isAlive = true;
    protected static Random rnd = new Random(System.currentTimeMillis());

    public TransformationDirectives getTransformationDirectives() {
        return this.tfDirecs;
    }

    public void setTransformationDirectives(TransformationDirectives tfDirecs) {
        this.tfDirecs = tfDirecs;
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }

    public void startAnimation(long gameTime, UpdatingThread.TimingMode timingMode) {
        this.isAnimating = true;
    }

    public void stopAnimation() {
        this.isAnimating = false;
    }

    public abstract boolean animate(long var1, long var3, UpdatingThread.TimingMode var5);

    public final void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        this.animate(gameTime, frameTime, timingMode);
    }

    public final boolean isPersistent() {
        return true;
    }

    public final void setAlive(boolean alive) {
        this.isAlive = alive;
    }

    public final boolean isAlive() {
        return this.isAlive;
    }

    public final void setTransform(Transform3D transform) {
        for (int i = 0; i < this.transformNodes.size(); ++i) {
            this.transformNodes.get(i).setTransform(transform);
        }
        this.t3dMain = transform;
    }

    public final void setTranslation(float transX, float transY, float transZ) {
        this.t3dMain.setTranslation(transX, transY, transZ);
        for (int i = 0; i < this.transformNodes.size(); ++i) {
            this.transformNodes.get(i).setTransform(this.t3dMain);
        }
    }

    public final void setTranslation(Vector3f translation) {
        this.setTranslation(translation.getX(), translation.getY(), translation.getZ());
    }

    public final void setScale(float factor) {
        this.t3dMain.setScale(factor);
        for (int i = 0; i < this.transformNodes.size(); ++i) {
            this.transformNodes.get(i).setTransform(this.t3dMain);
        }
    }

    public final int getNumTransformNodes() {
        return this.transformNodes.size();
    }

    public final void addTransformNode(Transformable tn) {
        this.transformNodes.add(tn);
        this.t3dMain = tn.getTransform();
        this.t3dMain.setIdentity();
        this.setTransform(this.t3dMain);
    }

    public final void setTransformNode(int index, Transformable tn) {
        if (this.transformNodes.size() > index) {
            this.transformNodes.set(index, tn);
        } else {
            this.transformNodes.add(index, tn);
        }
        this.t3dMain = tn.getTransform();
        this.t3dMain.setIdentity();
        this.setTransform(this.t3dMain);
    }

    public final void setTransformNode(Transformable tn) {
        this.setTransformNode(0, tn);
    }

    public final Transformable getTransformNode(int index) {
        if (this.transformNodes.size() <= index) {
            return null;
        }
        return this.transformNodes.get(index);
    }

    public final Transformable getTransformNode() {
        return this.getTransformNode(0);
    }

    public GroupAnimator(TransformationDirectives tfDirecs) {
        this.setTransformationDirectives(tfDirecs);
    }

    public GroupAnimator(Transformable tn, TransformationDirectives tfDirecs) {
        this(tfDirecs);
        if (tn != null) {
            this.setTransformNode(tn);
        }
    }
}

