/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.schedops.values;

import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.schedops.values.Adjuster;
import org.xith3d.utility.properties.FloatProperty;

public class KeyFloatAdjuster
extends Adjuster {
    private FloatProperty data;
    private Key ADD_KEY;
    private Key SUB_KEY;
    private Key PRINT_KEY;
    private boolean ADD_PRESSED;
    private boolean SUB_PRESSED;
    private float speed;
    private Adjuster.Mode mode;
    private Keyboard keyboard;

    public KeyFloatAdjuster(String name, FloatProperty data, float speed, Adjuster.Mode mode, Keyboard keyboard) {
        this(name, data, speed, mode, keyboard, Keys.NUMPAD_ADD, Keys.NUMPAD_SUBTRACT, Keys.NUMPAD_ENTER);
    }

    public KeyFloatAdjuster(String name, FloatProperty data, float speed, Adjuster.Mode mode, Keyboard keyboard, Key ADD_KEY, Key SUB_KEY, Key DISP_KEY) {
        this.name = name;
        this.data = data;
        this.speed = speed;
        this.mode = mode;
        this.keyboard = keyboard;
        this.ADD_KEY = ADD_KEY;
        this.SUB_KEY = SUB_KEY;
        this.PRINT_KEY = DISP_KEY;
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        this.changed = false;
        float delta = (float)timingMode.getMilliSeconds(frameTime) / 1000.0f * this.speed;
        if (this.keyboard.isKeyPressed(this.PRINT_KEY)) {
            this.getState();
        }
        switch (this.mode) {
            case SEQUENTIAL: {
                if (this.ADD_PRESSED) {
                    if (!this.keyboard.isKeyPressed(this.ADD_KEY)) {
                        this.add(delta);
                        this.changed = true;
                        this.ADD_PRESSED = false;
                    }
                } else if (!this.keyboard.isKeyPressed(this.ADD_KEY)) {
                    this.ADD_PRESSED = true;
                }
                if (this.SUB_PRESSED) {
                    if (this.keyboard.isKeyPressed(this.SUB_KEY)) break;
                    this.add(delta);
                    this.changed = true;
                    this.SUB_PRESSED = false;
                    break;
                }
                if (this.keyboard.isKeyPressed(this.SUB_KEY)) break;
                this.SUB_PRESSED = true;
                break;
            }
            case CONTINUOUS: {
                if (this.keyboard.isKeyPressed(this.ADD_KEY)) {
                    this.add(delta);
                    this.changed = true;
                }
                if (!this.keyboard.isKeyPressed(this.SUB_KEY)) break;
                this.sub(delta);
                this.changed = true;
                break;
            }
        }
    }

    private void sub(float delta) {
        this.data.setFloat(this.data.getFloat() - delta);
    }

    private void add(float delta) {
        this.data.setFloat(this.data.getFloat() + delta);
    }

    public String getState() {
        return this.data.toString();
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }
}

