/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.xith3d.scenegraph.Node;
import org.xith3d.selection.Selectable;
import org.xith3d.selection.SelectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeSelectable<NodeType extends Node>
implements Selectable {
    private NodeType node;
    private HashMap<Class<?>, ArrayList<Object>> lookup = new HashMap();
    private boolean selected;
    private boolean selectedContext;

    @Override
    public <T> T get(Class<T> type) {
        ArrayList<Object> list = this.lookup.get(type);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    public <T> List<T> lookup(Class<T> type) {
        ArrayList<Object> list = this.lookup.get(type);
        if (list == null || list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public void register(Object object) {
        ArrayList types = new ArrayList(20);
        Class<?> currentClass = object.getClass();
        do {
            types.add(currentClass);
            Class<?>[] interfaces = currentClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                types.add(interfaces[i++]);
            }
        } while ((currentClass = currentClass.getSuperclass()) != Object.class);
        for (int i = 0; i < types.size(); ++i) {
            Class type = (Class)types.get(i);
            ArrayList<Object> list = this.lookup.get(type);
            if (list == null) {
                list = new ArrayList(4);
                this.lookup.put(type, list);
            }
            list.add(object);
        }
    }

    public void deregister(Object object) {
        ArrayList<Object> list;
        Class<?> type;
        int i;
        Class<?>[] interfaces = object.getClass().getInterfaces();
        Class<?>[] classes = object.getClass().getClasses();
        for (i = 0; i < interfaces.length; ++i) {
            type = interfaces[i];
            list = this.lookup.get(type);
            if (list == null) continue;
            list.remove(object);
            if (list.size() != 0) continue;
            this.lookup.remove(type);
        }
        for (i = 0; i < classes.length; ++i) {
            type = classes[i];
            list = this.lookup.get(type);
            if (list == null) continue;
            list.remove(object);
            if (list.size() != 0) continue;
            this.lookup.remove(type);
        }
    }

    public NodeType getNode() {
        return this.node;
    }

    @Override
    public boolean isSelectionBound() {
        return true;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isSelectedContext() {
        return this.selectedContext;
    }

    @Override
    public void setSelected(SelectionManager selectionManager, boolean selected) {
        this.selected = selected;
    }

    @Override
    public void setSelectedContext(SelectionManager selectionManager, boolean selected) {
        this.selectedContext = selected;
    }

    public AbstractNodeSelectable(NodeType node) {
        this.node = node;
    }
}

