/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.MouseButtonClickedEvent;
import org.jagatoo.input.events.MouseButtonEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.listeners.MouseListener;
import org.openmali.vecmath2.Point2i;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple2i;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.picking.AllPickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.picking.PickingLibrary;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.selection.ContextMenuProvider;
import org.xith3d.selection.MovementConstraints;
import org.xith3d.selection.Selectable;
import org.xith3d.selection.SelectionListener;
import org.xith3d.selection.ViewConstraints;
import org.xith3d.ui.hud.listeners.HUDPickMissedListener;
import org.xith3d.ui.hud.utils.HUDPickResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionManager
implements MouseListener,
AllPickListener,
HUDPickMissedListener {
    public static final int HUD_PICK_MISSED_MASK = HUDPickResult.HUDPickReason.BUTTON_PRESSED_MASK | HUDPickResult.HUDPickReason.BUTTON_RELEASED_MASK;
    private BranchGroup selectionLayer = new BranchGroup();
    private MovementConstraints movementContraints = new ViewConstraints();
    private HashSet<Selectable> selection = new HashSet();
    private HashSet<Selectable> selectedContext = new HashSet();
    private BranchGroup pickableBranch;
    private RenderPassConfig pickablePassConfig;
    private ArrayList<GroupNode> pickableGroups = new ArrayList();
    private Canvas3D canvas;
    private ArrayList<SelectionListener> selectionListeners = new ArrayList();
    private ContextMenuProvider contextMenuProvider;
    private Point2i pickLocation = new Point2i();
    private Point2i lastMouseCoords = new Point2i();
    private Point3f lastPosition = new Point3f();
    private MouseButton contextMenuTrigger = MouseButtons.RIGHT_BUTTON;
    private MouseButton movementTrigger = MouseButtons.LEFT_BUTTON;
    private MouseButton selectionTrigger = MouseButtons.LEFT_BUTTON;
    private boolean movementTriggerDown;

    public Point2i getLastMouseCoords() {
        return this.lastMouseCoords;
    }

    public Point3f getLastPosition() {
        return this.lastPosition;
    }

    public MouseButton getContextMenuTrigger() {
        return this.contextMenuTrigger;
    }

    public void setContextMenuTrigger(MouseButton contextMenuTrigger) {
        this.contextMenuTrigger = contextMenuTrigger;
    }

    public MouseButton getSelectionTrigger() {
        return this.selectionTrigger;
    }

    public void setSelectionTrigger(MouseButton selectionTrigger) {
        this.selectionTrigger = selectionTrigger;
    }

    public BranchGroup getSelectionLayer() {
        return this.selectionLayer;
    }

    public MouseButton getMovementTrigger() {
        return this.movementTrigger;
    }

    public void setMovementTrigger(MouseButton movementTrigger) {
        this.movementTrigger = movementTrigger;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public boolean removeSelectionListener(SelectionListener listener) {
        return this.selectionListeners.remove(listener);
    }

    public void setContextMenuProvider(ContextMenuProvider provider) {
        this.contextMenuProvider = provider;
    }

    public ContextMenuProvider getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    public MovementConstraints getMovementConstraints() {
        return this.movementContraints;
    }

    public void setMovementConstraints(MovementConstraints movementConstraints) {
        this.movementContraints = movementConstraints;
    }

    public void bind(BranchGroup pickableBranch, RenderPassConfig rpc, Canvas3D canvas) {
        SceneGraph sceneGraph = pickableBranch.getSceneGraph();
        if (sceneGraph == null) {
            throw new IllegalStateException("You can only bind a SelectionManager to a branch contained in a SceneGraph!");
        }
        this.pickableBranch = pickableBranch;
        this.pickablePassConfig = rpc;
        this.pickableGroups.clear();
        this.pickableGroups.add(pickableBranch);
        this.canvas = canvas;
        sceneGraph.removeBranchGraph(this.selectionLayer);
        this.selectionLayer.removeAllChildren();
        RenderPass selectionPass = sceneGraph.addPerspectiveBranch(this.selectionLayer);
        selectionPass.setLayeredModeForced(true);
    }

    public void bind(BranchGroup pickableBranch, Canvas3D canvas) {
        this.bind(pickableBranch, null, canvas);
    }

    public void unbind() {
        SceneGraph sceneGraph = this.pickableBranch.getSceneGraph();
        if (sceneGraph != null) {
            sceneGraph.removeBranchGraph(this.selectionLayer);
            this.selectionLayer.removeAllChildren();
            this.pickableBranch = null;
            this.canvas = null;
            this.pickablePassConfig = null;
        }
    }

    protected void changeSelection(Selectable selectable, boolean replace) {
        Selectable sel;
        int i;
        if (this.selection.contains(selectable)) {
            return;
        }
        if (replace) {
            if (this.selection.size() > 0) {
                for (Selectable sel2 : this.selection) {
                    sel2.setSelected(this, false);
                }
                this.selection.clear();
            }
            if (this.selectedContext.size() > 0) {
                for (Selectable sel2 : this.selectedContext) {
                    sel2.setSelectedContext(this, false);
                }
                this.selectedContext.clear();
            }
            if (this.selection.size() > 0 || this.selectedContext.size() > 0) {
                for (int i2 = 0; i2 < this.selectionListeners.size(); ++i2) {
                    SelectionListener listener = this.selectionListeners.get(i2);
                    listener.selectionChanged(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
                }
            }
        }
        if (selectable == null) {
            return;
        }
        this.selection.add(selectable);
        Selectable selectionBound = null;
        Node current = selectable.getNode();
        while ((current = current.getParent()) != null) {
            Selectable currentSelectable;
            if (current instanceof Selectable) {
                currentSelectable = (Selectable)((Object)current);
                if (!this.selection.contains(currentSelectable)) {
                    this.selectedContext.add(currentSelectable);
                }
                if (!currentSelectable.isSelectionBound()) break;
                selectionBound = currentSelectable;
                break;
            }
            currentSelectable = (Selectable)current.getUserData(Selectable.class);
            if (currentSelectable == null) continue;
            if (!this.selection.contains(currentSelectable)) {
                this.selectedContext.add(currentSelectable);
            }
            if (!currentSelectable.isSelectionBound()) break;
            selectionBound = currentSelectable;
            break;
        }
        if (selectable.getNode() instanceof Group) {
            this.findSelectableChilden((Group)selectable.getNode());
        }
        ArrayList<Selectable> tmpSelection = new ArrayList<Selectable>(this.selection.size());
        ArrayList<Selectable> tmpSelectedContext = new ArrayList<Selectable>(this.selection.size());
        tmpSelection.addAll(this.selection);
        tmpSelectedContext.addAll(this.selectedContext);
        for (i = 0; i < tmpSelection.size(); ++i) {
            sel = (Selectable)tmpSelection.get(i);
            sel.setSelected(this, true);
        }
        for (i = 0; i < tmpSelectedContext.size(); ++i) {
            sel = (Selectable)tmpSelectedContext.get(i);
            sel.setSelectedContext(this, true);
        }
        for (i = 0; i < this.selectionListeners.size(); ++i) {
            SelectionListener listener = this.selectionListeners.get(i);
            listener.selectionChanged(tmpSelection, tmpSelectedContext);
        }
    }

    public boolean isBound() {
        return this.pickableBranch != null && this.canvas != null;
    }

    private Selectable findSelectable(PickResult pickResult) {
        Node current = pickResult.getPickHostOrNode();
        do {
            if (current instanceof Selectable) {
                return (Selectable)((Object)current);
            }
            Selectable currentSelectable = (Selectable)current.getUserData(Selectable.class);
            if (currentSelectable == null) continue;
            return currentSelectable;
        } while ((current = current.getParent()) != null);
        return null;
    }

    private void findSelectableChilden(Group group) {
        int l = group.numChildren();
        for (int i = 0; i < l; ++i) {
            Selectable currentSelectable;
            boolean skipChildren = false;
            Node current = group.getChild(i);
            if (current instanceof Selectable) {
                skipChildren = true;
                if (!this.selection.contains(current)) {
                    this.selectedContext.add((Selectable)((Object)current));
                }
            }
            if ((currentSelectable = (Selectable)current.getUserData(Selectable.class)) != null) {
                skipChildren = true;
                if (!this.selection.contains(currentSelectable)) {
                    this.selectedContext.add(currentSelectable);
                }
            }
            if (skipChildren || !(current instanceof Group)) continue;
            this.findSelectableChilden((Group)current);
        }
    }

    private void pick(int x, int y, MouseButton button) {
        if (this.isBound() && (button == this.selectionTrigger || button == this.contextMenuTrigger)) {
            this.pickLocation.set(x, y);
            if (this.pickablePassConfig != null) {
                PickingLibrary.pickAll(this.pickablePassConfig, this.pickableGroups, this.canvas, button, x, y, this, null);
            } else {
                PickingLibrary.pickAll(this.pickableBranch, this.canvas, button, x, y, (AllPickListener)this);
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.lastMouseCoords.set(e.getX(), e.getY());
        if (!e.getMouse().isAbsolute()) {
            this.pick(e.getMouse().getSourceWindow().getWidth() / 2, e.getMouse().getSourceWindow().getHeight() / 2, button);
        }
    }

    @Override
    public void onHUDPickMissed(MouseButton button, int x, int y, HUDPickResult.HUDPickReason pickReason, long when, long meta) {
        if (pickReason == HUDPickResult.HUDPickReason.BUTTON_PRESSED) {
            this.pick(this.lastMouseCoords.getX(), this.lastMouseCoords.getY(), button);
        }
    }

    public void onMouseButtonReleased(MouseButtonReleasedEvent e, MouseButton button) {
    }

    public void onMouseButtonClicked(MouseButtonClickedEvent e, MouseButton button, int clickCount) {
    }

    public void onMouseButtonStateChanged(MouseButtonEvent e, MouseButton button, boolean state) {
        if (button == this.movementTrigger) {
            this.movementTriggerDown = state;
        }
    }

    public void onMouseMoved(MouseMovedEvent e, int x, int y, int dx, int dy) {
        if (this.movementTriggerDown && this.selection.size() > 0) {
            ArrayList<Selectable> tmpSelection = new ArrayList<Selectable>(this.selection.size());
            ArrayList<Selectable> tmpSelectedContext = new ArrayList<Selectable>(this.selection.size());
            tmpSelection.addAll(this.selection);
            tmpSelectedContext.addAll(this.selectedContext);
            Point3f newPosition = Point3f.fromPool();
            Vector3f delta = Vector3f.fromPool();
            if (this.movementContraints != null) {
                this.movementContraints.computeNewPosition(this.pickablePassConfig, this.canvas, x, y, this.lastPosition, newPosition);
                delta.set((TupleNf)newPosition);
                delta.sub((TupleNf)this.lastPosition);
                this.lastPosition.set((TupleNf)newPosition);
            } else {
                delta.set((float)(x - this.lastMouseCoords.getX()), (float)(y - this.lastMouseCoords.getY()), 0.0f);
            }
            for (Selectable sel : this.selection) {
                sel.onMoved(this, delta);
            }
            for (int i = 0; i < this.selectionListeners.size(); ++i) {
                SelectionListener listener = this.selectionListeners.get(i);
                listener.selectionMoved(tmpSelection, tmpSelectedContext, delta);
            }
            Point3f.toPool((Point3f)newPosition);
            Vector3f.toPool((Vector3f)delta);
        }
        this.lastMouseCoords.set(x, y);
    }

    public void onMouseWheelMoved(MouseWheelEvent e, int wheelDelta) {
    }

    @Override
    public void onPickingMissed(Object userObject, long pickTime) {
        this.changeSelection(null, true);
    }

    @Override
    public void onObjectsPicked(List<PickResult> pickResults, Object userObject, long pickTime) {
        PickResult nearest = null;
        Selectable nearestSelectable = null;
        for (int i = 0; i < pickResults.size(); ++i) {
            PickResult pickResult = pickResults.get(i);
            Selectable pickedSelectable = this.findSelectable(pickResult);
            if (pickedSelectable == null || nearest != null && !(pickResult.getMinimumDistance() < nearest.getMinimumDistance())) continue;
            nearest = pickResult;
            nearestSelectable = pickedSelectable;
        }
        if (nearest != null) {
            this.lastPosition.set((TupleNf)nearest.getPos());
            this.changeSelection(nearestSelectable, true);
            if (nearest.getButton() == this.contextMenuTrigger && this.contextMenuProvider != null) {
                ArrayList<Selectable> tmpSelection = new ArrayList<Selectable>(this.selection.size());
                ArrayList<Selectable> tmpSelectedContext = new ArrayList<Selectable>(this.selection.size());
                tmpSelection.addAll(this.selection);
                tmpSelectedContext.addAll(this.selectedContext);
                this.contextMenuProvider.showContextMenu((Tuple2i)this.pickLocation, nearest.getPos(), tmpSelection, tmpSelectedContext);
            }
        } else {
            this.changeSelection(null, true);
        }
    }
}

