/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.joal;

import java.util.ArrayList;
import java.util.List;
import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALCcontext;
import net.java.games.joal.ALCdevice;
import net.java.games.joal.ALFactory;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundException;
import org.xith3d.sound.SoundSource;
import org.xith3d.sound.drivers.joal.SoundBufferImpl;
import org.xith3d.sound.drivers.joal.SoundSourceImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundDriverImpl
implements SoundDriver {
    private AL al;
    private ALC alc;
    private List<SoundSource> sources;
    private List<SoundBufferImpl> buffers;
    private ALCdevice device;
    private ALCcontext context;
    private List<SoundSource> availableSources;
    private float listenerVolume = 1.0f;
    private float dopplerVelocity = 1.0f;
    private float dopplerFactor = 0.0f;
    private boolean isOnline;

    protected AL getAL() {
        return this.al;
    }

    protected String decodeSoundError(int error) {
        switch (error) {
            case 0: {
                return "NO ERROR";
            }
            case 40962: {
                return "INVALID ENUM";
            }
            case 40963: {
                return "INVALID VALUE";
            }
            case 40961: {
                return "INVALID NAME";
            }
            case 40964: {
                return "INVALID OPERATION";
            }
            case 40965: {
                return "OUT OF MEMORY";
            }
        }
        return "UNKNOWN ERROR";
    }

    protected void checkError() {
        int error = this.getAL().alGetError();
        if (error != 0) {
            throw new Error(this.decodeSoundError(error));
        }
    }

    public void newFrameSync() {
        int[] sourceList = new int[this.sources.size()];
        for (int i = 0; i < sourceList.length; ++i) {
            SoundSourceImpl ss = (SoundSourceImpl)this.sources.get(i);
            sourceList[i] = ss.handle;
            ss.stop();
        }
    }

    public void newFrameAsync() {
    }

    public void setListenerVelocity(Tuple3f velocity) {
        this.al.alListener3f(4102, velocity.getX(), velocity.getY(), velocity.getZ());
        this.checkError();
    }

    public void setListenerPosition(Tuple3f position) {
        this.al.alListenerfv(4100, new float[]{position.getX(), position.getY(), position.getZ()}, 0);
        this.checkError();
    }

    public void setListenerOrientation(Tuple3f direction, Tuple3f up) {
        this.al.alListenerfv(4111, new float[]{direction.getX(), direction.getY(), direction.getZ(), up.getX(), up.getY(), up.getZ()}, 0);
    }

    public void setListenerVolume(float gain) {
        this.al.alListenerf(4106, gain);
        this.checkError();
        this.listenerVolume = gain;
    }

    public float getListenerVolume() {
        return this.listenerVolume;
    }

    public void setDopplerVelocity(float velocity) {
        this.al.alDopplerVelocity(velocity);
        this.checkError();
        this.dopplerVelocity = velocity;
    }

    public float getDopplerVelocity() {
        return this.dopplerVelocity;
    }

    public void setDopplerFactor(float factor) {
        this.al.alDopplerFactor(factor);
        this.dopplerFactor = factor;
    }

    public float getDopplerFactor() {
        return this.dopplerFactor;
    }

    public SoundSource allocateSoundSource() throws SoundException {
        if (this.availableSources.size() == 0) {
            throw new SoundException("no sound sources available");
        }
        SoundSource s = this.availableSources.remove(this.availableSources.size() - 1);
        this.sources.add(s);
        return s;
    }

    public SoundBuffer allocateSoundBuffer() {
        return new SoundBufferImpl(this);
    }

    public void delete(SoundSource source) {
        this.sources.remove(source);
        ((SoundSourceImpl)source).releaseCachedResources();
        this.availableSources.add(source);
    }

    public void delete(SoundBuffer buffer) {
    }

    public int getNumAvailableSources() {
        return this.availableSources.size();
    }

    public int getNumSources() {
        return this.sources.size() + this.availableSources.size();
    }

    public void shutdown() {
        SoundSourceImpl ss;
        int j;
        if (!this.isOnline()) {
            return;
        }
        int[] sourceList = new int[this.sources.size() + this.availableSources.size()];
        int i = 0;
        for (j = 0; j < this.sources.size(); ++j) {
            ss = (SoundSourceImpl)this.sources.get(j);
            sourceList[i++] = ss.handle;
            ss.stop();
        }
        for (j = 0; j < this.availableSources.size(); ++j) {
            ss = (SoundSourceImpl)this.availableSources.get(j);
            sourceList[i++] = ss.handle;
            ss.stop();
        }
        if (sourceList.length > 0) {
            this.al.alDeleteSources(sourceList.length, sourceList, 0);
            this.checkError();
        }
        int[] bufferList = new int[this.buffers.size()];
        int j2 = 0;
        while (i < bufferList.length) {
            SoundBufferImpl ss2 = this.buffers.get(j2);
            bufferList[j2] = ss2.handle;
            ++j2;
        }
        if (bufferList.length > 0) {
            this.al.alDeleteBuffers(bufferList.length, bufferList, 0);
            this.checkError();
        }
        X3DLog.debug("Making sound context current");
        this.alc.alcMakeContextCurrent(this.context);
        X3DLog.debug("Destroying context");
        this.alc.alcDestroyContext(this.context);
        X3DLog.debug("Closing device");
        this.alc.alcCloseDevice(this.device);
        this.isOnline = false;
    }

    public final boolean isOnline() {
        return this.isOnline;
    }

    public SoundDriverImpl() {
        try {
            this.al = ALFactory.getAL();
            this.alc = ALFactory.getALC();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.device = this.alc.alcOpenDevice(System.getProperty("XITH3D_OPENAL_DEVICE"));
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        if (this.device == null) {
            throw new Error("No sound device found");
        }
        this.context = this.alc.alcCreateContext(this.device, null);
        this.alc.alcMakeContextCurrent(this.context);
        this.checkError();
        this.sources = new ArrayList<SoundSource>();
        this.buffers = new ArrayList<SoundBufferImpl>();
        this.availableSources = new ArrayList<SoundSource>();
        this.al.alDistanceModel(53249);
        this.checkError();
        boolean done = false;
        int n = 0;
        while (!done) {
            try {
                SoundSourceImpl ss = new SoundSourceImpl(this);
                this.availableSources.add(ss);
                if (n++ != 60) continue;
                break;
            }
            catch (Error e) {
                X3DLog.print(e);
                done = true;
            }
        }
        this.setListenerVolume(1.0f);
        this.isOnline = true;
        X3DLog.debug("OpenAL sound driver initialized with ", this.availableSources.size(), " available sources");
    }
}

