/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.joal;

import org.openmali.vecmath2.Tuple3f;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundContainer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundSource;
import org.xith3d.sound.SoundState;
import org.xith3d.sound.drivers.joal.SoundBufferImpl;
import org.xith3d.sound.drivers.joal.SoundDriverImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundSourceImpl
implements SoundSource {
    static int count = 0;
    int handle;
    private SoundDriverImpl driver;
    private float[] pos = new float[3];
    private boolean hasCachedPosition = false;

    public SoundSourceImpl(SoundDriverImpl driver) {
        this.driver = driver;
        int[] ret = new int[1];
        int error = driver.getAL().alGetError();
        driver.getAL().alGenSources(1, ret, 0);
        error = driver.getAL().alGetError();
        if (error != 0) {
            throw new Error("no more sources available : " + driver.decodeSoundError(error));
        }
        this.handle = ret[0];
        X3DLog.debug("Created new source.. handle = ", this.handle);
        this.setRolloffFactor(0.5f);
        this.setMaxDistance(30.0f);
        this.setReferenceDistance(5.0f);
        this.setMinVolume(0.0f);
        this.setMaxVolume(1.0f);
    }

    public void queueBuffer(SoundBuffer buffer) {
        this.driver.getAL().alSourceQueueBuffers(this.handle, 1, new int[]{((SoundBufferImpl)buffer).handle}, 0);
        this.driver.checkError();
    }

    public int[] unqueueProcessedBuffers() {
        int[] ret = new int[1];
        this.driver.getAL().alGetSourcei(this.handle, 4118, ret, 0);
        int num = ret[0];
        int[] buffers = new int[num];
        this.driver.getAL().alSourceUnqueueBuffers(this.handle, num, buffers, 0);
        this.driver.checkError();
        return buffers;
    }

    public void setBuffer(SoundBuffer buffer) {
        this.driver.getAL().alSourcei(this.handle, 4105, ((SoundBufferImpl)buffer).handle);
        this.driver.checkError();
    }

    public void setContainer(SoundContainer container) {
        SoundBuffer b = container.getData(this.driver);
        if (b != null) {
            this.setBuffer(b);
        }
    }

    public void setVolume(float gain) {
        this.driver.getAL().alSourcef(this.handle, 4106, gain);
        this.driver.checkError();
    }

    public void play() {
        this.driver.getAL().alSourcePlay(this.handle);
        this.driver.checkError();
    }

    public void pause() {
        this.driver.getAL().alSourcePause(this.handle);
        this.driver.checkError();
    }

    public void rewind() {
        this.driver.getAL().alSourceRewind(this.handle);
        this.driver.checkError();
    }

    public void stop() {
        this.driver.getAL().alSourceStop(this.handle);
        this.driver.checkError();
    }

    public boolean isPlaying() {
        return this.getState() == SoundState.PLAYING;
    }

    void releaseCachedResources() {
        this.hasCachedPosition = false;
    }

    public void setPosition(float posX, float posY, float posZ) {
        if (this.hasCachedPosition) {
            if (this.pos[0] == posX && this.pos[1] == posY && this.pos[2] == posZ) {
                return;
            }
            this.hasCachedPosition = true;
        }
        this.pos[0] = posX;
        this.pos[1] = posY;
        this.pos[2] = posZ;
        this.driver.getAL().alSourcefv(this.handle, 4100, this.pos, 0);
        this.driver.checkError();
    }

    public void setPosition(Tuple3f position) {
        this.setPosition(position.getX(), position.getY(), position.getZ());
    }

    public void setVelocity(float veloX, float veloY, float veloZ) {
        this.driver.getAL().alSource3f(this.handle, 4102, veloX, veloY, veloZ);
        this.driver.checkError();
    }

    public void setVelocity(Tuple3f velocity) {
        this.setVelocity(velocity.getX(), velocity.getY(), velocity.getZ());
    }

    public void setDirection(float dirX, float dirY, float dirZ) {
    }

    public void setDirection(Tuple3f direction) {
    }

    public SoundState getState() {
        int[] ret = new int[1];
        this.driver.getAL().alGetSourcei(this.handle, 4112, ret, 0);
        int state = ret[0];
        switch (state) {
            case 4114: {
                return SoundState.PLAYING;
            }
            case 4115: {
                return SoundState.PAUSED;
            }
            case 4113: {
                return SoundState.INITIAL;
            }
            case 4116: {
                return SoundState.STOPPED;
            }
        }
        throw new Error("Illegal OpenAL state found");
    }

    public void setReferenceDistance(float refDistance) {
        this.driver.getAL().alSourcef(this.handle, 4128, refDistance);
        this.driver.checkError();
    }

    public void setRolloffFactor(float factor) {
        this.driver.getAL().alSourcef(this.handle, 4129, factor);
        this.driver.checkError();
    }

    public void setRelative(boolean relative) {
        this.driver.getAL().alSourcei(this.handle, 514, relative ? 1 : 0);
        this.driver.checkError();
    }

    public void setLoop(boolean loop) {
        this.driver.getAL().alSourcei(this.handle, 4103, loop ? 1 : 0);
    }

    public void setMaxVolume(float maxVolume) {
        this.driver.getAL().alSourcef(this.handle, 4110, maxVolume);
        this.driver.checkError();
    }

    public void setMinVolume(float minVolume) {
        this.driver.getAL().alSourcef(this.handle, 4109, minVolume);
        this.driver.checkError();
    }

    public void setMaxDistance(float maxDistance) {
        this.driver.getAL().alSourcef(this.handle, 4131, maxDistance);
        this.driver.checkError();
    }

    public void setMaxTime(long ms) {
    }

    public SoundDriver getSoundDriver() {
        return this.driver;
    }
}

