/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.lwjgl;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundContainer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundSource;
import org.xith3d.sound.SoundState;
import org.xith3d.sound.drivers.lwjgl.SoundBufferImpl;
import org.xith3d.sound.drivers.lwjgl.SoundDriverImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundSourceImpl
implements SoundSource {
    static int count = 0;
    int handle;
    private SoundDriverImpl driver;
    private float[] pos = new float[3];
    private boolean hasCachedPosition = false;

    public SoundSourceImpl(SoundDriverImpl driver) {
        this.driver = driver;
        IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
        int error = AL10.alGetError();
        AL10.alGenSources((IntBuffer)buffer);
        error = AL10.alGetError();
        if (error != 0) {
            throw new Error("no more sources available : " + driver.decodeSoundError(error));
        }
        this.handle = buffer.get(0);
        X3DLog.debug("Created new source.. handle = ", this.handle);
        this.setRolloffFactor(0.5f);
        this.setMaxDistance(30.0f);
        this.setReferenceDistance(5.0f);
        this.setMinVolume(0.0f);
        this.setMaxVolume(1.0f);
    }

    public void queueBuffer(SoundBuffer buffer) {
        IntBuffer intbuf = BufferUtils.createIntBuffer((int)1).put(((SoundBufferImpl)buffer).handle);
        intbuf.rewind();
        AL10.alSourceQueueBuffers((int)this.handle, (IntBuffer)intbuf);
        this.driver.checkError();
    }

    public int[] unqueueProcessedBuffers() {
        int num = AL10.alGetSourcei((int)this.handle, (int)4118);
        IntBuffer buffers = BufferUtils.createIntBuffer((int)num);
        AL10.alSourceUnqueueBuffers((int)this.handle, (IntBuffer)buffers);
        this.driver.checkError();
        return buffers.array();
    }

    public void setBuffer(SoundBuffer buffer) {
        AL10.alSourcei((int)this.handle, (int)4105, (int)((SoundBufferImpl)buffer).handle);
        this.driver.checkError();
    }

    public void setContainer(SoundContainer container) {
        SoundBuffer b = container.getData(this.driver);
        if (b != null) {
            this.setBuffer(b);
        }
    }

    public void setVolume(float gain) {
        AL10.alSourcef((int)this.handle, (int)4106, (float)gain);
        this.driver.checkError();
    }

    public void play() {
        AL10.alSourcePlay((int)this.handle);
        this.driver.checkError();
    }

    public void pause() {
        AL10.alSourcePause((int)this.handle);
        this.driver.checkError();
    }

    public void rewind() {
        AL10.alSourceRewind((int)this.handle);
        this.driver.checkError();
    }

    public void stop() {
        AL10.alSourceStop((int)this.handle);
        this.driver.checkError();
    }

    public boolean isPlaying() {
        return this.getState() == SoundState.PLAYING;
    }

    void releaseCachedResources() {
        this.hasCachedPosition = false;
    }

    public void setPosition(float posX, float posY, float posZ) {
        if (this.hasCachedPosition) {
            if (this.pos[0] == posX && this.pos[1] == posY && this.pos[2] == posZ) {
                return;
            }
            this.hasCachedPosition = true;
        }
        this.pos[0] = posX;
        this.pos[1] = posY;
        this.pos[2] = posZ;
        AL10.alSource3f((int)this.handle, (int)4100, (float)posX, (float)posY, (float)posZ);
        this.driver.checkError();
    }

    public void setPosition(Tuple3f position) {
        this.setPosition(position.getX(), position.getY(), position.getZ());
    }

    public void setVelocity(float veloX, float veloY, float veloZ) {
        AL10.alSource3f((int)this.handle, (int)4102, (float)veloX, (float)veloY, (float)veloZ);
        this.driver.checkError();
    }

    public void setVelocity(Tuple3f velocity) {
        this.setVelocity(velocity.getX(), velocity.getY(), velocity.getZ());
    }

    public void setDirection(float dirX, float dirY, float dirZ) {
    }

    public void setDirection(Tuple3f direction) {
    }

    public SoundState getState() {
        int state = AL10.alGetSourcei((int)this.handle, (int)4112);
        switch (state) {
            case 4114: {
                return SoundState.PLAYING;
            }
            case 4115: {
                return SoundState.PAUSED;
            }
            case 4113: {
                return SoundState.INITIAL;
            }
            case 4116: {
                return SoundState.STOPPED;
            }
        }
        throw new Error("Illegal OpenAL state found");
    }

    public void setReferenceDistance(float refDistance) {
        AL10.alSourcef((int)this.handle, (int)4128, (float)refDistance);
        this.driver.checkError();
    }

    public void setRolloffFactor(float factor) {
        AL10.alSourcef((int)this.handle, (int)4129, (float)factor);
        this.driver.checkError();
    }

    public void setRelative(boolean relative) {
        AL10.alSourcei((int)this.handle, (int)514, (int)(relative ? 1 : 0));
        this.driver.checkError();
    }

    public void setLoop(boolean loop) {
        AL10.alSourcei((int)this.handle, (int)4103, (int)(loop ? 1 : 0));
    }

    public void setMaxVolume(float maxVolume) {
        AL10.alSourcef((int)this.handle, (int)4110, (float)maxVolume);
        this.driver.checkError();
    }

    public void setMinVolume(float minVolume) {
        AL10.alSourcef((int)this.handle, (int)4109, (float)minVolume);
        this.driver.checkError();
    }

    public void setMaxDistance(float maxDistance) {
        AL10.alSourcef((int)this.handle, (int)4131, (float)maxDistance);
        this.driver.checkError();
    }

    public void setMaxTime(long ms) {
    }

    public SoundDriver getSoundDriver() {
        return this.driver;
    }
}

