/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xith3d.terrain.GridResourceProvider;
import org.xith3d.terrain.GridResourceSpec;
import org.xith3d.terrain.GridSampler;
import org.xith3d.terrain.GridSurface;
import org.xith3d.terrain.HeightMapSampler;
import org.xith3d.terrain.TextureSurface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGridResourceProvider
implements GridResourceProvider {
    private List<GridResourceSpec> samplerSpecs;
    private List<GridResourceSpec> surfaceSpecs;

    protected DefaultGridResourceProvider() {
    }

    public DefaultGridResourceProvider(List<GridResourceSpec<GridSampler>> samplerSpecs, List<GridResourceSpec<GridSurface>> surfaceSpecs) {
        this.samplerSpecs = new ArrayList<GridResourceSpec<GridSampler>>(samplerSpecs);
        this.surfaceSpecs = new ArrayList<GridResourceSpec<GridSurface>>(surfaceSpecs);
    }

    protected void setSamplerSpecs(List<GridResourceSpec> samplerSpecs) {
        this.samplerSpecs = samplerSpecs;
    }

    protected void setSurfaceSpecs(List<GridResourceSpec> surfaceSpecs) {
        this.surfaceSpecs = surfaceSpecs;
    }

    @Override
    public final GridSampler findSampler(float s1, float t1, float s2, float t2, int detail) {
        GridSampler sampler;
        GridResourceSpec spec = this.findResourceSpec(this.samplerSpecs, s1, t1, s2, t2, detail);
        if (detail != -1) {
            spec.addReference();
        }
        if ((sampler = (GridSampler)spec.getCachedResource()) == null) {
            sampler = this.createSampler(spec);
            spec.setCachedResource(sampler);
        }
        return sampler;
    }

    @Override
    public void releaseSampler(GridSampler sampler) {
        for (int i = 0; i < this.samplerSpecs.size(); ++i) {
            GridResourceSpec spec = this.samplerSpecs.get(i);
            if (spec.getCachedResource() != sampler || !spec.release()) continue;
            sampler.release();
            return;
        }
    }

    @Override
    public final GridSurface findSurface(float s1, float t1, float s2, float t2, int detail) {
        GridSurface surface;
        GridResourceSpec spec = this.findResourceSpec(this.surfaceSpecs, s1, t1, s2, t2, detail);
        if (detail != -1) {
            spec.addReference();
        }
        if ((surface = (GridSurface)spec.getCachedResource()) == null) {
            surface = this.createSurface(spec);
            spec.setCachedResource(surface);
        }
        return surface;
    }

    @Override
    public void releaseSurface(GridSurface surface) {
        for (int i = 0; i < this.surfaceSpecs.size(); ++i) {
            GridResourceSpec spec = this.surfaceSpecs.get(i);
            if (spec.getCachedResource() != surface || !spec.release()) continue;
            surface.release();
            return;
        }
    }

    protected GridResourceSpec findResourceSpec(List<GridResourceSpec> specs, float s1, float t1, float s2, float t2, int detail) {
        int i;
        int handle = 0;
        int[] matches = new int[32];
        if (detail > 31) {
            detail = 31;
        }
        for (i = 0; i < specs.size(); ++i) {
            GridResourceSpec spec = specs.get(i);
            if (!(s1 >= spec.getS1()) || !(s2 <= spec.getS2()) || !(t1 >= spec.getT1()) || !(t2 <= spec.getT2()) || detail == -1 && spec.getCachedResource() == null) continue;
            int specDetail = spec.getDetail();
            if (specDetail > 31) {
                specDetail = 31;
            }
            matches[spec.getDetail()] = i + 1;
        }
        int n = i = detail == -1 ? 31 : detail;
        while (i >= 0) {
            if (matches[i] > 0) {
                handle = matches[i] - 1;
                break;
            }
            --i;
        }
        return specs.get(handle);
    }

    protected GridSampler createSampler(GridResourceSpec<GridSampler> spec) {
        try {
            return new HeightMapSampler(spec);
        }
        catch (Exception ex) {
            Logger.getLogger(DefaultGridResourceProvider.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    protected GridSurface createSurface(GridResourceSpec<GridSurface> spec) {
        try {
            return new TextureSurface(spec);
        }
        catch (Exception ex) {
            Logger.getLogger(DefaultGridResourceProvider.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

