/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openmali.spatial.polygons.Triangle;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.terrain.GridSampler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridTriangulator {
    private GridSampler grid;
    private int complexity;
    private float yScale;
    private float x1;
    private float z1;
    private float x2;
    private float z2;
    private float s1;
    private float s2;
    private float t1;
    private float t2;
    private float minY;
    private float maxY;
    private float baseTolerance;
    private boolean changed;
    private Tuple3f[] coordinateCache;
    private Vector3f[] normals;
    private int[] index;
    private boolean backgroundOptimized = false;
    private int size;
    private int indexCount;
    private boolean yield;
    private int yieldCount;
    private int baseVertexCount;
    private int edgeVertexCount;
    private int[] boundry;
    private int[] indexmapping;
    private int[] skirtindexmapping;
    private boolean[] enabledpoints;
    private int[] tmpindex;
    private boolean expandEdges = true;
    private float maxTolerance;
    private Triangle tmpTri = new Triangle();
    private Vector3f tmpVec = new Vector3f();
    private Tuple3f tmpP0 = new Tuple3f();
    private Tuple3f tmpP1 = new Tuple3f();
    private Tuple3f tmpP2 = new Tuple3f();
    private Tuple3f tmpP3 = new Tuple3f();
    private Tuple3f tmpP4 = new Tuple3f();
    int lastParity;

    public GridTriangulator(GridSampler grid, int complexity) {
        this(grid, complexity, (float)Math.pow(2.0, complexity) + 1.0f, (float)(-Math.pow(2.0, complexity)) / 2.0f, (float)(-Math.pow(2.0, complexity)) / 2.0f, (float)Math.pow(2.0, complexity) / 2.0f, (float)Math.pow(2.0, complexity) / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.07f);
    }

    public GridTriangulator(GridSampler grid, int complexity, float yScale) {
        this(grid, complexity, yScale, (float)(-Math.pow(2.0, complexity)) / 2.0f, (float)(-Math.pow(2.0, complexity)) / 2.0f, (float)Math.pow(2.0, complexity) / 2.0f, (float)Math.pow(2.0, complexity) / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.07f);
    }

    public GridTriangulator(GridSampler grid, int complexity, float yScale, float x1, float z1, float x2, float z2) {
        this(grid, complexity, yScale, x1, z1, x2, z2, 0.0f, 0.0f, 1.0f, 1.0f, 0.07f);
    }

    public GridTriangulator(GridSampler grid, int complexity, float yScale, float x1, float z1, float x2, float z2, float s1, float t1, float s2, float t2) {
        this(grid, complexity, yScale, x1, z1, x2, z2, s1, t1, s2, t2, 0.07f);
    }

    public GridTriangulator(GridSampler grid, int complexity, float yScale, float x1, float z1, float x2, float z2, float s1, float t1, float s2, float t2, float baseTolerance) {
        if (complexity < 1) {
            throw new IllegalArgumentException("Construction argument 'complexity' must be a positive number!");
        }
        this.grid = grid;
        this.complexity = complexity;
        this.yScale = yScale;
        this.x1 = x1;
        this.z1 = z1;
        this.x2 = x2;
        this.z2 = z2;
        this.s1 = s1;
        this.t1 = t1;
        this.s2 = s2;
        this.t2 = t2;
        this.baseTolerance = baseTolerance;
        this.setChanged(true);
        this.getCoordinates();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isBackgroundOptimized() {
        return this.backgroundOptimized;
    }

    public void setBackgroundOptimized(boolean backgroundOptimized) {
        this.backgroundOptimized = backgroundOptimized;
    }

    public GridSampler getGrid() {
        return this.grid;
    }

    public void setGrid(GridSampler grid) {
        if (this.grid != grid) {
            this.setChanged(true);
        }
        this.grid = grid;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public void setComplexity(int complexity) {
        if (this.complexity != complexity) {
            this.setChanged(true);
        }
        this.complexity = complexity;
    }

    public int getSize() {
        return this.size;
    }

    public float getYScale() {
        return this.yScale;
    }

    public void setYScale(float yScale) {
        if (this.yScale != yScale) {
            this.setChanged(true);
        }
        this.yScale = yScale;
    }

    public float getX1() {
        return this.x1;
    }

    public void setX1(float x1) {
        if (this.x1 != x1) {
            this.setChanged(true);
        }
        this.x1 = x1;
    }

    public float getZ1() {
        return this.z1;
    }

    public void setZ1(float z1) {
        if (this.z1 != z1) {
            this.setChanged(true);
        }
        this.z1 = z1;
    }

    public float getX2() {
        return this.x2;
    }

    public void setX2(float x2) {
        if (this.x2 != x2) {
            this.setChanged(true);
        }
        this.x2 = x2;
    }

    public float getZ2() {
        return this.z2;
    }

    public void setZ2(float z2) {
        if (this.z2 != z2) {
            this.setChanged(true);
        }
        this.z2 = z2;
    }

    public float getS1() {
        return this.s1;
    }

    public void setS1(float s1) {
        if (this.s1 != s1) {
            this.setChanged(true);
        }
        this.s1 = s1;
    }

    public float getS2() {
        return this.s2;
    }

    public void setS2(float s2) {
        if (this.s2 != s2) {
            this.setChanged(true);
        }
        this.s2 = s2;
    }

    public float getT1() {
        return this.t1;
    }

    public void setT1(float t1) {
        if (this.t1 != t1) {
            this.setChanged(true);
        }
        this.t1 = t1;
    }

    public float getT2() {
        return this.t2;
    }

    public void setT2(float t2) {
        if (this.t2 != t2) {
            this.setChanged(true);
        }
        this.t2 = t2;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getBaseTolerance() {
        return this.baseTolerance;
    }

    public void setBaseTolerance(float baseTolerance) {
        if (this.baseTolerance != baseTolerance) {
            this.setChanged(true);
        }
        this.baseTolerance = baseTolerance;
    }

    public Vector3f[] getNormals() {
        if (this.isChanged()) {
            this.getCoordinates();
        }
        return this.normals;
    }

    public Tuple3f[] getCoordinates() {
        return this.getCoordinates(true);
    }

    public Tuple3f[] getCoordinates(boolean optimized) {
        Tuple3f[] coords = this.calculateCoordinates(optimized, this.backgroundOptimized);
        return coords;
    }

    private Tuple3f[] calculateCoordinates(boolean optimized, boolean background) {
        int x;
        if (!this.isChanged()) {
            return this.coordinateCache;
        }
        if (background) {
            this.startCalculation();
        }
        this.size = (int)(Math.pow(2.0, this.complexity) + 1.0);
        this.boundry = new int[this.size];
        this.enabledpoints = new boolean[this.size * this.size];
        this.tmpindex = new int[this.size * this.size * 6];
        this.indexmapping = null;
        this.minY = Float.MAX_VALUE;
        this.maxY = 0.0f;
        for (int n = 0; n < this.size; ++n) {
            this.boundry[n] = -1;
            if (n == 0) {
                this.boundry[n] = (short)(this.size - 1);
            } else {
                for (int level = this.size; level > 1; level /= 2) {
                    if (n % level != 0) continue;
                    this.boundry[n] = level;
                    break;
                }
                if (this.boundry[n] == -1) {
                    this.boundry[n] = 1;
                }
            }
            if (!background) continue;
            this.pauseCalculation();
        }
        this.index = this.getIndex(this.baseTolerance);
        this.coordinateCache = new Tuple3f[this.baseVertexCount + this.edgeVertexCount];
        this.normals = new Vector3f[this.baseVertexCount + this.edgeVertexCount];
        int i = 0;
        for (x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                if (!this.isEnabled(x, z)) continue;
                this.coordinateCache[i] = this.samplePoint(x, z);
                this.normals[i++] = this.sampleNormal(x, z);
            }
            if (!background) continue;
            this.pauseCalculation();
        }
        if (this.expandEdges) {
            int z;
            for (x = 0; x < this.size; ++x) {
                if (!this.isEnabled(x, this.size - 1)) continue;
                this.coordinateCache[i] = this.samplePoint(x, this.size - 1, -this.yScale / 32.0f);
                this.normals[i++] = this.sampleNormal(x, this.size - 1);
            }
            for (z = this.size - 1; z >= 0; --z) {
                if (!this.isEnabled(this.size - 1, z)) continue;
                this.coordinateCache[i] = this.samplePoint(this.size - 1, z, -this.yScale / 32.0f);
                this.normals[i++] = this.sampleNormal(this.size - 1, z);
            }
            for (x = this.size - 1; x >= 0; --x) {
                if (!this.isEnabled(x, 0)) continue;
                this.coordinateCache[i] = this.samplePoint(x, 0, -this.yScale / 32.0f);
                this.normals[i++] = this.sampleNormal(x, 0);
            }
            for (z = 0; z < this.size; ++z) {
                if (!this.isEnabled(0, z)) continue;
                this.coordinateCache[i] = this.samplePoint(0, z, -this.yScale / 32.0f);
                this.normals[i++] = this.sampleNormal(0, z);
            }
            if (background) {
                this.stopCalculation();
            }
        }
        int last = i - 1;
        int len = this.coordinateCache.length;
        for (int j = i; j < len; ++j) {
            this.coordinateCache[j] = this.coordinateCache[last];
        }
        this.setChanged(false);
        return this.coordinateCache;
    }

    public int[] getIndex() {
        if (this.isChanged()) {
            this.getCoordinates();
        }
        return this.index;
    }

    public int[] getIndex(float tolerance) {
        if (tolerance <= this.baseTolerance && !this.isChanged()) {
            return this.getIndex();
        }
        int[] index = this.calculateIndex(tolerance, null, 0.0f, this.backgroundOptimized);
        return index;
    }

    private void printEnabledIndices() {
        int x;
        System.out.print("\n\n");
        for (x = 0; x < this.size * 3 + 3 + (this.expandEdges ? 6 : 0); ++x) {
            System.out.print("#");
        }
        System.out.print("\n");
        if (this.expandEdges) {
            System.out.print("#    ");
            for (x = 0; x < this.size; ++x) {
                System.out.print(this.isEnabled(x, 0) ? this.f(this.findSkirtIndex(x, 0)) : " - ");
            }
            System.out.println("   #");
        }
        for (int z = 0; z < this.size; ++z) {
            System.out.print("# ");
            if (this.expandEdges) {
                System.out.print(this.isEnabled(0, z) ? this.f(this.findSkirtIndex(0, z)) : " - ");
            }
            for (int x2 = 0; x2 < this.size; ++x2) {
                System.out.print(this.isEnabled(x2, z) ? this.f(this.findIndex(x2, z)) : " - ");
            }
            if (this.expandEdges) {
                System.out.print(this.isEnabled(this.size - 1, z) ? this.f(this.findSkirtIndex(this.size - 1, z)) : " - ");
            }
            System.out.println("#");
        }
        if (this.expandEdges) {
            System.out.print("#    ");
            for (x = 0; x < this.size; ++x) {
                System.out.print(this.isEnabled(x, this.size - 1) ? this.f(this.findSkirtIndex(x, this.size - 1)) : " - ");
            }
            System.out.println("   #");
        }
        for (x = 0; x < this.size * 3 + 3 + (this.expandEdges ? 6 : 0); ++x) {
            System.out.print("#");
        }
        System.out.print("\n\n");
    }

    private void printReturnedIndices(int[] index) {
        System.out.print("\n\n");
        int i = 0;
        do {
            for (int j = 0; j < 5; ++j) {
                System.out.print((j > 0 ? ", " : "") + index[i++]);
                if (i == index.length) break;
            }
            System.out.print("\n");
        } while (i != index.length);
        System.out.print("\n\n");
    }

    private String f(int index) {
        String result = Integer.toString(index);
        if (result.length() < 2) {
            result = " " + result;
        }
        return result + " ";
    }

    public int[] getIndex(float tolerance, Tuple3f eyePosition, float threshold) {
        return this.calculateIndex(tolerance, eyePosition, threshold, false);
    }

    public void getIndex(final float tolerance, final Tuple3f eyePosition, final float threshold, final IndexCallback callback) {
        Thread worker = new Thread(){

            public void run() {
                callback.indexFinished(GridTriangulator.this.calculateIndex(tolerance, eyePosition, threshold, true));
            }
        };
        worker.start();
    }

    private int[] calculateIndex(float tolerance, Tuple3f eyePosition, float threshold, boolean background) {
        int z;
        int x;
        int x2;
        if (tolerance <= this.baseTolerance) {
            tolerance = this.baseTolerance;
        }
        if (background) {
            this.startCalculation();
        }
        this.indexCount = 0;
        Arrays.fill(this.enabledpoints, false);
        this.enablePoint(0, 0);
        this.enablePoint(this.size - 1, 0);
        this.enablePoint(this.size - 1, this.size - 1);
        this.enablePoint(0, this.size - 1);
        this.enablePoint((this.size - 1) / 2, (this.size - 1) / 2);
        for (int y = 2; y < this.size; ++y) {
            for (x2 = 0; x2 < this.size; ++x2) {
                if (this.isEnabled(x2, y)) continue;
                int xx = this.boundry[x2];
                int yy = this.boundry[y];
                int level = Math.min(xx, yy);
                this.splitQuad(x2 - level, y - level, level * 2 + 1, tolerance, eyePosition, threshold);
                if (!background) continue;
                this.pauseCalculation();
            }
        }
        if (this.indexmapping == null) {
            this.indexmapping = new int[this.size * this.size];
            this.baseVertexCount = 0;
            for (x = 0; x < this.size; ++x) {
                for (z = 0; z < this.size; ++z) {
                    if (this.isEnabled(x, z)) {
                        this.mapIndex(x, z, this.baseVertexCount++);
                    } else {
                        this.mapIndex(x, z, -1);
                    }
                    if (!background) continue;
                    this.pauseCalculation();
                }
            }
        }
        if (this.expandEdges && this.skirtindexmapping == null) {
            int z2;
            this.skirtindexmapping = new int[this.size * 4];
            this.edgeVertexCount = 0;
            for (x = 0; x < this.size; ++x) {
                if (this.isEnabled(x, this.size - 1)) {
                    this.mapSkirtIndex(x, this.size - 1, this.baseVertexCount + this.edgeVertexCount++);
                    continue;
                }
                this.mapSkirtIndex(x, this.size - 1, -1);
            }
            for (z2 = this.size - 1; z2 >= 0; --z2) {
                if (this.isEnabled(this.size - 1, z2)) {
                    this.mapSkirtIndex(this.size - 1, z2, this.baseVertexCount + this.edgeVertexCount++);
                    continue;
                }
                this.mapSkirtIndex(this.size - 1, z2, -1);
            }
            for (x = this.size - 1; x >= 0; --x) {
                if (this.isEnabled(x, 0)) {
                    this.mapSkirtIndex(x, 0, this.baseVertexCount + this.edgeVertexCount++);
                    continue;
                }
                this.mapSkirtIndex(x, 0, -1);
            }
            for (z2 = 0; z2 < this.size; ++z2) {
                if (this.isEnabled(0, z2)) {
                    this.mapSkirtIndex(0, z2, this.baseVertexCount + this.edgeVertexCount++);
                    continue;
                }
                this.mapSkirtIndex(0, z2, -1);
            }
            if (background) {
                this.pauseCalculation();
            }
        }
        ArrayList<Integer> triangleStrip = new ArrayList<Integer>((this.size * this.size + 4 * this.size) * 2);
        this.refineMesh(triangleStrip, this.complexity);
        if (this.expandEdges) {
            for (x2 = 0; x2 < this.size; ++x2) {
                if (!this.isEnabled(x2, this.size - 1)) continue;
                this.appendIndex(triangleStrip, x2, this.size - 1);
                this.appendSkirtIndex(triangleStrip, x2, this.size - 1);
            }
            for (z = this.size - 1; z >= 0; --z) {
                if (!this.isEnabled(this.size - 1, z)) continue;
                this.appendIndex(triangleStrip, this.size - 1, z);
                this.appendSkirtIndex(triangleStrip, this.size - 1, z);
            }
            for (x2 = this.size - 1; x2 >= 0; --x2) {
                if (!this.isEnabled(x2, 0)) continue;
                this.appendIndex(triangleStrip, x2, 0);
                this.appendSkirtIndex(triangleStrip, x2, 0);
            }
            for (z = 0; z < this.size; ++z) {
                if (!this.isEnabled(0, z)) continue;
                this.appendIndex(triangleStrip, 0, z);
                this.appendSkirtIndex(triangleStrip, 0, z);
            }
            if (background) {
                this.pauseCalculation();
            }
        }
        int[] result = new int[triangleStrip.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = triangleStrip.get(i);
        }
        if (background) {
            this.stopCalculation();
        }
        return result;
    }

    private void startCalculation() {
        this.yield = true;
        this.yieldCount = 0;
    }

    private void pauseCalculation() {
        if (this.yield) {
            ++this.yieldCount;
            if (this.yieldCount % 5000 == 0) {
                Thread.yield();
            }
        }
    }

    private void stopCalculation() {
        this.yield = false;
        this.yieldCount = 0;
    }

    private Vector3f sampleNormal(int x, int y) {
        return (Vector3f)this.sampleNormal(x, y, (Tuple3f)new Vector3f());
    }

    private Tuple3f sampleNormal(int x, int y, Tuple3f result) {
        this.samplePoint(x, y, 0.0f, this.tmpP0);
        this.samplePoint(x - 1, y - 1, 0.0f, this.tmpP1);
        this.samplePoint(x + 1, y - 1, 0.0f, this.tmpP2);
        this.samplePoint(x + 1, y + 1, 0.0f, this.tmpP3);
        this.samplePoint(x - 1, y + 1, 0.0f, this.tmpP4);
        this.tmpTri.setVertexCoordA(this.tmpP0);
        this.tmpTri.setVertexCoordB(this.tmpP1);
        this.tmpTri.setVertexCoordC(this.tmpP2);
        this.tmpTri.getFaceNormalACAB(this.tmpVec);
        result.set((TupleNf)this.tmpVec);
        this.tmpTri.setVertexCoordA(this.tmpP0);
        this.tmpTri.setVertexCoordB(this.tmpP2);
        this.tmpTri.setVertexCoordC(this.tmpP3);
        result.add((TupleNf)this.tmpVec);
        this.tmpTri.setVertexCoordA(this.tmpP0);
        this.tmpTri.setVertexCoordB(this.tmpP3);
        this.tmpTri.setVertexCoordC(this.tmpP4);
        result.add((TupleNf)this.tmpVec);
        this.tmpTri.setVertexCoordA(this.tmpP0);
        this.tmpTri.setVertexCoordB(this.tmpP4);
        this.tmpTri.setVertexCoordC(this.tmpP1);
        result.add((TupleNf)this.tmpVec);
        result.div(4.0f);
        return result;
    }

    private Point3f samplePoint(int x, int y) {
        return this.samplePoint(x, y, 0.0f);
    }

    private Point3f samplePoint(int x, int y, float offset) {
        return (Point3f)this.samplePoint(x, y, offset, (Tuple3f)new Point3f());
    }

    private Tuple3f samplePoint(int x, int y, float offset, Tuple3f result) {
        float realX = this.x1 + (float)x / (float)(this.size - 1) * (this.x2 - this.x1);
        float realZ = this.z1 + (float)y / (float)(this.size - 1) * (this.z2 - this.z1);
        float realY = this.sampleHeight(x, y, offset);
        if (realY > this.maxY) {
            this.maxY = realY;
        }
        if (realY < this.minY) {
            this.minY = realY;
        }
        result.set(realX, realY, realZ);
        return result;
    }

    private float sampleHeight(int x, int y, float offset) {
        float s = this.s1 + (float)x / (float)(this.size - 1) * (this.s2 - this.s1);
        float t = this.t1 + (float)y / (float)(this.size - 1) * (this.t2 - this.t1);
        return this.grid.sampleHeight(s, t) * this.yScale + offset;
    }

    private boolean isMasked(int x, int y) {
        x = Math.max(Math.min(x, this.size - 1), 0);
        y = Math.max(Math.min(y, this.size - 1), 0);
        return this.indexmapping != null && this.indexmapping[x + y * this.size] == -1;
    }

    private boolean isEnabled(int x, int y) {
        x = Math.max(Math.min(x, this.size - 1), 0);
        y = Math.max(Math.min(y, this.size - 1), 0);
        return this.enabledpoints[x + y * this.size];
    }

    private void enable(int x, int y) {
        x = Math.max(Math.min(x, this.size - 1), 0);
        y = Math.max(Math.min(y, this.size - 1), 0);
        this.enabledpoints[x + y * this.size] = true;
    }

    private void mapIndex(int x, int y, int i) {
        x = Math.max(Math.min(x, this.size - 1), 0);
        y = Math.max(Math.min(y, this.size - 1), 0);
        this.indexmapping[x + y * this.size] = i;
    }

    private int findIndex(int x, int y) {
        x = Math.max(Math.min(x, this.size - 1), 0);
        y = Math.max(Math.min(y, this.size - 1), 0);
        return this.indexmapping[x + y * this.size];
    }

    private void mapSkirtIndex(int x, int y, int i) {
        if (y == 0) {
            this.skirtindexmapping[x] = i;
        } else if (x == 0) {
            this.skirtindexmapping[this.size + y] = i;
        } else if (y == this.size - 1) {
            this.skirtindexmapping[this.size * 2 + x] = i;
        } else if (x == this.size - 1) {
            this.skirtindexmapping[this.size * 3 + y] = i;
        }
    }

    private int findSkirtIndex(int x, int y) {
        if (y == 0) {
            return this.skirtindexmapping[x];
        }
        if (x == 0) {
            return this.skirtindexmapping[this.size + y];
        }
        if (y == this.size - 1) {
            return this.skirtindexmapping[this.size * 2 + x];
        }
        if (x == this.size - 1) {
            return this.skirtindexmapping[this.size * 3 + y];
        }
        return -1;
    }

    private void appendSkirtIndex(List<Integer> triangleStrip, int x, int y) {
        int i = this.findSkirtIndex(x = Math.max(Math.min(x, this.size - 1), 0), y = Math.max(Math.min(y, this.size - 1), 0));
        if (i != -1) {
            triangleStrip.add(i);
        }
    }

    private void enablePoint(int x, int y) {
        if (x < 0 || x >= this.size || y < 0 || y >= this.size) {
            return;
        }
        if (this.isEnabled(x, y)) {
            return;
        }
        if (this.isMasked(x, y)) {
            return;
        }
        this.enable(x, y);
        int xl = this.boundry[x];
        int yl = this.boundry[y];
        int level = Math.min(xl, yl);
        if (xl > yl) {
            this.enablePoint(x - level, y);
            this.enablePoint(x + level, y);
        } else if (xl < yl) {
            this.enablePoint(x, y + level);
            this.enablePoint(x, y - level);
        } else {
            int x2 = x & level * 2;
            int y2 = y & level * 2;
            if (x2 == y2) {
                this.enablePoint(x - level, y + level);
                this.enablePoint(x + level, y - level);
            } else {
                this.enablePoint(x + level, y + level);
                this.enablePoint(x - level, y - level);
            }
        }
    }

    private void splitQuad(int x1, int y1, int size, float tolerance, Tuple3f eyePos, float threshold) {
        float sizeBias;
        float dist = 0.0f;
        Point3f pos = new Point3f();
        int half = (size - 1) / 2;
        int xc = x1 + half;
        int x2 = x1 + size - 1;
        int yc = y1 + half;
        int y2 = y1 + size - 1;
        if (x2 >= this.size || y2 >= this.size || x1 < 0 || y1 < 0) {
            return;
        }
        if (eyePos != null) {
            Vector3f vec = new Vector3f();
            this.samplePoint(xc, yc, 0.0f, (Tuple3f)vec);
            vec.sub((TupleNf)eyePos);
            dist = (float)Math.max(Math.min((double)(vec.length() / threshold), 1.0), 0.0);
        }
        float ul = this.sampleHeight(x1, y1, 0.0f);
        float ur = this.sampleHeight(x2, y1, 0.0f);
        float ll = this.sampleHeight(x1, y2, 0.0f);
        float lr = this.sampleHeight(x2, y2, 0.0f);
        float center = this.sampleHeight(xc, yc, 0.0f);
        float average = (ul + lr + ll + ur) / 4.0f;
        float delta = Math.abs(average - center) * 5.0f;
        delta /= (float)size;
        if (eyePos != null) {
            delta *= 1.0f - dist * 0.85f;
            if (dist < 0.15f) {
                delta *= 10.0f;
            }
        }
        if ((delta *= (sizeBias = (float)(this.size + size) / (float)(this.size * 2))) > tolerance) {
            this.enablePoint(xc, yc);
        }
    }

    public void refineMesh(List<Integer> triangleStrip, int complexity) {
        int x1 = 0;
        int y1 = 0;
        int size = (int)(Math.pow(2.0, complexity) + 1.0);
        int n = complexity * 2;
        this.pauseCalculation();
        int nextSize = (size - 1) / 2 + 1;
        int x2 = x1 + (size - 1);
        int y2 = y1 + (size - 1);
        int xc = x1 + nextSize - 1;
        int yc = y1 + nextSize - 1;
        triangleStrip.add(this.findIndex(x1, y2));
        triangleStrip.add(this.findIndex(x1, y2));
        this.lastParity = 0;
        this.refineSubMesh(triangleStrip, xc, yc, x1, y2, x2, y2, n);
        this.appendIndex(triangleStrip, x2, y2, 1);
        this.refineSubMesh(triangleStrip, xc, yc, x2, y2, x2, y1, n);
        this.appendIndex(triangleStrip, x2, y1, 1);
        this.refineSubMesh(triangleStrip, xc, yc, x2, y1, x1, y1, n);
        this.appendIndex(triangleStrip, x1, y1, 1);
        this.refineSubMesh(triangleStrip, xc, yc, x1, y1, x1, y2, n);
        this.appendIndex(triangleStrip, x1, y2, 1);
    }

    public void refineSubMesh(List<Integer> triangleStrip, int xi, int yi, int xj, int yj, int xk, int yk, int level) {
        boolean refine;
        int xc = (xj + xk) / 2;
        int yc = (yj + yk) / 2;
        boolean bl = refine = level > 1 && this.isEnabled(xc, yc);
        if (refine) {
            this.refineSubMesh(triangleStrip, xc, yc, xj, yj, xi, yi, level - 1);
        }
        this.appendIndex(triangleStrip, xi, yi, level & 1);
        if (refine) {
            this.refineSubMesh(triangleStrip, xc, yc, xi, yi, xk, yk, level - 1);
        }
    }

    private void appendIndex(List<Integer> triangleStrip, int x, int y) {
        int i = this.findIndex(x, y);
        if (i != -1) {
            triangleStrip.add(i);
        }
    }

    private void appendIndex(List<Integer> triangleStrip, int x, int y, int parity) {
        int n;
        int i = this.findIndex(x, y);
        if (i != triangleStrip.get((n = triangleStrip.size() - 1) - 1) && i != triangleStrip.get(n)) {
            if (parity != this.lastParity) {
                this.lastParity = parity;
            } else {
                triangleStrip.add(triangleStrip.get(n - 1));
            }
            triangleStrip.add(i);
        }
    }

    public static interface IndexCallback {
        public void indexFinished(int[] var1);
    }

    public static interface CoordinateCallback {
        public void coordinatesFinished(Tuple3f[] var1);
    }
}

