/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain;

import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.terrain.GridResourceSpec;
import org.xith3d.terrain.GridSampler;
import org.xith3d.terrain.HF2Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeightMapSampler
implements GridSampler {
    private float[][] map;
    private int sDim;
    private int tDim;
    private float offset = 0.0f;
    private float scale = 1.0f;
    private float s1 = 0.0f;
    private float t1 = 0.0f;
    private float s2 = 1.0f;
    private float t2 = 1.0f;

    public HeightMapSampler(URL resource) throws IOException {
        String loc = resource.toString();
        if (loc.endsWith(".hfz") || loc.endsWith(".gz")) {
            HF2Map hf = new HF2Map(resource);
            this.sDim = (int)hf.getWidth();
            this.tDim = (int)hf.getHeight();
            this.map = hf.getData();
            this.offset = hf.getMin();
            this.scale = 1.0f / (hf.getMax() - hf.getMin());
        } else {
            BufferedImage image = ImageIO.read(resource);
            this.sDim = image.getWidth(null);
            this.tDim = image.getHeight(null);
            PixelGrabber grabber = new PixelGrabber(image, 0, 0, this.sDim, this.tDim, true);
            try {
                grabber.grabPixels(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int[] source = (int[])grabber.getPixels();
            float[][] result = new float[this.sDim][this.tDim];
            int i = 0;
            for (int t = this.tDim - 1; t >= 0; --t) {
                for (int s = 0; s < this.sDim; ++s) {
                    int data = source[i++];
                    result[s][t] = (float)(((data & 0xFF0000) >> 16) + ((data & 0xFF00) >> 8) + (data & 0xFF)) / 3.0f / 255.0f;
                }
            }
            this.map = result;
        }
    }

    public HeightMapSampler(URL resource, int sDim, int tDim) throws IOException {
        this(resource, sDim, tDim, Type.RAW_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeightMapSampler(URL resource, int sDim, int tDim, Type type) throws IOException {
        this.sDim = sDim;
        this.tDim = tDim;
        InputStream in = null;
        float[][] result = new float[sDim][tDim];
        try {
            in = resource.openStream();
            for (int t = tDim - 1; t >= 0; --t) {
                for (int s = 0; s < sDim; ++s) {
                    int highbyte = 0;
                    int lowbyte = 0;
                    if (type == Type.RAW_16 && (lowbyte = in.read()) == -1) {
                        throw new IOException("EOF");
                    }
                    highbyte = in.read();
                    if (highbyte == -1) {
                        throw new IOException("EOF");
                    }
                    result[s][t] = (float)(((highbyte & 0xFF) << 8) + (lowbyte & 0xFF)) / 65535.0f;
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ignore) {}
        }
        this.map = result;
    }

    public HeightMapSampler(float[][] map) {
        this.sDim = map.length;
        this.tDim = map[0].length;
        this.map = map;
    }

    public HeightMapSampler(int sDim, int tDim) {
        this.sDim = sDim;
        this.tDim = tDim;
        this.map = new float[sDim][tDim];
    }

    public HeightMapSampler(GridResourceSpec<GridSampler> spec) throws IOException {
        this(spec.getLocations()[0]);
        this.s1 = spec.getS1();
        this.s2 = spec.getS2();
        this.t1 = spec.getT1();
        this.t2 = spec.getT2();
        float min = spec.getMin();
        float max = spec.getMax();
        if (min < max) {
            this.offset = min;
            this.scale = 1.0f / (max - min);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public float sampleHeight(float s, float t) {
        s = 1.0f / (this.s2 - this.s1) * (s - this.s1);
        t = 1.0f / (this.t2 - this.t1) * (t - this.t1);
        int sIndex = Math.max(0, Math.min((int)(s * (float)this.sDim), this.sDim - 1));
        int tIndex = Math.max(0, Math.min((int)(t * (float)this.tDim), this.tDim - 1));
        float sr = s * (float)this.sDim - (float)sIndex;
        float tr = t * (float)this.tDim - (float)tIndex;
        float y = 0.0f;
        if (sIndex < this.sDim - 1 && tIndex < this.tDim - 1) {
            y = this.map[sIndex][tIndex] * (1.0f - sr) * (1.0f - tr);
            y += this.map[sIndex + 1][tIndex] * sr * (1.0f - tr);
            y += this.map[sIndex][tIndex + 1] * (1.0f - sr) * tr;
            y += this.map[sIndex + 1][tIndex + 1] * sr * tr;
        } else {
            y = this.map[sIndex][tIndex];
        }
        return Math.min((y - this.offset) * this.scale, 1.0f);
    }

    public float[][] getMap() {
        return this.map;
    }

    public int getSDim() {
        return this.sDim;
    }

    public int getTDim() {
        return this.tDim;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getS1() {
        return this.s1;
    }

    public void setS1(float s1) {
        this.s1 = s1;
    }

    public float getS2() {
        return this.s2;
    }

    public void setS2(float s2) {
        this.s2 = s2;
    }

    public float getT1() {
        return this.t1;
    }

    public void setT1(float t1) {
        this.t1 = t1;
    }

    public float getT2() {
        return this.t2;
    }

    public void setT2(float t2) {
        this.t2 = t2;
    }

    @Override
    public Vector3f sampleBinormal(float s, float t) {
        return new Vector3f(1.0f, 0.0f, 0.0f);
    }

    @Override
    public Vector3f sampleNormal(float s, float t) {
        return new Vector3f(0.0f, 1.0f, 0.0f);
    }

    @Override
    public Vector3f sampleTangent(float s, float t) {
        return new Vector3f(0.0f, 0.0f, 1.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        RAW_8,
        RAW_16;

    }
}

