/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openmali.FastMath;
import org.w3c.dom.Document;
import org.xith3d.terrain.DefaultGridResourceProvider;
import org.xith3d.terrain.GridResourceSpec;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L3DTResourceProvider
extends DefaultGridResourceProvider {
    private static XPath xpath = XPathFactory.newInstance().newXPath();
    private float minAlt;
    private float maxAlt;
    private float hScale;
    private long nx;
    private long ny;

    public final float getHScale() {
        return this.hScale;
    }

    public final float getMaxAlt() {
        return this.maxAlt;
    }

    public final float getMinAlt() {
        return this.minAlt;
    }

    public final long getNx() {
        return this.nx;
    }

    public final long getNy() {
        return this.ny;
    }

    private static int createMosaicSpecs(Properties mosaic, List<GridResourceSpec> specs, long bestWidth, long bestHeight, float min, float max) throws MalformedURLException {
        URL location = new URL(mosaic.getProperty("Location"));
        String baseName = mosaic.getProperty("BaseName");
        long width = Long.parseLong(mosaic.getProperty("nPxlsX"));
        long height = Long.parseLong(mosaic.getProperty("nPxlsY"));
        long tilesX = Long.parseLong(mosaic.getProperty("nMapsX"));
        long tilesY = Long.parseLong(mosaic.getProperty("nMapsY"));
        String ext = mosaic.getProperty("FileExt");
        float dx = 1.0f / (float)tilesX;
        float dy = 1.0f / (float)tilesY;
        int detail = (int)((double)((float)bestWidth / (float)width) + 0.5) + (int)((double)((float)bestHeight / (float)height) + 0.5) / 2;
        for (int i = 0; i < 32; ++i) {
            if (detail >> i != 0) continue;
            detail = i / 2;
            break;
        }
        int x = 0;
        while ((long)x < tilesX) {
            int y = 0;
            while ((long)y < tilesY) {
                specs.add(new GridResourceSpec(detail, new URL[]{new URL(location, baseName + "_x" + x + "y" + y + "." + ext)}, dx * (float)x, dy * (float)y, dx * (float)(x + 1), dy * (float)(y + 1), min, max));
                ++y;
            }
            ++x;
        }
        return detail;
    }

    private static List<Properties> findMipMaps(URL project, String type) {
        ArrayList<Properties> result = new ArrayList<Properties>(8);
        try {
            for (int i = 1; i <= 8; ++i) {
                Properties manifest;
                String mip = "Mip" + FastMath.pow((int)2, (int)i);
                URL manifestLocation = new URL(project, "MipMaps/" + type + "/" + mip + "/" + type + "_" + mip + ".mmf");
                if (L3DTResourceProvider.checkUrl(manifestLocation) && (manifest = L3DTResourceProvider.loadManifest(manifestLocation)) != null) {
                    result.add(manifest);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(L3DTResourceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    private static boolean checkUrl(URL location) {
        try {
            return location.openConnection().getContentLength() > 0;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadXML(URL location) {
        InputStream in = null;
        try {
            Document doc;
            in = location.openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            Document document = doc = factory.newDocumentBuilder().parse(in);
            return document;
        }
        catch (Exception ex) {
            Logger.getLogger(L3DTResourceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadManifest(URL location) throws Exception {
        location = new URL(location.toString().replace('\\', '/'));
        BufferedReader in = null;
        try {
            Properties props = new Properties();
            in = new BufferedReader(new InputStreamReader(location.openStream()));
            String line = "";
            while ((line = in.readLine()) != null) {
                if (!line.startsWith("#") || line.startsWith("#EOF")) continue;
                String[] values = line.split("[#:\t ]");
                if (values.length == 4) {
                    props.setProperty(values[1], values[3]);
                    continue;
                }
                if (values.length != 5) continue;
                props.setProperty(values[1] + "." + values[3], values[4]);
            }
            String locationString = location.toString();
            String baseName = locationString.substring(locationString.lastIndexOf("/") + 1, locationString.lastIndexOf("."));
            props.setProperty("Location", locationString);
            props.setProperty("BaseName", baseName);
            Properties properties = props;
            return properties;
        }
        catch (Exception ex) {
            Logger.getLogger(L3DTResourceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private static String buildXPath(String spec, String type) {
        String xpathexp = spec.replaceAll("([^\\/]+)\\/", "varlist[@name='$1']/");
        xpathexp = xpathexp.replaceAll("([^\\/]+)$", type + "[@name='$1']");
        return xpathexp;
    }

    private static float getFloat(Document doc, String spec) throws XPathExpressionException {
        String value = xpath.evaluate(L3DTResourceProvider.buildXPath(spec, "float"), doc);
        return Float.parseFloat(value);
    }

    private static long getInt(Document doc, String spec) throws XPathExpressionException {
        String value = xpath.evaluate(L3DTResourceProvider.buildXPath(spec, "int"), doc);
        return Long.parseLong(value);
    }

    private static String getString(Document doc, String spec) throws XPathExpressionException {
        return xpath.evaluate(L3DTResourceProvider.buildXPath(spec, "string"), doc);
    }

    public L3DTResourceProvider(URL l3dtProject) {
        ArrayList<GridResourceSpec> samplerSpecs = new ArrayList<GridResourceSpec>(100);
        ArrayList<GridResourceSpec> surfaceSpecs = new ArrayList<GridResourceSpec>(100);
        Document doc = L3DTResourceProvider.loadXML(l3dtProject);
        try {
            int i;
            int i2;
            this.nx = L3DTResourceProvider.getInt(doc, "/ProjectData/MapInfo/Terrain/nx");
            this.ny = L3DTResourceProvider.getInt(doc, "/ProjectData/MapInfo/Terrain/ny");
            this.minAlt = L3DTResourceProvider.getFloat(doc, "/ProjectData/MapInfo/Terrain/MinAlt");
            this.maxAlt = L3DTResourceProvider.getFloat(doc, "/ProjectData/MapInfo/Terrain/MaxAlt");
            this.hScale = L3DTResourceProvider.getFloat(doc, "/ProjectData/MapInfo/Terrain/HorizScale");
            String heightFieldLocation = L3DTResourceProvider.getString(doc, "/ProjectData/Maps/HF/Filename");
            List<Properties> mipMaps = L3DTResourceProvider.findMipMaps(l3dtProject, "HF");
            int maxDetail = 0;
            for (i2 = 0; i2 < mipMaps.size(); ++i2) {
                int value = L3DTResourceProvider.createMosaicSpecs(mipMaps.get(i2), samplerSpecs, this.nx, this.ny, this.minAlt, this.maxAlt);
                if (value <= maxDetail) continue;
                maxDetail = value;
            }
            if (heightFieldLocation.toString().endsWith(".mmf")) {
                L3DTResourceProvider.createMosaicSpecs(L3DTResourceProvider.loadManifest(new URL(l3dtProject, heightFieldLocation)), samplerSpecs, this.nx, this.ny, this.minAlt, this.maxAlt);
            } else {
                samplerSpecs.add(new GridResourceSpec(0, new URL(l3dtProject, heightFieldLocation), 0.0f, 0.0f, 1.0f, 1.0f, this.minAlt, this.maxAlt));
            }
            for (i2 = 0; i2 < samplerSpecs.size(); ++i2) {
                GridResourceSpec spec = samplerSpecs.get(i2);
                spec.setDetail(maxDetail - spec.getDetail());
            }
            long textureWidth = L3DTResourceProvider.getInt(doc, "/ProjectData/MapInfo/Texture/nx");
            long textureHeight = L3DTResourceProvider.getInt(doc, "/ProjectData/MapInfo/Texture/ny");
            String textureLocation = L3DTResourceProvider.getString(doc, "/ProjectData/Maps/TX/Filename");
            mipMaps = L3DTResourceProvider.findMipMaps(l3dtProject, "TX");
            maxDetail = 0;
            for (i = 0; i < mipMaps.size(); ++i) {
                int value = L3DTResourceProvider.createMosaicSpecs(mipMaps.get(i), surfaceSpecs, textureWidth, textureHeight, 0.0f, 0.0f);
                if (value <= maxDetail) continue;
                maxDetail = value;
            }
            if (textureLocation.toString().endsWith(".mmf")) {
                L3DTResourceProvider.createMosaicSpecs(L3DTResourceProvider.loadManifest(new URL(l3dtProject, textureLocation)), surfaceSpecs, textureWidth, textureHeight, 0.0f, 0.0f);
            } else {
                surfaceSpecs.add(new GridResourceSpec(0, new URL(l3dtProject, textureLocation), 0.0f, 0.0f, 1.0f, 1.0f));
            }
            for (i = 0; i < surfaceSpecs.size(); ++i) {
                GridResourceSpec spec = surfaceSpecs.get(i);
                spec.setDetail(maxDetail - spec.getDetail());
            }
        }
        catch (Exception ex) {
            X3DLog.print(ex);
            Logger.getLogger(L3DTResourceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setSamplerSpecs(samplerSpecs);
        this.setSurfaceSpecs(surfaceSpecs);
    }
}

