/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain;

import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.AbstractLODShape3D;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.traversal.DetailedTraversalCallback;
import org.xith3d.terrain.GridSampler;
import org.xith3d.terrain.GridSurface;
import org.xith3d.terrain.GridTriangulator;

public class TerrainTile
extends GroupNode {
    private GridTriangulator triangulator;
    private GridSampler sampler;
    private GridSurface shader;
    private Appearance appearance;
    private int surfaceDetail;
    private IndexedTriangleStripArray geometry;

    public TerrainTile(GridSampler sampler, GridSurface surface, GridTriangulator triangulator, int surfaceDetail) {
        float x1 = triangulator.getX1();
        float z1 = triangulator.getZ1();
        float x2 = triangulator.getX2();
        float z2 = triangulator.getZ2();
        float s1 = triangulator.getS1();
        float t1 = triangulator.getT1();
        float s2 = triangulator.getS2();
        float t2 = triangulator.getT2();
        this.triangulator = triangulator;
        this.sampler = sampler;
        this.shader = surface;
        this.surfaceDetail = surfaceDetail;
        this.appearance = surface.getAppearance();
        Tuple3f[] coordinates = triangulator.getCoordinates();
        int[] index = triangulator.getIndex();
        int units = surface.getTextureUnits();
        this.geometry = new IndexedTriangleStripArray(coordinates.length, index.length);
        this.geometry.setCoordinates(0, coordinates);
        this.geometry.setIndex(index);
        this.geometry.setValidIndexCount(index.length);
        this.geometry.setNormals(0, triangulator.getNormals());
        for (int u = 0; u < units; ++u) {
            TexCoord2f[] texCoordinates = new TexCoord2f[coordinates.length];
            for (int i = 0; i < coordinates.length; ++i) {
                texCoordinates[i] = surface.map(s1 + (coordinates[i].getX() - x1) / Math.abs(x2 - x1) * Math.abs(s2 - s1), t1 + (coordinates[i].getZ() - z1) / Math.abs(z2 - z1) * Math.abs(t2 - t1), u);
            }
            this.geometry.setTextureCoordinates(u, 0, (TexCoordf<?>[])texCoordinates);
        }
        this.addChild(new TerrainShape());
    }

    protected GroupNode newInstance() {
        return new TerrainTile(this.sampler, this.shader, this.triangulator, this.surfaceDetail);
    }

    public boolean traverse(DetailedTraversalCallback callback) {
        if (!callback.traversalOperationCommon(this)) {
            return false;
        }
        if (!callback.traversalOperation(this)) {
            return false;
        }
        if (callback.traversalCheckGroupCommon(this)) {
            int num = this.numChildren();
            for (int i = 0; i < num; ++i) {
                if (this.getChild(i).traverse(callback)) continue;
                return false;
            }
        }
        return callback.traversalOperationCommonAfter(this) && callback.traversalOperationAfter(this);
    }

    private class TerrainShape
    extends AbstractLODShape3D {
        int[][] lods;

        public TerrainShape() {
            super(TerrainTile.this.geometry, TerrainTile.this.appearance);
            this.lods = new int[8][0];
            float tolerance = TerrainTile.this.triangulator.getBaseTolerance();
            float size = TerrainTile.this.triangulator.getX2() - TerrainTile.this.triangulator.getX1();
            float step = size / 4.0f;
            float normRange = TerrainTile.this.triangulator.getS2() - TerrainTile.this.triangulator.getS1();
            for (int i = 0; i < 8; ++i) {
                this.lods[i] = i == 0 ? TerrainTile.this.triangulator.getIndex() : TerrainTile.this.triangulator.getIndex(tolerance + normRange * (float)i);
                this.addLOD(size + step * (float)i, i == 7 ? 1.0E20f : size + step * (float)(i + 1));
            }
        }

        protected void onLODChanged(int oldLOD, int newLOD, String name) {
            TerrainTile.this.geometry.setIndex(this.lods[newLOD]);
            TerrainTile.this.geometry.setValidIndexCount(this.lods[newLOD].length);
            TerrainTile.this.geometry.setStripVertexCounts(new int[]{this.lods[newLOD].length});
        }

        protected TerrainShape newInstance() {
            boolean gib = Node.globalIgnoreBounds;
            Node.globalIgnoreBounds = this.isIgnoreBounds();
            TerrainShape newShape = new TerrainShape();
            Node.globalIgnoreBounds = gib;
            return newShape;
        }

        public boolean traverse(DetailedTraversalCallback callback) {
            return super.traverse(callback);
        }
    }
}

