/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain.legacy;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.io.Archive;
import org.xith3d.io.InvalidFormat;
import org.xith3d.io.UnscribableNodeEncountered;
import org.xith3d.terrain.legacy.GroundHeightInterface;
import org.xith3d.terrain.legacy.TerrainCornerData;
import org.xith3d.terrain.legacy.TerrainDataBank;
import org.xith3d.terrain.legacy.TerrainRenderInterface;
import org.xith3d.terrain.legacy.TerrainSampleInterface;
import org.xith3d.terrain.legacy.TerrainSquareHandle;
import org.xith3d.utility.logging.X3DLog;

public class Terrain
implements GroundHeightInterface {
    static float DetailThreshold = 100.0f;
    static final float VERTICAL_SCALE = 1.0f;
    static LinkedList<TerrainCornerData> corners = new LinkedList();
    static Vector3f SunVector = new Vector3f(0.0705f, -0.9875f, -0.1411f);
    static int BlockDeleteCount = 0;
    static int BlockUpdateCount = 0;
    TerrainDataBank[] banks;
    TerrainDataBank[] banksHigh;
    TerrainDataBank[] banksLow;
    int maxBanks;
    int maxLevel;
    int bankLevel;
    int highSsample;
    int lowSample;
    TerrainCornerData rootData;
    TerrainSquareHandle root;
    Archive pagingFile;

    public Terrain(int maxLevel, int bankLevel) {
        this.maxLevel = maxLevel;
        this.maxBanks = (2 << maxLevel) / (2 << bankLevel);
        System.out.println("World size is " + (2 << maxLevel));
        System.out.println("bank size is " + (2 << bankLevel));
        System.out.println("total number of banks is " + this.maxBanks + " in two directions");
        this.bankLevel = bankLevel;
        this.banks = new TerrainDataBank[this.maxBanks * this.maxBanks + 1];
        for (int i = 0; i < this.maxBanks * this.maxBanks; ++i) {
            this.banks[i] = new TerrainDataBank(i, 10000);
        }
        this.banks[this.maxBanks * this.maxBanks] = new TerrainDataBank(this.maxBanks * this.maxBanks, 1000);
        this.rootData = new TerrainCornerData();
        this.rootData.level = maxLevel;
        this.rootData.square = this.root = this.newSquare(this.rootData);
    }

    public int getWidth() {
        return 2 << this.maxLevel;
    }

    public int getDepth() {
        return 2 << this.maxLevel;
    }

    public void load(String filename) throws IOException {
        this.pagingFile = new Archive(filename, true);
        for (int i = 0; i <= this.maxBanks * this.maxBanks; ++i) {
            try {
                TerrainDataBank b;
                this.banks[i].newBank = b = (TerrainDataBank)this.pagingFile.read("BANK_HIGH_" + i);
                this.banks[i] = b;
                continue;
            }
            catch (IOException e) {
                X3DLog.print(e);
                throw new IOException("cannot read terrain banks");
            }
            catch (InvalidFormat invalidFormat) {
                X3DLog.print(invalidFormat);
                throw new IOException("cannot read terrain banks");
            }
        }
        this.resetTree(this.root);
        this.recomputeError();
    }

    public void open(String filename) {
    }

    public void compressBanks() {
        for (int i = 0; i < this.maxBanks * this.maxBanks; ++i) {
            this.banks[i] = TerrainDataBank.compress(this.banks[i]);
        }
    }

    public void printBankUsage() {
        for (int i = 0; i < this.maxBanks; ++i) {
            for (int j = 0; j < this.maxBanks; ++j) {
                System.out.println("Bank [" + i + "][" + j + "] = " + this.banks[i * this.maxBanks + j].freeList);
            }
        }
        System.out.println("Master Bank  = " + this.banks[this.maxBanks * this.maxBanks].freeList);
    }

    private int getBank(TerrainCornerData pcd) {
        if (pcd.level > this.bankLevel) {
            return this.maxBanks * this.maxBanks;
        }
        int x = pcd.xorg / (2 << this.bankLevel);
        int z = pcd.zorg / (2 << this.bankLevel);
        if (x >= this.maxBanks || z >= this.maxBanks) {
            throw new Error("attempt to get coord outside banks " + pcd.xorg + "," + pcd.zorg);
        }
        return x * this.maxBanks + z;
    }

    private TerrainSquareHandle newSquare(TerrainCornerData pcd) {
        int i;
        TerrainSquareHandle s = new TerrainSquareHandle();
        s.bank = this.getBank(pcd);
        try {
            s.node = this.banks[s.bank].allocateNode();
        }
        catch (Throwable t) {
            this.banks[s.bank] = TerrainDataBank.expand(this.banks[s.bank]);
            s.node = this.banks[s.bank].allocateNode();
        }
        s.b = this.banks[s.bank];
        pcd.square = s;
        s.setStatic(false);
        for (i = 0; i < 4; ++i) {
            s.setChild(i, -1);
        }
        s.setEnabledFlags((byte)0);
        for (i = 0; i < 2; ++i) {
            s.setSubEnabledCount(i, (byte)0);
        }
        s.setY(0, 0.25f * (pcd.y[0] + pcd.y[1] + pcd.y[2] + pcd.y[3]));
        s.setY(1, 0.5f * (pcd.y[3] + pcd.y[0]));
        s.setY(2, 0.5f * (pcd.y[0] + pcd.y[1]));
        s.setY(3, 0.5f * (pcd.y[1] + pcd.y[2]));
        s.setY(4, 0.5f * (pcd.y[2] + pcd.y[3]));
        for (i = 0; i < 2; ++i) {
            s.setError(i, (short)0);
        }
        for (i = 0; i < 4; ++i) {
            s.setError(i + 2, (short)(Math.abs(s.getY(0) + pcd.y[i] - (s.getY(i + 1) + s.getY((i + 1 & 3) + 1))) * 0.25f));
        }
        s.setMinY((short)pcd.y[0]);
        s.setMaxY((short)pcd.y[0]);
        for (i = 1; i < 4; ++i) {
            float y = pcd.y[i];
            if (y < (float)s.getMinY()) {
                s.setMinY((short)y);
            }
            if (!(y > (float)s.getMaxY())) continue;
            s.setMaxY((short)y);
        }
        return s;
    }

    private static synchronized TerrainCornerData getTerrainCornerData() {
        if (corners.isEmpty()) {
            return new TerrainCornerData();
        }
        TerrainCornerData qd = corners.removeFirst();
        qd.init();
        return qd;
    }

    public static synchronized void releaseCorner(TerrainCornerData o) {
        corners.add(o);
    }

    private void SetupCornerData(TerrainCornerData q, TerrainCornerData cd, int childIndex) {
        int half = 1 << cd.level;
        q.parent = cd;
        q.square = new TerrainSquareHandle();
        q.square.node = cd.square.getChild(childIndex);
        q.square.bank = cd.square.getChildBank(childIndex);
        if (q.square.bank >= 0) {
            q.square.b = this.banks[q.square.bank];
        }
        q.level = cd.level - 1;
        q.childIndex = childIndex;
        switch (childIndex) {
            default: {
                q.xorg = cd.xorg + half;
                q.zorg = cd.zorg;
                q.y[0] = cd.y[0];
                q.y[1] = cd.square.getY(2);
                q.y[2] = cd.square.getY(0);
                q.y[3] = cd.square.getY(1);
                break;
            }
            case 1: {
                q.xorg = cd.xorg;
                q.zorg = cd.zorg;
                q.y[0] = cd.square.getY(2);
                q.y[1] = cd.y[1];
                q.y[2] = cd.square.getY(3);
                q.y[3] = cd.square.getY(0);
                break;
            }
            case 2: {
                q.xorg = cd.xorg;
                q.zorg = cd.zorg + half;
                q.y[0] = cd.square.getY(0);
                q.y[1] = cd.square.getY(3);
                q.y[2] = cd.y[2];
                q.y[3] = cd.square.getY(4);
                break;
            }
            case 3: {
                q.xorg = cd.xorg + half;
                q.zorg = cd.zorg + half;
                q.y[0] = cd.square.getY(1);
                q.y[1] = cd.square.getY(0);
                q.y[2] = cd.square.getY(4);
                q.y[3] = cd.y[3];
            }
        }
    }

    void SetStatic(TerrainCornerData cd) {
        if (!cd.square.getStatic()) {
            cd.square.setStatic(true);
            if (cd.parent != null && cd.parent.square != null) {
                this.SetStatic(cd.parent);
            }
        }
    }

    public int CountNodes() {
        return this.CountNodes(this.root);
    }

    public int CountNodes(TerrainSquareHandle sq) {
        int count = 1;
        for (int i = 0; i < 4; ++i) {
            TerrainSquareHandle c = this.getChild(sq, i);
            if (c == null) continue;
            count += this.CountNodes(c);
        }
        return count;
    }

    public float getY(float x, float z) {
        return this.getHeight(this.rootData, x, z, false);
    }

    public float getCurY(float x, float z) {
        return this.getHeight(this.rootData, x, z, false);
    }

    float getHeight(TerrainCornerData cd, float x, float z, boolean enabledOnly) {
        float s11;
        float s10;
        float s01;
        float s00;
        int index;
        TerrainSquareHandle c;
        int half = 1 << cd.level;
        float lx = (x - (float)cd.xorg) / (float)half;
        float lz = (z - (float)cd.zorg) / (float)half;
        int ix = (int)Math.floor(lx);
        int iz = (int)Math.floor(lz);
        if (ix < 0) {
            ix = 0;
        }
        if (ix > 1) {
            ix = 1;
        }
        if (iz < 0) {
            iz = 0;
        }
        if (iz > 1) {
            iz = 1;
        }
        if ((c = this.getChild(cd, index = ix ^ (iz ^ 1) + (iz << 1))) != null && (!enabledOnly || (c.getEnabledFlags() & 16 << index) != 0) && c != null && c.getStatic()) {
            TerrainCornerData q = Terrain.getTerrainCornerData();
            this.SetupCornerData(q, cd, index);
            float height = this.getHeight(q, x, z, enabledOnly);
            Terrain.releaseCorner(q);
            return height;
        }
        if ((lx -= (float)ix) < 0.0f) {
            lx = 0.0f;
        }
        if (lx > 1.0f) {
            lx = 1.0f;
        }
        lz -= (float)iz;
        if (lx < 0.0f) {
            lz = 0.0f;
        }
        if (lz > 1.0f) {
            lz = 1.0f;
        }
        switch (index) {
            default: {
                s00 = cd.square.getY(2);
                s01 = cd.y[0];
                s10 = cd.square.getY(0);
                s11 = cd.square.getY(1);
                break;
            }
            case 1: {
                s00 = cd.y[1];
                s01 = cd.square.getY(2);
                s10 = cd.square.getY(3);
                s11 = cd.square.getY(0);
                break;
            }
            case 2: {
                s00 = cd.square.getY(3);
                s01 = cd.square.getY(0);
                s10 = cd.y[2];
                s11 = cd.square.getY(4);
                break;
            }
            case 3: {
                s00 = cd.square.getY(0);
                s01 = cd.square.getY(1);
                s10 = cd.square.getY(4);
                s11 = cd.y[3];
            }
        }
        return (s00 * (1.0f - lx) + s01 * lx) * (1.0f - lz) + (s10 * (1.0f - lx) + s11 * lx) * lz;
    }

    TerrainSquareHandle GetNeighbor(TerrainSquareHandle sq, int dir, TerrainCornerData cd) {
        boolean SameParent;
        if (cd.parent == null) {
            return null;
        }
        TerrainSquareHandle p = null;
        int index = cd.childIndex ^ 1 ^ (dir & 1) << 1;
        boolean bl = SameParent = (dir - cd.childIndex & 2) != 0;
        if (SameParent) {
            p = cd.parent.square;
        } else {
            p = this.GetNeighbor(cd.parent.square, dir, cd.parent);
            if (p == null) {
                return null;
            }
        }
        TerrainSquareHandle n = this.getChild(p, index);
        return n;
    }

    public float recomputeError() {
        return this.recomputeError(this.root, this.rootData);
    }

    float recomputeError(TerrainSquareHandle sq, TerrainCornerData cd) {
        float y;
        int i;
        float maxerror;
        float e = (cd.childIndex & 1) != 0 ? Math.abs(sq.getY(0) - (cd.y[1] + cd.y[3]) * 0.5f) : Math.abs(sq.getY(0) - (cd.y[0] + cd.y[2]) * 0.5f);
        if (e > (maxerror = 0.0f)) {
            maxerror = e;
        }
        short MaxY = (short)sq.getY(0);
        short MinY = (short)sq.getY(0);
        for (i = 0; i < 4; ++i) {
            y = cd.y[i];
            if (y < (float)MinY) {
                MinY = (short)y;
            }
            if (!(y > (float)MaxY)) continue;
            MaxY = (short)y;
        }
        e = Math.abs(sq.getY(1) - (cd.y[0] + cd.y[3]) * 0.5f);
        if (e > maxerror) {
            maxerror = e;
        }
        sq.setError(0, (short)e);
        e = Math.abs(sq.getY(4) - (cd.y[2] + cd.y[3]) * 0.5f);
        if (e > maxerror) {
            maxerror = e;
        }
        sq.setError(1, (short)e);
        for (i = 0; i < 4; ++i) {
            y = sq.getY(1 + i);
            if (y < (float)MinY) {
                MinY = (short)y;
            }
            if (!(y > (float)MaxY)) continue;
            MaxY = (short)y;
        }
        cd.square.setMinY(MinY);
        cd.square.setMaxY(MaxY);
        for (i = 0; i < 4; ++i) {
            TerrainCornerData q = new TerrainCornerData();
            TerrainSquareHandle c = this.getChild(cd, i);
            if (c != null) {
                this.SetupCornerData(q, cd, i);
                sq.setError(i + 2, (short)this.recomputeError(q.square, q));
                if (q.square.getMinY() < MinY) {
                    MinY = q.square.getMinY();
                }
                if (q.square.getMaxY() > MaxY) {
                    MaxY = q.square.getMaxY();
                }
            } else {
                sq.setError(i + 2, (short)(Math.abs(sq.getY(0) + cd.y[i] - (sq.getY(i + 1) + sq.getY((i + 1 & 3) + 1))) * 0.25f));
            }
            if (!((float)sq.getError(i + 2) > maxerror)) continue;
            maxerror = sq.getError(i + 2);
        }
        cd.square.setDirty(false);
        cd.square.setMinY(MinY);
        cd.square.setMaxY(MaxY);
        return maxerror;
    }

    void resetTree(TerrainSquareHandle sq) {
        for (int i = 0; i < 4; ++i) {
            TerrainSquareHandle c = this.getChild(sq, i);
            if (c == null) continue;
            this.resetTree(c);
            if (c.getStatic()) continue;
            c.delete();
            sq.setChild(i, -1);
            sq.setChildBank(i, -1);
        }
        sq.setEnabledFlags((byte)0);
        sq.setSubEnabledCount(0, (byte)0);
        sq.setSubEnabledCount(1, (byte)0);
        sq.setDirty(true);
    }

    public void cullStaticData(float threshold, int maxLevelToCull) {
        this.staticCullData(this.root, this.rootData, threshold, maxLevelToCull);
    }

    void staticCullData(TerrainSquareHandle sq, TerrainCornerData cd, float thresholdDetail, int maxLevelToCull) {
        this.resetTree(sq);
        if (sq.getDirty()) {
            this.recomputeError(sq, cd);
        }
        for (int level = 0; level < maxLevelToCull; ++level) {
            this.staticCullAux(sq, cd, thresholdDetail, level);
        }
    }

    void deleteStaticData(TerrainSquareHandle sq, TerrainCornerData cd, int TargetLevel) {
        if (cd.level > TargetLevel) {
            TerrainCornerData q = new TerrainCornerData();
            for (int j = 0; j < 4; ++j) {
                int i = j < 2 ? 1 - j : j;
                TerrainSquareHandle c = this.getChild(sq, i);
                if (c == null) continue;
                this.SetupCornerData(q, cd, i);
                this.deleteStaticData(c, q, TargetLevel);
            }
            return;
        }
        boolean StaticChildren = false;
        for (int i = 0; i < 4; ++i) {
            if (this.getChild(sq, i) == null) continue;
            StaticChildren = true;
            if (!this.getChild(sq, i).getDirty()) continue;
            sq.setDirty(true);
        }
        if (!StaticChildren && cd.parent != null) {
            TerrainSquareHandle c = this.getChild(cd.parent.square, cd.childIndex);
            c.delete();
            cd.parent.square.setChild(cd.childIndex, -1);
            cd.parent.square.setChildBank(cd.childIndex, -1);
        }
    }

    void staticCullAux(TerrainSquareHandle sq, TerrainCornerData cd, float thresholdDetail, int targetLevel) {
        int i;
        float y;
        TerrainSquareHandle s;
        if (cd.level > targetLevel) {
            TerrainCornerData q = new TerrainCornerData();
            for (int j = 0; j < 4; ++j) {
                int i2 = j < 2 ? 1 - j : j;
                TerrainSquareHandle c = this.getChild(sq, i2);
                if (c == null) continue;
                this.SetupCornerData(q, cd, i2);
                this.staticCullAux(c, q, thresholdDetail, targetLevel);
            }
            return;
        }
        float size = 2 << cd.level;
        if (sq.getChild(0) == -1 && sq.getChild(3) == -1 && (float)sq.getError(0) * thresholdDetail < size && ((s = this.GetNeighbor(sq, 0, cd)) == null || s.getChild(1) == -1 && s.getChild(2) == -1)) {
            y = (cd.y[0] + cd.y[3]) * 0.5f;
            sq.setY(1, y);
            sq.setError(0, (short)0);
            if (s != null) {
                s.setY(3, y);
            }
            sq.setDirty(true);
        }
        if (sq.getChild(2) == -1 && sq.getChild(3) == -1 && (float)sq.getError(1) * thresholdDetail < size && ((s = this.GetNeighbor(sq, 3, cd)) == null || s.getChild(0) == -1 && s.getChild(1) == -1)) {
            y = (cd.y[2] + cd.y[3]) * 0.5f;
            sq.setY(4, y);
            sq.setError(1, (short)0);
            if (s != null) {
                s.setY(2, y);
            }
            sq.setDirty(true);
        }
        boolean staticChildren = false;
        for (i = 0; i < 4; ++i) {
            if (this.getChild(sq, i) == null) continue;
            staticChildren = true;
            if (!this.getChild(sq, i).getDirty()) continue;
            sq.setDirty(true);
        }
        if (!staticChildren && cd.parent != null) {
            boolean necessaryEdges = false;
            for (i = 0; i < 4; ++i) {
                float diff = Math.abs(sq.getY(i + 1) - (cd.y[i] + cd.y[i + 3 & 3]) * 0.5f);
                if (!(diff > 1.0E-5f)) continue;
                necessaryEdges = true;
            }
            if (!necessaryEdges) {
                size *= 1.4142135f;
                if ((float)cd.parent.square.getError(2 + cd.childIndex) * thresholdDetail < size) {
                    TerrainSquareHandle c = this.getChild(cd.parent.square, cd.childIndex);
                    c.delete();
                    cd.parent.square.setChild(cd.childIndex, -1);
                    cd.parent.square.setChildBank(cd.childIndex, -1);
                }
            }
        }
    }

    void enableEdgeVertex(TerrainSquareHandle sq, int index, boolean incrementCount, TerrainCornerData cd) {
        boolean SameParent;
        if ((sq.getEnabledFlags() & 1 << index) != 0 && !incrementCount) {
            return;
        }
        sq.setEnabledFlags((byte)(sq.getEnabledFlags() | 1 << index));
        if (incrementCount && (index == 0 || index == 3)) {
            sq.incSubEnabledCount(index & 1);
        }
        TerrainSquareHandle p = cd.square;
        TerrainCornerData pcd = cd;
        int ct = 0;
        int[] stack = new int[32];
        do {
            int ci = pcd.childIndex;
            if (pcd.parent == null || pcd.parent.square == null) {
                return;
            }
            p = pcd.parent.square;
            pcd = pcd.parent;
            SameParent = (index - ci & 2) != 0;
            stack[ct] = ci = ci ^ 1 ^ (index & 1) << 1;
            ++ct;
        } while (!SameParent);
        p = this.EnableDescendant(p, ct, stack, pcd);
        if (p == null) {
            throw new Error("enabled descendant is null!");
        }
        p.setEnabledFlags((byte)(p.getEnabledFlags() | 1 << (index ^= 2)));
        if (incrementCount && (index == 0 || index == 3)) {
            p.setSubEnabledCount(index & 1, (byte)(p.getSubEnabledCount(index & 1) + 1));
        }
    }

    TerrainSquareHandle getChild(TerrainCornerData cd, int index) {
        if (cd.square.getChild(index) == -1) {
            return null;
        }
        TerrainSquareHandle s = new TerrainSquareHandle();
        s.node = cd.square.getChild(index);
        s.bank = cd.square.getChildBank(index);
        s.b = this.banks[s.bank];
        return s;
    }

    TerrainSquareHandle getChild(TerrainSquareHandle s, int index) {
        if (s.getChild(index) == -1) {
            return null;
        }
        TerrainSquareHandle ss = new TerrainSquareHandle();
        ss.node = s.getChild(index);
        ss.bank = s.getChildBank(index);
        ss.b = this.banks[ss.bank];
        return ss;
    }

    TerrainSquareHandle EnableDescendant(TerrainSquareHandle sq, int count, int[] path, TerrainCornerData cd) {
        int ChildIndex = path[--count];
        if ((cd.square.getEnabledFlags() & 16 << ChildIndex) == 0) {
            this.EnableChild(sq, ChildIndex, cd);
        }
        if (count <= 0) {
            return this.getChild(cd, ChildIndex);
        }
        TerrainCornerData q = new TerrainCornerData();
        this.SetupCornerData(q, cd, ChildIndex);
        TerrainSquareHandle qs = this.EnableDescendant(sq, count, path, q);
        return qs;
    }

    void CreateChild(TerrainSquareHandle sq, int index, TerrainCornerData cd) {
        if (cd.square.getChild(index) == -1) {
            TerrainCornerData q = new TerrainCornerData();
            this.SetupCornerData(q, cd, index);
            TerrainSquareHandle h = this.newSquare(q);
            cd.square.setChild(index, h.node);
            cd.square.setChildBank(index, h.bank);
        }
    }

    void EnableChild(TerrainSquareHandle sq, int index, TerrainCornerData cd) {
        if ((cd.square.getEnabledFlags() & 16 << index) == 0) {
            cd.square.setEnabledFlags((byte)(cd.square.getEnabledFlags() | 16 << index));
            this.enableEdgeVertex(sq, index, true, cd);
            this.enableEdgeVertex(sq, index + 1 & 3, true, cd);
            if (this.getChild(cd, index) == null) {
                this.CreateChild(sq, index, cd);
            }
        }
    }

    void NotifyChildDisable(TerrainSquareHandle sq, TerrainCornerData cd, int index) {
        TerrainSquareHandle c;
        cd.square.setEnabledFlags((byte)(cd.square.getEnabledFlags() & ~(16 << index)));
        TerrainSquareHandle s = (index & 2) != 0 ? cd.square : this.GetNeighbor(sq, 1, cd);
        if (s != null) {
            s.setSubEnabledCount(1, (byte)(s.getSubEnabledCount(1) - 1));
        }
        if ((s = index == 1 || index == 2 ? this.GetNeighbor(sq, 2, cd) : cd.square) != null) {
            s.setSubEnabledCount(0, (byte)(s.getSubEnabledCount(0) - 1));
        }
        if (!(c = this.getChild(sq, index)).getStatic()) {
            c.delete();
            sq.setChild(index, -1);
            sq.setChildBank(index, -1);
            ++BlockDeleteCount;
        }
    }

    static boolean vertexTest(float x, float y, float z, float error, float[] Viewer) {
        float dx = Math.abs(x - Viewer[0]);
        float dy = Math.abs(y - Viewer[1]);
        float dz = Math.abs(z - Viewer[2]);
        float d = dx;
        if (dy > d) {
            d = dy;
        }
        if (dz > d) {
            d = dz;
        }
        return error * DetailThreshold > d;
    }

    static boolean BoxTest(float x, float z, float size, float miny, float maxy, float error, float[] Viewer) {
        float half = size * 0.5f;
        float dx = Math.abs(x + half - Viewer[0]) - half;
        float dy = Math.abs((miny + maxy) * 0.5f - Viewer[1]) - (maxy - miny) * 0.5f;
        float dz = Math.abs(z + half - Viewer[2]) - half;
        float d = dx;
        if (dy > d) {
            d = dy;
        }
        if (dz > d) {
            d = dz;
        }
        return error * DetailThreshold > d;
    }

    public void update(Tuple3f loc, float detail) {
        this.Update(this.root, this.rootData, new float[]{loc.getX(), loc.getY(), loc.getZ()}, detail);
    }

    public void Update(TerrainSquareHandle sq, TerrainCornerData cd, float[] ViewerLocation, float Detail) {
        DetailThreshold = Detail * 1.0f;
        this.UpdateAux(sq, cd, ViewerLocation, 0.0f);
    }

    void UpdateAux(TerrainSquareHandle sq, TerrainCornerData cd, float[] ViewerLocation, float CenterError) {
        TerrainSquareHandle s;
        ++BlockUpdateCount;
        if (sq.getDirty()) {
            this.recomputeError(sq, cd);
        }
        int half = 1 << cd.level;
        int whole = half << 1;
        if ((sq.getEnabledFlags() & 1) == 0 && Terrain.vertexTest(cd.xorg + whole, sq.getY(1), cd.zorg + half, sq.getError(0), ViewerLocation)) {
            this.enableEdgeVertex(sq, 0, false, cd);
        }
        if ((sq.getEnabledFlags() & 8) == 0 && Terrain.vertexTest(cd.xorg + half, sq.getY(4), cd.zorg + whole, sq.getError(1), ViewerLocation)) {
            this.enableEdgeVertex(sq, 3, false, cd);
        }
        if (cd.level > 0) {
            if ((sq.getEnabledFlags() & 0x20) == 0 && Terrain.BoxTest(cd.xorg, cd.zorg, half, sq.getMinY(), sq.getMaxY(), sq.getError(3), ViewerLocation)) {
                this.EnableChild(sq, 1, cd);
            }
            if ((sq.getEnabledFlags() & 0x10) == 0 && Terrain.BoxTest(cd.xorg + half, cd.zorg, half, sq.getMinY(), sq.getMaxY(), sq.getError(2), ViewerLocation)) {
                this.EnableChild(sq, 0, cd);
            }
            if ((sq.getEnabledFlags() & 0x40) == 0 && Terrain.BoxTest(cd.xorg, cd.zorg + half, half, sq.getMinY(), sq.getMaxY(), sq.getError(4), ViewerLocation)) {
                this.EnableChild(sq, 2, cd);
            }
            if ((sq.getEnabledFlags() & 0x80) == 0 && Terrain.BoxTest(cd.xorg + half, cd.zorg + half, half, sq.getMinY(), sq.getMaxY(), sq.getError(5), ViewerLocation)) {
                this.EnableChild(sq, 3, cd);
            }
            TerrainCornerData q = Terrain.getTerrainCornerData();
            if ((sq.getEnabledFlags() & 0x20) != 0) {
                this.SetupCornerData(q, cd, 1);
                this.UpdateAux(q.square, q, ViewerLocation, sq.getError(3));
            }
            if ((sq.getEnabledFlags() & 0x10) != 0) {
                this.SetupCornerData(q, cd, 0);
                this.UpdateAux(q.square, q, ViewerLocation, sq.getError(2));
            }
            if ((sq.getEnabledFlags() & 0x40) != 0) {
                this.SetupCornerData(q, cd, 2);
                this.UpdateAux(q.square, q, ViewerLocation, sq.getError(4));
            }
            if ((sq.getEnabledFlags() & 0x80) != 0) {
                this.SetupCornerData(q, cd, 3);
                this.UpdateAux(q.square, q, ViewerLocation, sq.getError(5));
            }
            Terrain.releaseCorner(q);
        }
        if ((sq.getEnabledFlags() & 1) != 0 && sq.getSubEnabledCount(0) == 0 && !Terrain.vertexTest(cd.xorg + whole, sq.getY(1), cd.zorg + half, sq.getError(0), ViewerLocation)) {
            sq.andEnabledFlags((byte)-2);
            s = this.GetNeighbor(sq, 0, cd);
            if (s != null) {
                s.andEnabledFlags((byte)-5);
            }
        }
        if ((sq.getEnabledFlags() & 8) != 0 && sq.getSubEnabledCount(1) == 0 && !Terrain.vertexTest(cd.xorg + half, sq.getY(4), cd.zorg + whole, sq.getError(1), ViewerLocation)) {
            sq.andEnabledFlags((byte)-9);
            s = this.GetNeighbor(sq, 3, cd);
            if (s != null) {
                s.andEnabledFlags((byte)-3);
            }
        }
        if (sq.getEnabledFlags() == 0 && cd.parent != null && !Terrain.BoxTest(cd.xorg, cd.zorg, whole, sq.getMinY(), sq.getMaxY(), CenterError, ViewerLocation)) {
            this.NotifyChildDisable(cd.parent.square, cd.parent, cd.childIndex);
        }
    }

    void clearHeightData(TerrainCornerData cd, TerrainSampleInterface hm) {
    }

    public void addData(TerrainSampleInterface sample) {
        this.AddHeightMap(this.root, this.rootData, sample, 0.0f);
    }

    public void addData(TerrainSampleInterface sample, float minDetail) {
        this.AddHeightMap(this.root, this.rootData, sample, minDetail);
    }

    void AddHeightMap(TerrainSquareHandle sq, TerrainCornerData cd, TerrainSampleInterface hm, float minDetail) {
        int i;
        int BlockSize = 2 << cd.level;
        if ((float)cd.xorg > hm.getXOrg() + (float)(hm.getXDim() + 2 << hm.getScale()) || (float)(cd.xorg + BlockSize) < hm.getXOrg() - (float)(1 << hm.getScale()) || (float)cd.zorg > hm.getZOrg() + (float)(hm.getZDim() + 2 << hm.getScale()) || (float)(cd.zorg + BlockSize) < hm.getZOrg() - (float)(1 << hm.getScale())) {
            return;
        }
        if (cd.parent != null && cd.parent.square != null) {
            this.EnableChild(cd.parent.square, cd.childIndex, cd.parent);
        }
        int half = 1 << cd.level;
        for (i = 0; i < 4; ++i) {
            TerrainCornerData q = new TerrainCornerData();
            this.SetupCornerData(q, cd, i);
            if (sq.getChild(i) == -1 && cd.level > hm.getScale()) {
                this.CreateChild(sq, i, cd);
                this.SetupCornerData(q, cd, i);
            }
            if (sq.getChild(i) == -1) continue;
            this.AddHeightMap(q.square, q, hm, minDetail);
            if (q.level != this.bankLevel || !(minDetail > 0.0f)) continue;
            int bank = this.getBank(q);
            X3DLog.printlnEx("compressing bank ", bank);
            this.staticCullData(this.getChild(sq, i), q, minDetail, this.bankLevel);
            this.banks[bank] = TerrainDataBank.compress(this.banks[bank]);
            System.gc();
        }
        float[] s = new float[]{hm.sample(cd.xorg + half, cd.zorg + half), hm.sample(cd.xorg + half * 2, cd.zorg + half), hm.sample(cd.xorg + half, cd.zorg), hm.sample(cd.xorg, cd.zorg + half), hm.sample(cd.xorg + half, cd.zorg + half * 2)};
        for (i = 0; i < 5; ++i) {
            sq.setDirty(true);
            sq.setY(i, s[i]);
        }
        if (!sq.getDirty()) {
            for (i = 0; i < 4; ++i) {
                if (sq.getChild(i) == -1 || !this.getChild(sq, i).getDirty()) continue;
                sq.setDirty(true);
                break;
            }
        }
        if (sq.getDirty()) {
            this.SetStatic(cd);
        }
    }

    public int render(TerrainRenderInterface r) {
        return this.render(this.rootData, r);
    }

    int render(TerrainCornerData cd, TerrainRenderInterface r) {
        int n = this.renderAux(cd.square, cd, r);
        return n;
    }

    int renderAux(TerrainSquareHandle sq, TerrainCornerData cd, TerrainRenderInterface r) {
        int half = 1 << cd.level;
        int whole = 2 << cd.level;
        int num = 0;
        int flags = 0;
        int mask = 1;
        TerrainCornerData q = Terrain.getTerrainCornerData();
        int i = 0;
        while (i < 4) {
            if ((sq.getEnabledFlags() & 16 << i) != 0) {
                this.SetupCornerData(q, cd, i);
                num += this.renderAux(q.square, q, r);
            } else {
                flags |= mask;
            }
            ++i;
            mask <<= 1;
        }
        Terrain.releaseCorner(q);
        if (flags == 0) {
            return num;
        }
        r.start();
        r.initVert(0, cd.xorg + half, sq.getY(0), cd.zorg + half);
        r.initVert(1, cd.xorg + whole, sq.getY(1), cd.zorg + half);
        r.initVert(2, cd.xorg + whole, cd.y[0], cd.zorg);
        r.initVert(3, cd.xorg + half, sq.getY(2), cd.zorg);
        r.initVert(4, cd.xorg, cd.y[1], cd.zorg);
        r.initVert(5, cd.xorg, sq.getY(3), cd.zorg + half);
        r.initVert(6, cd.xorg, cd.y[2], cd.zorg + whole);
        r.initVert(7, cd.xorg + half, sq.getY(4), cd.zorg + whole);
        r.initVert(8, cd.xorg + whole, cd.y[3], cd.zorg + whole);
        if ((sq.getEnabledFlags() & 1) == 0) {
            r.tri(0, 8, 2);
        } else {
            if ((flags & 8) != 0) {
                r.tri(0, 8, 1);
            }
            if ((flags & 1) != 0) {
                r.tri(0, 1, 2);
            }
        }
        if ((sq.getEnabledFlags() & 2) == 0) {
            r.tri(0, 2, 4);
        } else {
            if ((flags & 1) != 0) {
                r.tri(0, 2, 3);
            }
            if ((flags & 2) != 0) {
                r.tri(0, 3, 4);
            }
        }
        if ((sq.getEnabledFlags() & 4) == 0) {
            r.tri(0, 4, 6);
        } else {
            if ((flags & 2) != 0) {
                r.tri(0, 4, 5);
            }
            if ((flags & 4) != 0) {
                r.tri(0, 5, 6);
            }
        }
        if ((sq.getEnabledFlags() & 8) == 0) {
            r.tri(0, 6, 8);
        } else {
            if ((flags & 4) != 0) {
                r.tri(0, 6, 7);
            }
            if ((flags & 8) != 0) {
                r.tri(0, 7, 8);
            }
        }
        r.done();
        return num;
    }

    public void buildDatabase(TerrainSampleInterface hm, float minDetail) {
        this.compressBanks();
        float bankWidth = 2 << this.bankLevel;
        MultiPassSampler mps = new MultiPassSampler(hm);
        for (int i = 0; i < this.maxBanks; ++i) {
            for (int j = 0; j < this.maxBanks; ++j) {
                if (!mps.setBounds((float)i * bankWidth, (float)j * bankWidth, bankWidth)) continue;
                X3DLog.printlnEx("processing bank ", i, "-", j, " = ", i * this.maxBanks + j);
                X3DLog.debug("   range is ", (int)mps.getXOrg(), "x", (int)mps.getZOrg(), "  -  ", mps.getXOrg() + (float)(mps.getXDim() << mps.getScale()) + "x" + (mps.getZOrg() + (float)(mps.getZDim() << mps.getScale())));
                this.AddHeightMap(this.root, this.rootData, mps, 0.0f);
                System.gc();
                System.gc();
                X3DLog.printlnEx("   done");
            }
        }
        X3DLog.printlnEx("final compression");
        this.cullStaticData(minDetail, this.bankLevel - 1);
        this.compressBanks();
        X3DLog.printlnEx("done");
    }

    public void buildDatabase(String filename, TerrainSampleInterface hm, TerrainSampleInterface lm, float minHighDetail, float minLowDetail) throws IOException {
        int i;
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
        Archive a = new Archive(filename, false);
        this.buildDatabase(hm, minHighDetail);
        X3DLog.printlnEx("Saving high res data");
        try {
            for (i = 0; i <= this.maxBanks * this.maxBanks; ++i) {
                a.write("BANK_HIGH_" + i, this.banks[i], true);
            }
        }
        catch (UnscribableNodeEncountered unscribableNodeEncountered) {
            X3DLog.print(unscribableNodeEncountered);
            throw new Error("cannot save data");
        }
        X3DLog.printlnEx("Done Saving data");
        X3DLog.printlnEx("Nodes for high detail = ", this.CountNodes());
        for (i = 0; i < lm.getScale() + 1; ++i) {
            this.deleteStaticData(this.root, this.rootData, i);
        }
        this.cullStaticData(minLowDetail, this.bankLevel - 1);
        this.buildDatabase(lm, minLowDetail);
        X3DLog.printlnEx("Nodes for low detail = " + this.CountNodes());
        X3DLog.printlnEx("Saving low res data");
        try {
            for (i = 0; i <= this.maxBanks * this.maxBanks; ++i) {
                a.write("BANK_LOW_" + i, this.banks[i], true);
            }
        }
        catch (UnscribableNodeEncountered unscribableNodeEncountered) {
            X3DLog.print(unscribableNodeEncountered);
            throw new Error("cannot save data");
        }
        a.close();
    }

    class MultiPassSampler
    implements TerrainSampleInterface {
        float xStart;
        float zStart;
        int xDim;
        int zDim;
        TerrainSampleInterface sampler;

        MultiPassSampler(TerrainSampleInterface s) {
            this.sampler = s;
        }

        public boolean setBounds(float x, float z, float width) {
            float lx = x;
            float lz = z;
            float ux = x + width;
            float uz = z + width;
            int size = this.sampler.getXDim() << this.sampler.getScale();
            lx = this.sampler.getXOrg() > x ? this.sampler.getXOrg() : x;
            lz = this.sampler.getZOrg() > z ? this.sampler.getZOrg() : z;
            if (this.sampler.getXOrg() + (float)size < ux) {
                ux = this.sampler.getXOrg() + (float)size;
            }
            if (this.sampler.getZOrg() + (float)size < uz) {
                uz = this.sampler.getZOrg() + (float)size;
            }
            if (ux - lx <= 0.0f) {
                return false;
            }
            if (uz - lz <= 0.0f) {
                return false;
            }
            this.xStart = lx;
            this.zStart = lz;
            this.xDim = (int)((ux - lx) / (float)(1 << this.sampler.getScale()));
            this.zDim = (int)((uz - lz) / (float)(1 << this.sampler.getScale()));
            return true;
        }

        public int getScale() {
            return this.sampler.getScale();
        }

        public float sample(int x, int z) {
            return this.sampler.sample(x, z);
        }

        public float getXOrg() {
            return this.xStart;
        }

        public float getZOrg() {
            return this.zStart;
        }

        public int getXDim() {
            return this.xDim;
        }

        public int getZDim() {
            return this.zDim;
        }
    }
}

