/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain.legacy.heightmap;

import java.util.Random;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.terrain.legacy.heightmap.HeightMap;
import org.xith3d.terrain.legacy.heightmap.Terrain;

public class Faulting
extends HeightMap
implements Terrain {
    private static final long serialVersionUID = -4450585657315846596L;
    private int width = 256;
    private int height = 256;
    private Random rgen;

    public Faulting(int width, int height, double scalefactor, Random rgen) {
        this.width = width;
        this.height = height;
        this.rgen = rgen;
        this.generateTerrain();
    }

    private int rand0(int range) {
        double d = this.rgen.nextDouble();
        int i = (int)(d * (double)range);
        if (i < 0) {
            i = -i;
        }
        return i;
    }

    synchronized void doFaulting(int iterations) {
        int x;
        int y;
        int h;
        int wmod = this.width;
        int hmod = this.width;
        this.heightmap = new float[this.width][this.width];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.heightmap[i][j] = 0.0f;
            }
        }
        while (iterations-- > 0) {
            int px = this.rand0(wmod);
            int py = this.rand0(hmod);
            double pfi = this.rgen.nextDouble() * 2.0 * Math.PI;
            double cp = Math.cos(pfi);
            double sp = Math.sin(pfi);
            int n = h = pfi > 1.5707963267948966 && pfi <= 4.71238898038469 ? -1 : 1;
            if (sp > -0.01 && sp < 0.01) {
                ++iterations;
                continue;
            }
            if (cp > -0.01 && cp < 0.01) {
                ++iterations;
                continue;
            }
            double mx = cp / sp;
            y = py + 1;
            double dx = (double)px + mx;
            x = (int)dx;
            while (y < this.height && x >= 0 && x < this.width) {
                float[] fArray = this.heightmap[x];
                int n2 = y++;
                fArray[n2] = fArray[n2] + (float)h;
                x = (int)((dx += mx) + 0.5);
            }
            if (x < 0 && y < this.height) {
                while (y < this.height) {
                    float[] fArray = this.heightmap[0];
                    int n3 = y++;
                    fArray[n3] = fArray[n3] + (float)h;
                }
            }
            y = py;
            dx = px;
            x = px;
            while (y >= 0 && x >= 0 && x < this.width) {
                float[] fArray = this.heightmap[x];
                int n4 = y--;
                fArray[n4] = fArray[n4] + (float)h;
                x = (int)((dx -= mx) + 0.5);
            }
            if (x >= 0 || y < 0) continue;
            while (y >= 0) {
                float[] fArray = this.heightmap[0];
                int n5 = y--;
                fArray[n5] = fArray[n5] + (float)h;
            }
        }
        for (y = 0; y < this.height; ++y) {
            h = 0;
            for (x = 0; x < this.width; ++x) {
                h = (int)((float)h + this.heightmap[x][y]);
                this.heightmap[x][y] = h;
            }
        }
    }

    public void generateTerrain() {
        this.doFaulting(10000);
    }

    public Geometry generateGeometry(float startX, float startY, float stepX, float stepY) {
        return this.generate3D(startX, startY, stepX, stepY, 0);
    }
}

