/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import java.util.List;
import org.xith3d.ui.hud.base.AbstractList;
import org.xith3d.ui.hud.base.Widget;

public abstract class ListModel {
    private AbstractList list;
    private boolean usesFixedHeight = true;
    private float fixedItemHeight = -1.0f;
    private int selectedIndex = -1;

    void setList(AbstractList list) {
        this.list = list;
        this.markListDirty();
    }

    protected final AbstractList getList() {
        return this.list;
    }

    protected abstract Widget[] getUsedWidgets();

    protected abstract void addItemImpl(int var1, Object var2);

    public final void addItem(int index, Object item) {
        if (index < 0 || index > this.getItemsCount()) {
            throw new IllegalArgumentException("index must be in range [0, itemsCount].");
        }
        this.addItemImpl(index, item);
    }

    public final int addItem(Object item) {
        int index = this.getItemsCount();
        this.addItemImpl(index, item);
        return index;
    }

    public void addItems(List items) {
        for (Object item : items) {
            this.addItem(item);
        }
    }

    public void addItems(Object[] items) {
        for (Object item : items) {
            this.addItem(item);
        }
    }

    protected abstract void setItemImpl(int var1, Object var2);

    public final void setItem(int index, Object item) {
        if (index < 0 || index >= this.getItemsCount()) {
            throw new IllegalArgumentException("index must be in range [0, itemsCount).");
        }
        this.setItemImpl(index, item);
    }

    protected abstract Object removeItemImpl(int var1);

    public final Object removeItem(int index) {
        if (index < 0 || index >= this.getItemsCount()) {
            throw new IllegalArgumentException("index must be in range [0, itemsCount).");
        }
        return this.removeItemImpl(index);
    }

    public abstract void clear();

    public abstract int getItemsCount();

    protected abstract Object getItemImpl(int var1);

    public Object getItem(int index) {
        if (index < 0 || index >= this.getItemsCount()) {
            return null;
        }
        return this.getItemImpl(index);
    }

    protected abstract Widget getWidgetImpl(int var1);

    protected abstract void prepareWidgetImpl(float var1, Widget var2, Object var3, int var4);

    protected void prepareWidget(float listContentWidth, Widget widget, Object item, int itemIndex) {
        if (this.getUsesFixedHeight()) {
            widget.setSize(listContentWidth, this.getItemHeight(0));
        } else {
            widget.setSize(listContentWidth, this.getItemHeight(itemIndex));
        }
        this.prepareWidgetImpl(listContentWidth, widget, item, itemIndex);
    }

    final Widget getWidget(float listContentWidth, int itemIndex) {
        Object item = this.getItem(itemIndex);
        Widget widget = this.getWidgetImpl(itemIndex);
        this.prepareWidget(listContentWidth, widget, item, itemIndex);
        return widget;
    }

    protected final Widget getWidget(int itemIndex) {
        return this.getWidget(this.getList().getContentWidth(), itemIndex);
    }

    public boolean hoverNeedsRedraw() {
        return false;
    }

    protected boolean checkOnMouseButtonPressedImpl(int itemIndex, float itemTop, float itemBottom, float mouseX, float mouseY) {
        return true;
    }

    public final boolean checkOnMouseButtonPressed(int itemIndex, float itemLeft, float listContentWidth, float itemTop, float itemBottom, float mouseX, float mouseY) {
        Widget widget = this.getWidgetImpl(itemIndex);
        this.getList().getWidgetAssembler().reposition(widget, itemLeft, itemTop);
        widget.setSize(listContentWidth, itemBottom - itemTop);
        return this.checkOnMouseButtonPressedImpl(itemIndex, itemTop, itemBottom, mouseX, mouseY);
    }

    public void setUsesFixedHeight(boolean usesFixedHeight) {
        if (usesFixedHeight == this.usesFixedHeight) {
            return;
        }
        this.usesFixedHeight = usesFixedHeight;
        this.fixedItemHeight = -1.0f;
    }

    public final boolean getUsesFixedHeight() {
        return this.usesFixedHeight;
    }

    protected abstract float getItemHeightImpl(int var1);

    public final float getItemHeight(int itemIndex) {
        if (itemIndex < 0) {
            return -1.0f;
        }
        if (itemIndex >= this.getItemsCount()) {
            return -1.0f;
        }
        if (this.getUsesFixedHeight()) {
            if (this.fixedItemHeight < 0.0f) {
                this.fixedItemHeight = this.getItemHeightImpl(itemIndex);
            }
            return this.fixedItemHeight;
        }
        return this.getItemHeightImpl(itemIndex);
    }

    protected abstract float getMinItemWidthImpl(int var1);

    public final float getMinItemWidth(int itemIndex) {
        if (itemIndex < 0) {
            return -1.0f;
        }
        if (itemIndex >= this.getItemsCount()) {
            return -1.0f;
        }
        return this.getMinItemWidthImpl(itemIndex);
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object getSelectedItem() {
        int selIdx = this.getSelectedIndex();
        if (selIdx < 0 || selIdx >= this.getItemsCount()) {
            return null;
        }
        return this.getItem(selIdx);
    }

    public boolean isSelected(int index) {
        return index == this.selectedIndex;
    }

    public void markListDirty() {
        if (this.list != null) {
            this.list.updateSizesAndMarkDirty();
        }
    }
}

