/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.base;

import java.util.ArrayList;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Dim2i;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.Border;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.base.WindowHeaderWidget;
import org.xith3d.ui.hud.borders.TexturedBorder;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.listeners.WidgetMouseAdapter;
import org.xith3d.ui.hud.listeners.WindowListener;
import org.xith3d.ui.hud.utils.HUDPickResult;

public abstract class Window
extends Widget {
    private WindowHeaderWidget headerWidget;
    private boolean redrawHeaderWidgetOnly = false;
    private CloseOperation closeOperation = CloseOperation.DETACH;
    private WidgetContainer contentPane;
    private boolean keepContentPaneSize;
    private boolean paneDraggingEnabled = false;
    private Point2f dragStart = null;
    private final Point2f tmpDragStart = new Point2f();
    private Point2f dragStartWindow = null;
    private final Point2f tmpDragStartWindow = new Point2f();
    private final ArrayList<WindowListener> listeners = new ArrayList();

    protected final WindowHeaderWidget getHeaderWidget() {
        return this.headerWidget;
    }

    public final boolean isDecorated() {
        return this.headerWidget != null;
    }

    public float getHeaderHeight() {
        WindowHeaderWidget headerWidget = this.getHeaderWidget();
        if (headerWidget == null) {
            return 0.0f;
        }
        return headerWidget.getHeight();
    }

    public void setTitle(String title) {
        if (!this.isDecorated()) {
            throw new Error("This Window isn't decorated.");
        }
        if (title == null) {
            throw new IllegalArgumentException("You cannot set the window title to null.");
        }
        this.headerWidget.setText(title);
        this.contentPane.setName("ContentPane of Window: \"" + title + "\"");
    }

    public final String getTitle() {
        if (!this.isDecorated()) {
            return null;
        }
        return this.headerWidget.getText();
    }

    public final WidgetContainer getContentPane() {
        return this.contentPane;
    }

    protected final int getContentWidthPX() {
        return this.getContentPane().getContentWidthPX();
    }

    protected final int getContentHeightPX() {
        return this.getContentPane().getContentHeightPX();
    }

    public void setContentSize(float contentWidth, float contentHeight) {
        float headerHeight = this.getHeaderHeight();
        float borderWidth = 0.0f;
        float borderHeight = 0.0f;
        if (this.getBorder() != null) {
            Dim2f buffer = Dim2f.fromPool();
            this.getSizePixels2HUD_(this.getBorder().getLeftWidth() + this.getBorder().getRightWidth(), this.getBorder().getTopHeight() + this.getBorder().getBottomHeight() + 1, buffer);
            borderWidth = buffer.getWidth();
            borderHeight = buffer.getHeight();
            Dim2f.toPool((Dim2f)buffer);
        }
        this.setSize(contentWidth + borderWidth, contentHeight + headerHeight + borderHeight);
    }

    public final float getResX() {
        return this.getContentPane().getResX();
    }

    public final float getResY() {
        return this.getContentPane().getResY();
    }

    public void setDefaultCloseOperation(CloseOperation op) {
        this.closeOperation = op;
    }

    public final CloseOperation getDefaultCloseOperation() {
        return this.closeOperation;
    }

    public void setCloseButtonVisible(boolean visible) {
        if (this.headerWidget == null) {
            throw new UnsupportedOperationException("This method is not supported for undecorated Windows.");
        }
        this.headerWidget.getCloseButton().setVisible(visible);
    }

    public boolean isCloseButtonVisible() {
        if (this.headerWidget == null) {
            throw new UnsupportedOperationException("This method is not supported for undecorated Windows.");
        }
        return this.headerWidget.getCloseButton().isVisible();
    }

    public void setPaneDraggingEnabled(boolean enabled) {
        this.paneDraggingEnabled = enabled;
    }

    public final boolean isPaneDraggingEnabled() {
        return this.paneDraggingEnabled;
    }

    protected boolean checkDragStartCondition(float postionOnWindowX, float postionOnWindowY) {
        if (this.paneDraggingEnabled) {
            return true;
        }
        if (this.headerWidget == null) {
            return false;
        }
        return this.headerWidget.isMouseOverBar(postionOnWindowX, postionOnWindowY);
    }

    protected void startDragging(int canvasX, int canvasY, float widgetX, float widgetY) {
        if (this.checkDragStartCondition(widgetX, widgetY)) {
            this.dragStart = this.tmpDragStart;
            Tuple2f tmp = Tuple2f.fromPool();
            this.getAbsoluteLocationOnHUD_(tmp);
            this.dragStart.set(tmp.getX() + widgetX, tmp.getY() + widgetY);
            Tuple2f.toPool((Tuple2f)tmp);
            this.dragStartWindow = this.tmpDragStartWindow;
            this.dragStartWindow.set(this.getLeft(), this.getTop());
            this.bindToGlobalMouseMovement();
        }
    }

    protected void onMouseButtonPressed(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        super.onMouseButtonPressed(button, x, y, when, lastWhen, isTopMost, hasFocus);
        if (this.isDraggable() && isTopMost) {
            this.getContentPane().onMouseButtonPressed(button, x, y, when, lastWhen, isTopMost, hasFocus);
        }
    }

    protected void onMouseButtonReleased(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        super.onMouseButtonReleased(button, x, y, when, lastWhen, isTopMost, hasFocus);
        this.dragStart = null;
        this.dragStartWindow = null;
        if (isTopMost) {
            this.getContentPane().onMouseButtonReleased(button, x, y, when, lastWhen, isTopMost, hasFocus);
        }
    }

    protected void onMouseMoved(float x, float y, int buttonsState, long when, boolean isTopMost, boolean hasFocus) {
        if (this.dragStart != null) {
            Tuple2f tmp = Tuple2f.fromPool();
            this.getAbsoluteLocationOnHUD_(tmp);
            float absX = tmp.getX() + x;
            float absY = tmp.getY() + y;
            Tuple2f.toPool((Tuple2f)tmp);
            float windowPosX = this.dragStartWindow.getX() + (absX - this.dragStart.getX());
            float windowPosY = this.dragStartWindow.getY() + (absY - this.dragStart.getY());
            float titleHeight = this.isDecorated() ? this.headerWidget.getHeight() : 0.0f;
            windowPosX = Math.max(windowPosX, 0.0f - this.getWidth() + titleHeight);
            windowPosX = Math.min(windowPosX, this.getHUD().getResX() - titleHeight);
            windowPosY = Math.max(windowPosY, 0.0f);
            windowPosY = Math.min(windowPosY, this.getHUD().getResY() - titleHeight);
            this.setLocation(windowPosX, windowPosY, false, false);
        }
        if (isTopMost) {
            this.getContentPane().onMouseMoved(x, y, buttonsState, when, isTopMost, hasFocus);
        }
    }

    protected void onMouseWheelMoved(int delta, boolean isPageMove, float x, float y, long when, boolean isTopMost) {
        super.onMouseWheelMoved(delta, isPageMove, x, y, when, isTopMost);
        if (isTopMost) {
            this.getContentPane().onMouseWheelMoved(delta, isPageMove, x, y, when, isTopMost);
        }
    }

    protected void onFocusLost() {
        this.getContentPane().onFocusLost();
    }

    private static void forwardOnMouseExited(Widget widget, boolean isTopMost, boolean hasFocus) {
        if (widget == null) {
            return;
        }
        if (widget instanceof WidgetContainer) {
            Window.forwardOnMouseExited(((WidgetContainer)widget).getCurrentHoveredWidget(), isTopMost, hasFocus);
            widget.onMouseExited(isTopMost, false);
            ((WidgetContainer)widget).resetCurrentHoveredWidget();
        } else {
            widget.onMouseExited(isTopMost, false);
        }
    }

    private void forwardOnMouseExited(boolean isTopMost, boolean hasFocus) {
        Window.forwardOnMouseExited(this.getContentPane().getCurrentHoveredWidget(), isTopMost, hasFocus);
        this.getContentPane().resetCurrentHoveredWidget();
    }

    protected void onMouseExited(boolean isTopMost, boolean hasFocus) {
        super.onMouseExited(isTopMost, hasFocus);
        if (this.isDecorated() && this.getHeaderWidget().getCloseButton() != null) {
            this.getHeaderWidget().getCloseButton().onMouseExited(isTopMost, hasFocus);
        }
        this.forwardOnMouseExited(isTopMost, hasFocus);
    }

    protected void onKeyPressed(Key key, int modifierMask, long when) {
        this.getContentPane().onKeyPressed(key, modifierMask, when);
    }

    protected void onKeyReleased(Key key, int modifierMask, long when) {
        this.getContentPane().onKeyReleased(key, modifierMask, when);
    }

    protected void onKeyTyped(char ch, int modifierMask, long when) {
        this.getContentPane().onKeyTyped(ch, modifierMask, when);
    }

    public void addWindowListener(WindowListener l) {
        this.listeners.add(l);
    }

    public void removeWindowListener(WindowListener l) {
        this.listeners.remove(l);
    }

    public void detach() {
        if (this.getHUD() != null) {
            this.getHUD().removeWindow(this);
        }
    }

    protected void onCloseButtonClicked() {
        if (this.getDefaultCloseOperation() == null) {
            return;
        }
        switch (this.getDefaultCloseOperation()) {
            case DETACH: {
                this.getHeaderWidget().getCloseButton().setButtonState(AbstractButton.ButtonState.NORMAL);
                this.detach();
            }
        }
    }

    protected void onVisibilityChanged(boolean visible) {
        super.onVisibilityChanged(visible);
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (visible) {
                this.listeners.get(i).onWindowShown(this);
                continue;
            }
            this.listeners.get(i).onWindowHidden(this);
        }
    }

    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        float headerHeight = 0.0f;
        float innerLeft = 0.0f;
        float innerTop = 0.0f;
        float innerWidth = newWidth;
        float innerHeight = newHeight;
        if (this.isDecorated() && this.getHUD() != null) {
            WindowHeaderWidget headerWidget = this.getHeaderWidget();
            headerHeight = headerWidget.getHeight();
            headerWidget.setSize(newWidth, headerHeight);
            innerTop += headerHeight;
            innerHeight -= headerHeight;
            if (this.getBorder() != null) {
                Dim2f buffer = Dim2f.fromPool();
                this.getSizePixels2HUD_(this.getBorder().getLeftWidth(), this.getBorder().getTopHeight(), buffer);
                innerLeft += buffer.getWidth();
                innerTop += buffer.getHeight();
                innerWidth -= buffer.getWidth();
                innerHeight -= buffer.getHeight();
                this.getSizePixels2HUD_(this.getBorder().getRightWidth(), this.getBorder().getBottomHeight(), buffer);
                innerWidth -= buffer.getWidth();
                innerHeight -= buffer.getHeight();
                Dim2f.toPool((Dim2f)buffer);
            }
        }
        if (this.getWidgetAssembler().contains(this.contentPane)) {
            this.contentPane.setSize(innerWidth, innerHeight);
        }
    }

    protected HUDPickResult pick(int canvasX, int canvasY, HUDPickResult.HUDPickReason pickReason, MouseButton button, long when, long meta, int flags) {
        HUDPickResult result = super.pick(canvasX, canvasY, pickReason, button, when, meta, flags);
        if (result == null) {
            return null;
        }
        WidgetContainer contentPane = this.getContentPane();
        boolean isCPPickable = contentPane.isPickable();
        contentPane.setPickable(true);
        result.setSubResult(((Widget)contentPane).pick(canvasX, canvasY, pickReason, button, when, meta, flags));
        contentPane.setPickable(isCPPickable);
        return result;
    }

    protected void onDetachedFromHUD(HUD hud) {
        this.getContentPane().onDetachedFromHUD(hud);
        super.onDetachedFromHUD(hud);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onWindowClosed(this);
        }
    }

    void setHUD(HUD hud) {
        super.setHUD(hud);
        this.getContentPane().setHUD(hud);
    }

    public String toString() {
        if (this.isDecorated()) {
            return this.getClass().getSimpleName() + "(\"" + this.headerWidget.getText() + "\")";
        }
        return super.toString();
    }

    protected void setHostTextureDirty(int flags) {
        if (!this.isAHostedWidgetDirty()) {
            this.redrawHeaderWidgetOnly = (flags & 1) != 0;
        }
        super.setHostTextureDirty(flags & 0xFFFFFFFE);
    }

    protected void setTextureDirty(int flags) {
        if (!this.isThisWidgetDirty()) {
            this.redrawHeaderWidgetOnly = (flags & 1) != 0;
        }
        super.setTextureDirty(flags & 0xFFFFFFFE);
    }

    protected void drawBorder(Border border, Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        if (this.isDecorated()) {
            Dim2i d = Dim2i.fromPool();
            this.getSizeHUD2Pixels_(0.0f, this.getHeaderHeight(), d);
            int headerHeight = d.getHeight();
            Dim2i.toPool((Dim2i)d);
            super.drawBorder(border, texCanvas, offsetX, offsetY + headerHeight, width, height - headerHeight);
        } else {
            super.drawBorder(border, texCanvas, offsetX, offsetY, width, height);
        }
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
    }

    public void drawAndUpdateWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        if (this.redrawHeaderWidgetOnly) {
            Dim2i tmp = Dim2i.fromPool();
            this.getSizeHUD2Pixels_(0.0f, this.getHeaderHeight(), tmp);
            height = tmp.getHeight();
            Dim2i.toPool((Dim2i)tmp);
            texCanvas.beginUpdateRegion(offsetX, offsetY, width, height);
            this.headerWidget.drawAndUpdateWidget(texCanvas, offsetX, offsetY, width, height, false);
            texCanvas.finishUpdateRegion();
            this.redrawHeaderWidgetOnly = false;
            this.resetWidgetDirty();
        } else {
            super.drawAndUpdateWidget(texCanvas, offsetX, offsetY, width, height, drawsSelf);
        }
    }

    protected void init() {
        float innerLeft = 0.0f;
        float innerTop = 0.0f;
        if (this.isDecorated()) {
            float innerWidth = this.getWidth();
            float innerHeight = this.getHeight();
            float outerWidth = this.getWidth();
            float outerHeight = this.getHeight();
            WindowHeaderWidget headerWidget = this.getHeaderWidget();
            this.getWidgetAssembler().addWidget(headerWidget);
            innerTop += headerWidget.getHeight();
            innerHeight -= headerWidget.getHeight();
            outerHeight += headerWidget.getHeight();
            if (this.getBorder() != null) {
                Dim2f buffer = Dim2f.fromPool();
                this.getSizePixels2HUD_(this.getBorder().getLeftWidth(), this.getBorder().getTopHeight(), buffer);
                innerLeft += buffer.getWidth();
                innerTop += buffer.getHeight();
                innerWidth -= buffer.getWidth();
                innerHeight -= buffer.getHeight();
                outerWidth += buffer.getWidth();
                outerHeight += buffer.getHeight();
                this.getSizePixels2HUD_(this.getBorder().getRightWidth(), this.getBorder().getBottomHeight(), buffer);
                innerWidth -= buffer.getWidth();
                innerHeight -= buffer.getHeight();
                outerWidth += buffer.getWidth();
                outerHeight += buffer.getHeight();
                Dim2f.toPool((Dim2f)buffer);
            }
            if (this.keepContentPaneSize) {
                this.setSize(outerWidth, outerHeight);
            } else {
                this.contentPane.setSize(innerWidth, innerHeight);
            }
        }
        this.getWidgetAssembler().addWidget(this.contentPane, innerLeft, innerTop);
        this.contentPane.setPickable(false);
    }

    protected abstract WindowHeaderWidget createHeaderWidget(WindowHeaderWidget.Description var1, String var2);

    protected abstract WidgetContainer createContentPane(float var1, float var2);

    private Window(float width, float height, boolean keepContentPaneSize, WidgetContainer contentPane, WindowHeaderWidget.Description headerDesc, String title, WindowHeaderWidget headerWidget) {
        super(true, true, width, height);
        if (headerWidget == null) {
            if (title == null) {
                this.headerWidget = null;
            } else {
                this.headerWidget = this.createHeaderWidget(headerDesc, title);
                if (this.headerWidget == null) {
                    throw new Error("Window.createHeaderWidget() MUST NOT return null.");
                }
                if (this.getWidgetAssembler().contains(this.headerWidget)) {
                    throw new Error("Window.createHeaderWidget() MUST NOT put the header Widget to the WidgetAssembler.");
                }
            }
        } else {
            this.headerWidget = headerWidget;
        }
        if (this.isDecorated()) {
            if (this.headerWidget.getCloseButton() != null) {
                this.headerWidget.getCloseButton().addButtonListener(new ButtonListener(){

                    public void onButtonClicked(AbstractButton button, Object userObject) {
                        Window.this.onCloseButtonClicked();
                    }
                });
            }
            this.headerWidget.addMouseListener(new WidgetMouseAdapter(){

                public void onMouseEntered(Widget widget, boolean isTopMost, boolean hasFocus) {
                    Window.this.forwardOnMouseExited(isTopMost, hasFocus);
                }
            });
            this.setBorder(new TexturedBorder(HUD.getTheme().getFrameBorderDescription()));
        }
        this.keepContentPaneSize = keepContentPaneSize;
        this.contentPane = contentPane == null ? this.createContentPane(width, height) : contentPane;
        if (this.isDecorated()) {
            this.contentPane.setName("ContentPane of Window: \"" + this.getTitle() + "\"");
        } else {
            this.contentPane.setName("ContentPane of an undecorated Window");
        }
        this.contentPane.setContentPaneOf(this);
        this.setHasDropShadow(true);
        this.setDraggable(true);
        this.getWidgetAssembler().setPickDispatched(true);
    }

    protected Window(float width, float height, boolean keepContentPaneSize, WidgetContainer contentPane, WindowHeaderWidget.Description headerDesc, String title) {
        this(width, height, keepContentPaneSize, contentPane, headerDesc, title, null);
    }

    protected Window(float width, float height, boolean keepContentPaneSize, WidgetContainer contentPane, WindowHeaderWidget headerWidget) {
        this(width, height, keepContentPaneSize, contentPane, null, null, headerWidget);
    }

    public Window(WidgetContainer contentPane, WindowHeaderWidget.Description headerDesc, String title) {
        this(contentPane.getWidth(), contentPane.getHeight(), true, contentPane, headerDesc, title, null);
    }

    public Window(WidgetContainer contentPane, WindowHeaderWidget headerWidget) {
        this(contentPane.getWidth(), contentPane.getHeight(), true, contentPane, null, null, headerWidget);
    }

    public Window(WidgetContainer contentPane, String title) {
        this(contentPane, title != null ? HUD.getTheme().getWindowHeaderDescription() : null, title);
    }

    public Window(WidgetContainer contentPane) {
        this(contentPane, (String)null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CloseOperation {
        DETACH;

    }
}

