/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.dialogs;

import java.util.ArrayList;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.TextWidget;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.base.Window;
import org.xith3d.ui.hud.base.WindowHeaderWidget;
import org.xith3d.ui.hud.base.__HUD_base_PrivilegedAccess;
import org.xith3d.ui.hud.borders.EmptyBorder;
import org.xith3d.ui.hud.layout.HullLayout;
import org.xith3d.ui.hud.layout.ListLayout;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.listeners.DialogListener;
import org.xith3d.ui.hud.listeners.WindowAdapter;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.Dialog;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.TextField;
import org.xith3d.ui.text2d.TextAlignment;

public class InputBox
extends Dialog {
    private static Factory factory = new DefaultFactory();
    private static final ArrayList<InputBox> cache = new ArrayList();
    private final CacheManager cacheManager = new CacheManager();
    private TextWidget messageWidget = null;
    private TextField textField = null;
    private Button btnOK = null;
    private Button btnCancel = null;
    private InputBoxListener listener = null;
    private boolean cancelled = false;

    public static void setFactory(Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null.");
        }
        InputBox.factory = factory;
    }

    public static final Factory getFactory() {
        return factory;
    }

    public void setMessageWidget(TextWidget widget) {
        this.messageWidget = widget;
    }

    public final TextWidget getMessageWidget() {
        return this.messageWidget;
    }

    public void setTextField(TextField textField) {
        this.textField = textField;
    }

    public final TextField getTextField() {
        return this.textField;
    }

    public void setOKButton(Button button) {
        this.btnOK = button;
    }

    public final Button getOKButton() {
        return this.btnOK;
    }

    public void setCancelButton(Button button) {
        this.btnCancel = button;
    }

    public final Button getCancelButton() {
        return this.btnCancel;
    }

    public void setMessage(String message) {
        this.getMessageWidget().setText(message);
    }

    public void setText(String text) {
        this.getTextField().setText(text);
    }

    public final String getText() {
        return this.getTextField().getText();
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    private InputBox() {
        super(300.0f, 150.0f, "");
        this.getContentPane().setClippingEnabled(false);
        this.getContentPane().setBorder(new EmptyBorder(15, 15, 10, 15));
        ListLayout listLayout = new ListLayout(ListLayout.Orientation.VERTICAL, 15.0f);
        listLayout.setOtherSpanCalculated(true);
        HullLayout hullLayout = new HullLayout(listLayout);
        this.getContentPane().setLayout(hullLayout);
        this.addWindowListener(this.cacheManager);
        factory.create(this);
        if (this.getMessageWidget() == null) {
            throw new Error("The currently used Factory doesn't set the message-widget.");
        }
        if (this.getOKButton() == null) {
            throw new Error("The currently used Factory doesn't set the OK-Button.");
        }
        if (this.getCancelButton() == null) {
            throw new Error("The currently used Factory doesn't set the Cancel-Button.");
        }
        this.getOKButton().addButtonListener(new ButtonListener(){

            public void onButtonClicked(AbstractButton button, Object userObject) {
                InputBox.this.setCloseCommand(button.getUserObject());
                InputBox.this.cancelled = false;
                InputBox.this.detach();
                if (InputBox.this.listener != null) {
                    InputBox.this.listener.onInputBoxClosed(InputBox.this, false, InputBox.this.getText());
                }
            }
        });
        this.getCancelButton().addButtonListener(new ButtonListener(){

            public void onButtonClicked(AbstractButton button, Object userObject) {
                InputBox.this.setCloseCommand(button.getUserObject());
                InputBox.this.cancelled = true;
                InputBox.this.detach();
                if (InputBox.this.listener != null) {
                    InputBox.this.listener.onInputBoxClosed(InputBox.this, true, InputBox.this.getText());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final InputBox show(String title, String message, String initialValue, HUD hud, DialogListener dialogListener, InputBoxListener inputBoxListener) {
        InputBox inputBox;
        ArrayList<InputBox> arrayList = cache;
        synchronized (arrayList) {
            inputBox = cache.size() > 0 ? cache.remove(cache.size() - 1) : new InputBox();
        }
        inputBox.removeAllDialogListeners();
        if (dialogListener != null) {
            inputBox.addDialogListener(dialogListener);
        }
        inputBox.listener = inputBoxListener;
        WindowHeaderWidget whw = inputBox.getHeaderWidget();
        if (whw != null) {
            inputBox.getHeaderWidget().setText(title);
        }
        inputBox.setMessage(message);
        inputBox.setText(initialValue);
        __HUD_base_PrivilegedAccess.setTextureDirty(inputBox);
        hud.addWindowCentered(inputBox);
        inputBox.getTextField().requestFocus();
        return inputBox;
    }

    public static final InputBox show(String title, String message, String initialValue, HUD hud, DialogListener listener) {
        return InputBox.show(title, message, initialValue, hud, listener, null);
    }

    public static final InputBox show(String message, String initialValue, HUD hud, DialogListener listener) {
        return InputBox.show("Text-Input", message, initialValue, hud, listener);
    }

    public static final InputBox show(String initialValue, HUD hud, DialogListener listener) {
        return InputBox.show("Text-Input:", initialValue, hud, listener);
    }

    public static final InputBox show(String title, String message, String initialValue, HUD hud, InputBoxListener listener) {
        return InputBox.show(title, message, initialValue, hud, null, listener);
    }

    public static final InputBox show(String message, String initialValue, HUD hud, InputBoxListener listener) {
        return InputBox.show("Text-Input", message, initialValue, hud, listener);
    }

    public static final InputBox show(String initialValue, HUD hud, InputBoxListener listener) {
        return InputBox.show("Text-Input:", initialValue, hud, listener);
    }

    public static final InputBox show(String message, String initialValue, HUD hud) {
        return InputBox.show("Text-Input", message, initialValue, hud, null, null);
    }

    public static final InputBox show(String initialValue, HUD hud) {
        return InputBox.show("Text-Input:", initialValue, hud);
    }

    private static class CacheManager
    extends WindowAdapter {
        private CacheManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowClosed(Window window) {
            ArrayList arrayList = cache;
            synchronized (arrayList) {
                cache.add((InputBox)window);
            }
        }
    }

    private static class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        public Texture2D getIconTexture() {
            return null;
        }

        protected String getOKText() {
            return "OK";
        }

        protected String getCancelText() {
            return "Cancel";
        }

        public void create(InputBox inputBox) {
            WidgetContainer pane = inputBox.getContentPane();
            Label msgLabel = new Label(-1.0f, -1.0f, "", TextAlignment.TOP_LEFT);
            pane.addWidget(msgLabel);
            inputBox.setMessageWidget(msgLabel);
            TextField textField = new TextField(100.0f, 24.0f, "");
            pane.addWidget(textField);
            inputBox.setTextField(textField);
            Panel buttonsPanel = new Panel(false, 205.0f, 24.0f);
            buttonsPanel.setClippingEnabled(false);
            ListLayout ll = new ListLayout(ListLayout.Orientation.HORIZONTAL, 5.0f);
            ll.setAlignment(ListLayout.Alignment.RIGHT_CENTER);
            buttonsPanel.setLayout(ll);
            Button btnOK = new Button(100.0f, 24.0f, this.getOKText());
            btnOK.setUserObject("OK");
            inputBox.setOKButton(btnOK);
            buttonsPanel.addWidget(btnOK);
            Button btnCancel = new Button(100.0f, 24.0f, this.getCancelText());
            btnCancel.setUserObject("CANCEL");
            inputBox.setCancelButton(btnCancel);
            buttonsPanel.addWidget(btnCancel);
            pane.addWidget(buttonsPanel);
        }
    }

    public static interface Factory {
        public Texture2D getIconTexture();

        public void create(InputBox var1);
    }

    public static interface InputBoxListener {
        public void onInputBoxClosed(InputBox var1, boolean var2, String var3);
    }
}

