/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.layout;

import java.util.ArrayList;
import java.util.HashSet;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.layout.BorderSettableLayoutManager;
import org.xith3d.ui.hud.layout.LayoutManager;
import org.xith3d.ui.hud.listeners.WidgetSizeListener;
import org.xith3d.ui.hud.listeners.WidgetVisibilityListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayoutManagerBase
implements LayoutManager {
    final WidgetSizeListener sizeListener = new WidgetSizeListener(){
        private final HashSet<Widget> ignoredWidgets = new HashSet();

        public void onWidgetSizeChanged(Widget widget, float oldWidth, float oldHeight, float newWidth, float newHeight) {
            if (!this.ignoredWidgets.contains(widget) && widget.getHUD() != null) {
                this.ignoredWidgets.add(widget);
                LayoutManagerBase.this.doLayout(widget.getContainer());
                this.ignoredWidgets.remove(widget);
            }
        }
    };
    final WidgetVisibilityListener visibilityListener = new WidgetVisibilityListener(){

        public void onWidgetVisibilityChanged(Widget widget, boolean isVisible) {
            if (LayoutManagerBase.this.getInvisibleWidgetsHidden() && widget.getHUD() != null) {
                LayoutManagerBase.this.doLayout(widget.getContainer());
            }
        }
    };
    private final BorderSettableLayoutManager borderSource;
    private final ArrayList<Widget> widgets = new ArrayList();
    private boolean inivisibleWidgetsHidden = true;
    private boolean isWorking = false;

    @Override
    public final void setInvisibleWidgetsHidden(boolean hidden) {
        this.inivisibleWidgetsHidden = hidden;
    }

    @Override
    public final boolean getInvisibleWidgetsHidden() {
        return this.inivisibleWidgetsHidden;
    }

    public final ArrayList<Widget> getWidgets() {
        return this.widgets;
    }

    @Override
    public void addWidget(Widget widget, Object constraints) {
        if (widget != null) {
            this.widgets.add(widget);
            widget.addSizeListener(this.sizeListener);
            widget.addVisibilityListener(this.visibilityListener);
        }
    }

    @Override
    public void removeWidget(Widget widget) {
        if (widget != null) {
            this.widgets.remove(widget);
            widget.removeSizeListener(this.sizeListener);
            widget.removeVisibilityListener(this.visibilityListener);
        }
    }

    @Override
    public void clear() {
        this.widgets.clear();
    }

    protected abstract void doLayout(float var1, float var2, float var3, float var4);

    @Override
    public void doLayout(WidgetContainer container) {
        float resY;
        float resX;
        float top0;
        float left0;
        if (this.isWorking) {
            return;
        }
        this.isWorking = true;
        if (this.borderSource == null) {
            left0 = 0.0f;
            top0 = 0.0f;
            resX = container.getResX();
            resY = container.getResY();
        } else {
            left0 = this.borderSource.getBorderLeft();
            top0 = this.borderSource.getBorderTop();
            resX = container.getResX() - left0 - this.borderSource.getBorderRight();
            resY = container.getResY() - top0 - this.borderSource.getBorderBottom();
        }
        this.doLayout(left0, top0, resX, resY);
        this.isWorking = false;
    }

    public LayoutManagerBase() {
        this.borderSource = this instanceof BorderSettableLayoutManager ? (BorderSettableLayoutManager)((Object)this) : null;
    }
}

