/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.menusystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openmali.types.twodee.Dim2f;
import org.openmali.vecmath2.Colorf;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.menusystem.ButtonsLeftMenusCenterMenuGroupWidget;
import org.xith3d.ui.hud.menusystem.Menu;
import org.xith3d.ui.hud.menusystem.MenuGroupWidget;
import org.xith3d.ui.hud.menusystem.MenuSystem;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Button;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MenuGroup {
    private final String name;
    private MenuGroupWidget menuGroupWidget = null;
    private Menu currentActiveMenu = null;
    private boolean visible = false;
    private ArrayList<Object[]> earlyObjects = new ArrayList();
    private final ArrayList<Button> menuAccessors = new ArrayList();
    private final ArrayList<Menu> menus = new ArrayList();
    private final HashMap<String, Menu> menuMap = new HashMap();
    private final HashMap<Button, Menu> accessorMenuMap = new HashMap();
    private final HashMap<Menu, Button> menuAccessorMap = new HashMap();
    private MenuSystem menuSystem = null;
    private MenuGroup prevMenuGroup = null;
    private static long lastButtonClick = 0L;
    private final ButtonListener accessorListener = new ButtonListener(){

        public void onButtonClicked(AbstractButton button, Object userObject) {
            long t = System.currentTimeMillis();
            long dt = t - lastButtonClick;
            lastButtonClick = t;
            if (dt > 30L) {
                MenuGroup.this.getMenuSystem().onOtherMenuRequested(userObject);
            }
        }
    };

    public final String getName() {
        return this.name;
    }

    public final MenuSystem getMenuSystem() {
        return this.menuSystem;
    }

    public void setPreviousMenuGroup(MenuGroup menuGroup) {
        if (menuGroup == null) {
            throw new IllegalArgumentException("the given MenuGroup must not be null");
        }
        if (menuGroup == this) {
            throw new IllegalArgumentException("the given MenuGroup must be a different one than this");
        }
        this.prevMenuGroup = menuGroup;
    }

    public MenuGroup getPreviousMenuGroup() {
        return this.prevMenuGroup;
    }

    public void fireOnSettingChanged(Menu menu, String setting, Object value) {
        Button saveButton;
        if (this.getMenuSystem() != null) {
            this.getMenuSystem().fireOnSettingChanged(menu, setting, value);
        }
        if (this.getMenuGroupWidget() instanceof ButtonsLeftMenusCenterMenuGroupWidget && (saveButton = ((ButtonsLeftMenusCenterMenuGroupWidget)this.getMenuGroupWidget()).getSaveButton()) != null) {
            saveButton.setVisible(true);
        }
    }

    public boolean fireOnMenuActionPerformed(String action) {
        if (this.getCurrentActiveMenu() == null) {
            if (this.getMenuSystem() != null) {
                this.getMenuSystem().fireOnMenuActionPerformed(this, this.getCurrentActiveMenu(), action);
                return true;
            }
        } else if (this.getCurrentActiveMenu().prepareAction(action) && this.getMenuSystem() != null && this.getMenuSystem().fireOnMenuActionPerformed(this, this.getCurrentActiveMenu(), action)) {
            return this.getCurrentActiveMenu().onActionConsumed(action);
        }
        return false;
    }

    public void setCurrentActiveMenu(Menu menu) {
        if (this.currentActiveMenu != menu) {
            if (this.currentActiveMenu != null) {
                this.menuGroupWidget.setMenuVisible(this.currentActiveMenu, false);
            }
            this.menuGroupWidget.setMenuVisible(menu, true);
            if (menu != null) {
                ((Widget)((Object)menu)).requestFocus();
            }
            if (this.menuGroupWidget.getMenuPanel().getLayout() != null) {
                this.menuGroupWidget.getMenuPanel().getLayout().doLayout(this.menuGroupWidget.getMenuPanel());
            }
        }
        this.currentActiveMenu = menu;
    }

    public final Menu getCurrentActiveMenu() {
        return this.currentActiveMenu;
    }

    public final MenuGroupWidget getMenuGroupWidget() {
        return this.menuGroupWidget;
    }

    protected Button addMenuImpl(String accessorCaption, String caption, Menu menu) {
        Button accessor = this.menuGroupWidget.addAccessorWidget(accessorCaption, this.getMenuSystem().getAccessorDescription());
        this.menuGroupWidget.addMenu(this.getMenuSystem(), caption, menu);
        accessor.setUserObject(menu);
        accessor.addButtonListener(this.accessorListener);
        if (this.getMenusCount() == 1) {
            this.currentActiveMenu = this.getMenu(0);
        }
        return accessor;
    }

    public final void addMenu(String accessorCaption, String caption, Menu menu) {
        if (!(menu instanceof Widget)) {
            throw new IllegalArgumentException("A Menu must be an instance if Widget.");
        }
        this.menus.add(menu);
        this.menuMap.put(menu.getName(), menu);
        menu.setMenuGroup(this);
        if (this.menuGroupWidget == null) {
            this.earlyObjects.add(new Object[]{accessorCaption, caption, menu});
            return;
        }
        Button accessor = this.addMenuImpl(accessorCaption, caption, menu);
        if (accessor != null) {
            this.menuAccessors.add(accessor);
            this.accessorMenuMap.put(accessor, menu);
            this.menuAccessorMap.put(menu, accessor);
        }
        menu.setMenuSystem(this.menuSystem);
    }

    public void addActionButton(String caption, Object target) {
        if (this.menuGroupWidget == null) {
            this.earlyObjects.add(new Object[]{caption, target});
            return;
        }
        Button button = this.menuGroupWidget.addAccessorWidget(caption, this.getMenuSystem().getAccessorDescription());
        button.setUserObject(target);
        button.addButtonListener(this.accessorListener);
    }

    public final List<Menu> getMenus() {
        return this.menus;
    }

    public final Menu getMenu(int index) {
        return this.menus.get(index);
    }

    public final Menu getMenu(String name) {
        return this.menuMap.get(name);
    }

    public final int getMenusCount() {
        return this.menus.size();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.menuGroupWidget != null) {
            this.menuGroupWidget.setVisible(visible);
            this.menuGroupWidget.getAccessorPanel().requestFocus();
        }
    }

    public final boolean isVisible() {
        return this.visible;
    }

    protected abstract MenuGroupWidget createMenuSystemWidget(float var1, float var2, float var3, float var4);

    protected void initMenus(Button.Description accessorDesc, Colorf menuBGColor, Colorf menuBorderColor, HUDFont menuCaptionFont, Colorf menuFontColor) {
    }

    protected void init(MenuSystem menuSystem) {
        this.menuSystem = menuSystem;
        Dim2f size = Dim2f.fromPool();
        menuSystem.getHUD().getCoordinatesConverter().getSizePixels2HUD((int)menuSystem.getWidth(), (int)menuSystem.getHeight(), size);
        this.menuGroupWidget = this.createMenuSystemWidget(size.getWidth(), size.getHeight(), menuSystem.getWidth(), menuSystem.getHeight());
        this.menuGroupWidget.setZIndex(menuSystem.getMenuZIndex());
        Dim2f.toPool((Dim2f)size);
        this.menuGroupWidget.setVisible(this.isVisible());
        this.menuGroupWidget.setMenuGroup(this);
        menuSystem.getContainer().addWidgetCentered(this.menuGroupWidget);
        this.menus.clear();
        for (int i = 0; i < this.earlyObjects.size(); ++i) {
            Object[] eo = this.earlyObjects.get(i);
            if (eo.length == 3) {
                this.addMenu((String)eo[0], (String)eo[1], (Menu)eo[2]);
                continue;
            }
            if (eo.length != 2) continue;
            this.addActionButton((String)eo[0], eo[1]);
        }
        this.earlyObjects = null;
        this.initMenus(menuSystem.getAccessorDescription(), menuSystem.getMenuBackgroundColor(), menuSystem.getMenuBorderColor(), menuSystem.getMenuCaptionFont(), menuSystem.getMenuCaptionFontColor());
    }

    public MenuGroup(String name, MenuGroup previousMenuGroup) {
        this.name = name;
        if (previousMenuGroup != null) {
            this.setPreviousMenuGroup(previousMenuGroup);
        }
    }

    public MenuGroup(String name) {
        this(name, null);
    }
}

