/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import org.openmali.vecmath2.Point2i;
import org.openmali.vecmath2.Tuple2i;
import org.openmali.vecmath2.TupleNi;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.ui.hud.utils.HUDTextureUtils;

public class Cursor {
    private Texture2D texture;
    private final Point2i zeroPoint = new Point2i(0, 0);

    public final void setTexture(Texture2D texture) {
        if (texture == null) {
            throw new IllegalArgumentException("texture must not be null");
        }
        this.texture = texture;
    }

    public final void setTexture(String texture) {
        if (texture == null) {
            this.setTexture((Texture2D)null);
        }
        this.setTexture(HUDTextureUtils.getTexture(texture, true));
    }

    public final Texture2D getTexture() {
        return this.texture;
    }

    public final void setZeroPoint(int zeroPointX, int zeroPointY) {
        this.zeroPoint.set(zeroPointX, zeroPointY);
    }

    public final void setZeroPoint(Tuple2i zeroPoint) {
        this.zeroPoint.set((TupleNi)zeroPoint);
    }

    public final Point2i getZeroPoint() {
        return this.zeroPoint.getReadOnly();
    }

    public final int getZeroPointX() {
        return this.zeroPoint.getX();
    }

    public final int getZeroPointY() {
        return this.zeroPoint.getY();
    }

    public Cursor(Texture2D texture, int zeroX, int zeroY) {
        if (texture == null) {
            throw new IllegalArgumentException("texture must not be null");
        }
        this.texture = texture;
        this.zeroPoint.set(zeroX, zeroY);
    }

    public Cursor(Texture2D texture, Tuple2i zeroPoint) {
        if (texture == null) {
            throw new IllegalArgumentException("texture must not be null");
        }
        this.texture = texture;
        if (zeroPoint != null) {
            this.zeroPoint.set((TupleNi)zeroPoint);
        }
    }

    public Cursor(Texture2D texture) {
        this(texture, null);
    }

    public Cursor(String texture, int zeroX, int zeroY) {
        if (texture == null) {
            throw new IllegalArgumentException("texture must not be null");
        }
        this.setTexture(texture);
        this.zeroPoint.set(zeroX, zeroY);
    }

    public Cursor(String texture, Tuple2i zeroPoint) {
        if (texture == null) {
            throw new IllegalArgumentException("texture must not be null");
        }
        this.setTexture(texture);
        if (zeroPoint != null) {
            this.zeroPoint.set((TupleNi)zeroPoint);
        }
    }

    public Cursor(String texture) {
        this(texture, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INHERIT,
        POINTER1,
        POINTER2,
        CROSSHAIR,
        TEXT,
        WAIT,
        HELP;

    }
}

