/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import org.xith3d.ui.hud.utils.Cursor;

public class CursorSet {
    private Cursor pointer1 = null;
    private Cursor pointer2 = null;
    private Cursor crosshair = null;
    private Cursor text = null;
    private Cursor wait = null;
    private Cursor help = null;

    public final void set(Cursor.Type type, Cursor cursor) {
        switch (type) {
            case POINTER1: {
                this.pointer1 = cursor;
                break;
            }
            case POINTER2: {
                this.pointer2 = cursor;
                break;
            }
            case CROSSHAIR: {
                this.crosshair = cursor;
                break;
            }
            case TEXT: {
                this.text = cursor;
                break;
            }
            case WAIT: {
                this.wait = cursor;
                break;
            }
            case HELP: {
                this.help = cursor;
                break;
            }
            default: {
                throw new IllegalArgumentException("This method is not applicable for the Cursor type " + (Object)((Object)type));
            }
        }
    }

    public final Cursor get(Cursor.Type cursorType) {
        if (cursorType == null) {
            return null;
        }
        switch (cursorType) {
            case POINTER1: {
                return this.pointer1;
            }
            case POINTER2: {
                return this.pointer2;
            }
            case CROSSHAIR: {
                return this.crosshair;
            }
            case TEXT: {
                return this.text;
            }
            case WAIT: {
                return this.wait;
            }
            case HELP: {
                return this.help;
            }
        }
        throw new IllegalArgumentException("This method is not applicable for the Cursor type " + (Object)((Object)cursorType));
    }

    public final void setPointer1(Cursor cursor) {
        this.set(Cursor.Type.POINTER1, cursor);
    }

    public final Cursor getPointer1() {
        return this.get(Cursor.Type.POINTER1);
    }

    public final void setPointer2(Cursor cursor) {
        this.set(Cursor.Type.POINTER2, cursor);
    }

    public final Cursor getPointer2() {
        return this.get(Cursor.Type.POINTER2);
    }

    public final void setCrosshair(Cursor cursor) {
        this.set(Cursor.Type.CROSSHAIR, cursor);
    }

    public final Cursor getCrosshair() {
        return this.get(Cursor.Type.CROSSHAIR);
    }

    public final void setTextCursor(Cursor cursor) {
        this.set(Cursor.Type.TEXT, cursor);
    }

    public final Cursor getTextCursor() {
        return this.get(Cursor.Type.TEXT);
    }

    public final void setWaitCursor(Cursor cursor) {
        this.set(Cursor.Type.WAIT, cursor);
    }

    public final Cursor getWaitCursor() {
        return this.get(Cursor.Type.WAIT);
    }

    public final void setHelpCursor(Cursor cursor) {
        this.set(Cursor.Type.HELP, cursor);
    }

    public final Cursor getHelpCursor() {
        return this.get(Cursor.Type.HELP);
    }

    public void set(CursorSet template) {
        this.pointer1 = template.pointer1;
        this.pointer2 = template.pointer2;
        this.crosshair = template.crosshair;
        this.text = template.text;
        this.wait = template.wait;
        this.help = template.help;
    }

    public final CursorSet clone() {
        return new CursorSet(this);
    }

    public CursorSet(CursorSet template) {
        this.set(template);
    }

    public CursorSet() {
    }
}

