/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;

public class DrawUtils {
    public static void drawImage(Colorf color, Texture2D texture, TileMode tileMode, Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        TextureImage2D image = texCanvas.getTexture().getImage0();
        if (color != null) {
            image.fillRectangle(color, offsetX, offsetY, width, height, true, null);
        }
        if (texture != null) {
            TextureImage2D img = texture.getImage0();
            if (tileMode != null) {
                int imgWidth = HUDTextureUtils.getTextureWidth(texture);
                int imgHeight = HUDTextureUtils.getTextureHeight(texture);
                switch (tileMode) {
                    case STRETCH: {
                        if (width == imgWidth && height == imgHeight) {
                            image.drawImage(img, offsetX, offsetY, true, null);
                            break;
                        }
                        texCanvas.drawImage(img.getBufferedImage(), offsetX, offsetY + height - 1, offsetX + width - 1, offsetY, 0, 0, imgWidth, imgHeight);
                        break;
                    }
                    case TILE_X: {
                        image.drawImage(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, width, imgHeight, true, null);
                        break;
                    }
                    case TILE_Y: {
                        image.drawImage(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, imgWidth, height, true, null);
                        break;
                    }
                    case TILE_BOTH: {
                        image.drawImage(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, width, height, true, null);
                    }
                }
            } else {
                image.drawImage(img, offsetX, offsetY, true, null);
            }
        }
    }

    public static void clearImage(Colorf color, Texture2D texture, TileMode tileMode, Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        TextureImage2D image = texCanvas.getTexture().getImage0();
        if (color != null) {
            image.clear(color, offsetX, offsetY, width, height, true, null);
        }
        if (texture != null) {
            TextureImage2D img = texture.getImage0();
            if (tileMode != null) {
                int imgWidth = HUDTextureUtils.getTextureWidth(texture);
                int imgHeight = HUDTextureUtils.getTextureHeight(texture);
                switch (tileMode) {
                    case STRETCH: {
                        if (width == imgWidth && height == imgHeight) {
                            image.clear(img, offsetX, offsetY, true, null);
                            break;
                        }
                        image.clear(offsetX, offsetY, width, height, true, null);
                        texCanvas.drawImage(img.getBufferedImage(), offsetX, offsetY + height, offsetX + width, offsetY, 0, 0, imgWidth, imgHeight);
                        break;
                    }
                    case TILE_X: {
                        image.clear(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, width, imgHeight, true, null);
                        break;
                    }
                    case TILE_Y: {
                        image.clear(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, imgWidth, height, true, null);
                        break;
                    }
                    case TILE_BOTH: {
                        image.clear(img, 0, 0, imgWidth, imgHeight, offsetX, offsetY, width, height, true, null);
                    }
                }
            } else {
                image.clear(img, offsetX, offsetY, true, null);
            }
        }
    }
}

