/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.TupleNf;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.utils.Cursor;
import org.xith3d.ui.hud.utils.HUDPickResultPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HUDPickResult
implements Comparable<HUDPickResult> {
    public static final int HUD_PICK_FLAG_IS_INTERNAL = 1;
    public static final int HUD_PICK_FLAG_EVENTS_SUPPRESSED = 2;
    public static final int HUD_PICK_FLAG_JUST_TEST_AND_DO_NOTHING = 4096;
    private static final HUDPickResultPool POOL = new HUDPickResultPool(128);
    private HUDPickReason pickReason = null;
    private MouseButton button = null;
    private Widget widget = null;
    private Tuple2f absPos = new Point2f();
    private Tuple2f relPos = new Point2f();
    private HUDPickResult subResult = null;
    private Cursor.Type inheritedCursorType = null;

    public final Widget getWidget() {
        return this.widget;
    }

    public final Tuple2f getAbsPos() {
        return this.absPos;
    }

    public final Tuple2f getRelPos() {
        return this.relPos;
    }

    public final HUDPickReason getPickReason() {
        return this.pickReason;
    }

    public final MouseButton getButton() {
        return this.button;
    }

    @Override
    public int compareTo(HUDPickResult hpr2) {
        return this.widget.compareAbsZIndex(hpr2.widget);
    }

    public void setSubResult(HUDPickResult subResult) {
        if (subResult == this) {
            throw new Error("A HUDPickResult cannot be set to itself as a sub-result!");
        }
        this.subResult = subResult;
        this.inheritedCursorType = subResult != null ? subResult.getInheritedCursorType() : null;
    }

    public HUDPickResult getSubResult() {
        return this.subResult;
    }

    public HUDPickResult getLeafResult() {
        HUDPickResult pr = this;
        while (pr.getSubResult() != null) {
            pr = pr.getSubResult();
        }
        return pr;
    }

    public boolean isLeafResult() {
        return this.subResult == null;
    }

    public final Cursor.Type getInheritedCursorType() {
        return this.inheritedCursorType;
    }

    public String toString() {
        return this.getClass().getName() + ": Widget(" + this.getWidget() + "), abs(" + this.absPos.getX() + ", " + this.absPos.getY() + "), rel(" + this.relPos.getX() + ", " + this.relPos.getY() + "), caused by " + (Object)((Object)this.pickReason) + ", subResult(" + (this.getSubResult() != null ? "yes)" : "no)");
    }

    public HUDPickResult set(Widget widget, Cursor.Type cursor, float absPosX, float absPosY, float relPosX, float relPosY, HUDPickReason pickReason, MouseButton button) {
        this.widget = widget;
        this.inheritedCursorType = cursor;
        this.absPos.set(absPosX, absPosY);
        this.relPos.set(relPosX, relPosY);
        this.pickReason = pickReason;
        this.button = button;
        this.subResult = null;
        return this;
    }

    public HUDPickResult(Widget widget, Cursor.Type cursor, Tuple2f absPos, float relPosX, float relPosY, HUDPickReason pickReason, MouseButton button) {
        this.widget = widget;
        this.absPos.set((TupleNf)absPos);
        this.relPos.set((TupleNf)this.relPos);
        this.pickReason = pickReason;
        this.button = button;
        this.subResult = null;
    }

    public HUDPickResult() {
    }

    public static final HUDPickResult fromPool() {
        return POOL.alloc();
    }

    public static final void toPool(HUDPickResult hpr) {
        HUDPickResult subResult = hpr.getSubResult();
        if (subResult != null) {
            hpr.setSubResult(null);
            HUDPickResult.toPool(subResult);
        }
        POOL.free(hpr);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HUDPickReason {
        BUTTON_PRESSED(1),
        BUTTON_RELEASED(2),
        MOUSE_MOVED(4),
        MOUSE_STOPPED(8),
        MOUSE_WHEEL_MOVED_UP(16),
        MOUSE_WHEEL_MOVED_DOWN(16);

        public static final int BUTTON_PRESSED_MASK;
        public static final int BUTTON_RELEASED_MASK;
        public static final int MOUSE_MOVED_MASK;
        public static final int MOUSE_STOPPED_MASK;
        public static final int MOUSE_WHEEL_MOVED_MASK;
        private final int maskValue;

        public final int getMaskValue() {
            return this.maskValue;
        }

        private HUDPickReason(int maskValue) {
            this.maskValue = maskValue;
        }

        static {
            BUTTON_PRESSED_MASK = BUTTON_PRESSED.getMaskValue();
            BUTTON_RELEASED_MASK = BUTTON_RELEASED.getMaskValue();
            MOUSE_MOVED_MASK = MOUSE_MOVED.getMaskValue();
            MOUSE_STOPPED_MASK = MOUSE_STOPPED.getMaskValue();
            MOUSE_WHEEL_MOVED_MASK = MOUSE_WHEEL_MOVED_UP.getMaskValue() | MOUSE_WHEEL_MOVED_DOWN.getMaskValue();
        }
    }
}

