/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.text2d.TextAlignment;

public class MultilineText {
    private String text = null;
    private String[] lines = new String[0];
    private int numLines = 0;
    private Rectangle2D[] bounds = null;
    private int offset_y = 0;
    private int totalWidth = 0;
    private int totalHeight = 0;
    private int min_pos_x = 0;
    private int[] pos_x = null;
    private int[] pos_y = null;
    private int dirty = -1;

    public final int getNumLines() {
        return this.numLines;
    }

    public final String getLine(int index) {
        return this.lines[index];
    }

    public final int getMinPosX() {
        return this.min_pos_x;
    }

    public final int getPosX(int lineIndex) {
        return this.pos_x[lineIndex];
    }

    public final int getPosY(int lineIndex) {
        return this.pos_y[lineIndex];
    }

    public final int getLineOffsetY(int lineIndex) {
        return (int)this.bounds[lineIndex].getY();
    }

    public final int getWidth(int lineIndex) {
        return (int)this.bounds[lineIndex].getWidth();
    }

    public final int getHeight(int lineIndex) {
        return (int)this.bounds[lineIndex].getHeight();
    }

    public final int getTotalWidth() {
        return this.totalWidth;
    }

    public final int getTotalHeight() {
        return this.totalHeight;
    }

    public final int getOffsetY() {
        return this.offset_y;
    }

    private static final String getLine(String text, int fromIdx, int toIdx) {
        if (toIdx - fromIdx >= 1 && text.charAt(fromIdx) == '\r') {
            if (toIdx - fromIdx >= 2 && text.charAt(toIdx - 1) == '\r') {
                return text.substring(fromIdx + 1, toIdx - 1);
            }
            return text.substring(fromIdx + 1, toIdx);
        }
        if (toIdx - fromIdx >= 2 && text.charAt(toIdx - 1) == '\r') {
            return text.substring(fromIdx, toIdx - 1);
        }
        if (fromIdx == 0 && toIdx == text.length()) {
            return text;
        }
        return text.substring(fromIdx, toIdx);
    }

    private int splitText() {
        int newNumLines = 0;
        int off = 0;
        int idx = this.text.indexOf(10, off);
        if (idx < 0) {
            if (this.lines.length < 1) {
                this.lines = new String[1];
            }
            this.lines[0] = MultilineText.getLine(this.text, 0, this.text.length());
            newNumLines = 1;
        } else {
            do {
                if (idx < 0) {
                    idx = this.text.length();
                }
                if (this.lines.length < newNumLines + 1) {
                    String[] tmp = new String[this.lines.length + 1];
                    System.arraycopy(this.lines, 0, tmp, 0, this.lines.length);
                    this.lines = tmp;
                }
                this.lines[newNumLines++] = MultilineText.getLine(this.text, off, idx);
            } while ((idx = this.text.indexOf(10, off = idx + 1)) >= 0 || off < this.text.length() - 1);
        }
        for (int i = newNumLines; i < this.numLines; ++i) {
            this.lines[i] = null;
            this.bounds[i] = null;
        }
        this.numLines = newNumLines;
        return this.numLines;
    }

    public void setText(String text) {
        this.text = text;
        this.splitText();
        this.dirty = -1;
    }

    public void setPositionDirty() {
        this.dirty |= 2;
    }

    public void update(Texture2DCanvas texCanvas, int width, int height, int paddingLeft, int paddingRight, int paddingTop, int paddingBottom, TextAlignment alignment) {
        int i;
        if (this.dirty == 0) {
            return;
        }
        if ((this.dirty & 1) != 0) {
            FontMetrics metrics = texCanvas.getFontMetrics();
            if (this.numLines == 0) {
                this.min_pos_x = 0;
                this.totalWidth = 0;
                this.totalHeight = 0;
                this.offset_y = 0;
            } else {
                if (this.bounds == null || this.bounds.length < this.numLines) {
                    this.bounds = new Rectangle2D[this.numLines];
                }
                this.totalHeight = 0;
                for (i = 0; i < this.numLines; ++i) {
                    this.bounds[i] = metrics.getStringBounds(this.lines[i], texCanvas);
                    this.totalHeight = (int)((double)this.totalHeight + this.bounds[i].getHeight());
                }
                this.offset_y = (int)this.bounds[0].getY();
            }
            if (this.pos_x == null || this.pos_x.length < this.numLines) {
                this.pos_x = new int[this.numLines];
            }
            if (this.pos_y == null || this.pos_y.length < this.numLines) {
                this.pos_y = new int[this.numLines];
            }
            this.dirty |= 2;
        }
        if ((this.dirty & 2) != 0) {
            int y = paddingTop - this.offset_y;
            if (alignment.isVCenterAligned()) {
                y += (int)((double)(height - paddingTop - paddingBottom - this.totalHeight) / 2.0);
            } else if (alignment.isBottomAligned()) {
                y += height - paddingTop - paddingBottom - this.totalHeight;
            }
            for (i = 0; i < this.numLines; ++i) {
                this.pos_x[i] = paddingLeft;
                if (alignment.isHCenterAligned()) {
                    int n = i;
                    this.pos_x[n] = this.pos_x[n] + (int)(((double)(width - paddingLeft - paddingRight) - this.bounds[i].getWidth()) / 2.0);
                } else if (alignment.isRightAligned()) {
                    int n = i;
                    this.pos_x[n] = this.pos_x[n] + (int)((double)(width - paddingLeft - paddingRight) - this.bounds[i].getWidth());
                }
                this.pos_y[i] = y;
                y = (int)((double)y + this.bounds[i].getHeight());
            }
        }
        if ((this.dirty & 3) != 0) {
            if (this.numLines == 0) {
                this.min_pos_x = 0;
                this.totalWidth = 0;
            } else {
                this.min_pos_x = Integer.MAX_VALUE;
                this.totalWidth = 0;
                for (int i2 = 0; i2 < this.numLines; ++i2) {
                    this.min_pos_x = Math.min(this.min_pos_x, this.pos_x[i2]);
                    this.totalWidth = Math.max(this.totalWidth, this.pos_x[i2] + (int)this.bounds[i2].getWidth());
                }
                this.totalWidth -= this.min_pos_x;
            }
        }
        this.dirty = 0;
    }
}

