/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import org.xith3d.loop.FPSListener;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;

public class FPSCounter
extends Label
implements FPSListener {
    private char decimalSep = (char)46;
    private float lastFPS = -1.0f;
    private String prefix = null;
    private String postfix = null;

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.setText(prefix, this.lastFPS, this.decimalSep, 2, this.postfix);
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
        this.setText(this.prefix, this.lastFPS, this.decimalSep, 2, postfix);
    }

    public final String getPostfix() {
        return this.postfix;
    }

    public void setDecimalSeparator(char decSep) {
        this.decimalSep = decSep;
        this.setText(this.prefix, this.lastFPS, this.decimalSep, 2, this.postfix);
    }

    public final char getDecimalSeparator() {
        return this.decimalSep;
    }

    public final float getLastFPS() {
        return this.lastFPS;
    }

    public void onFPSCountIntervalHit(float fps) {
        this.lastFPS = fps;
        this.setText(this.prefix, this.lastFPS, this.decimalSep, 2, this.postfix);
    }

    public FPSCounter(boolean isHeavyWeight, float width, float height, Texture2D backgroundTexture) {
        super(isHeavyWeight, width, height, "", null, null, TextAlignment.CENTER_CENTER);
        this.setBackgroundTexture(backgroundTexture);
    }

    public FPSCounter(boolean isHeavyWeight, float width, float height, String backgroundTexture) {
        this(isHeavyWeight, width, height, HUDTextureUtils.getTexture(backgroundTexture, true));
    }

    public FPSCounter(boolean isHeavyWeight, float width, float height) {
        this(isHeavyWeight, width, height, (Texture2D)null);
    }

    public FPSCounter(float width, float height, Texture2D backgroundTexture) {
        this(false, width, height);
    }

    public FPSCounter(float width, float height, String backgroundTexture) {
        this(false, width, height, backgroundTexture);
    }

    public FPSCounter(float width, float height) {
        this(false, width, height);
    }
}

