/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.utils.DrawUtils;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.hud.widgets.ScrollPanel;

public class Panel
extends WidgetContainer {
    protected static final boolean DEFAULT_HEAVYWEIGHT = false;
    private Texture2D foregroundImage = null;

    public void setForegroundTexture(Texture2D texture) {
        this.foregroundImage = texture;
    }

    public final void setForegroundTexture(String texture) {
        this.setForegroundTexture(HUDTextureUtils.getTexture(texture, true));
    }

    public final Texture2D getForegroundTexture() {
        return this.foregroundImage;
    }

    protected void drawForeground(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height) {
        if (this.getForegroundTexture() == null) {
            return;
        }
        DrawUtils.drawImage(null, this.getForegroundTexture(), TileMode.STRETCH, texCanvas, offsetX, offsetY, width, height);
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        super.drawWidget(texCanvas, offsetX, offsetY, width, height, drawsSelf);
        this.drawForeground(texCanvas, offsetX, offsetY, width, height);
    }

    protected void init() {
    }

    protected Panel(boolean isHeavyWeight, boolean hasWidgetAssembler, float width, float height, Colorf backgroundColor, Texture2D backgroundTex, TileMode backgroundTileMode) {
        super(isHeavyWeight, hasWidgetAssembler, width, height, backgroundColor, backgroundTex, backgroundTileMode);
    }

    public Panel(boolean isHeavyWeight, float width, float height, Colorf backgroundColor, Texture2D backgroundTex, TileMode backgroundTileMode) {
        this(isHeavyWeight, false, width, height, backgroundColor, backgroundTex, backgroundTileMode);
    }

    public Panel(boolean isHeavyWeight, float width, float height, Colorf backgroundColor, Texture2D backgroundTex) {
        this(isHeavyWeight, width, height, backgroundColor, backgroundTex, TileMode.TILE_BOTH);
    }

    public Panel(boolean isHeavyWeight, float width, float height, Colorf backgroundColor) {
        this(isHeavyWeight, width, height, backgroundColor, (Texture2D)null);
    }

    public Panel(boolean isHeavyWeight, float width, float height, Texture2D backgroundTex) {
        this(isHeavyWeight, width, height, null, backgroundTex);
    }

    public Panel(boolean isHeavyWeight, float width, float height, String backgroundTex) {
        this(isHeavyWeight, width, height, null, HUDTextureUtils.getTexture(backgroundTex, true));
    }

    public Panel(boolean isHeavyWeight, float width, float height) {
        this(isHeavyWeight, width, height, null, (Texture2D)null);
    }

    public Panel(float width, float height, Colorf backgroundColor, Texture2D backgroundTex) {
        this(false, width, height, backgroundColor, backgroundTex);
    }

    public Panel(float width, float height, Colorf backgroundColor, String backgroundTex) {
        this(false, width, height, backgroundColor, HUDTextureUtils.getTexture(backgroundTex, true));
    }

    public Panel(float width, float height, Colorf backgroundColor) {
        this(false, width, height, backgroundColor, (Texture2D)null);
    }

    public Panel(float width, float height, Texture2D backgroundTex) {
        this(false, width, height, null, backgroundTex);
    }

    public Panel(float width, float height, String backgroundTex) {
        this(false, width, height, null, HUDTextureUtils.getTexture(backgroundTex, true));
    }

    public Panel(float width, float height) {
        this(false, width, height, null, (Texture2D)null);
    }

    public static final Panel createContentPane(float width, float height, boolean scrollable) {
        if (scrollable) {
            return new ScrollPanel(false, width, height, HUD.getTheme().getContentPaneBackgroundColor(), HUD.getTheme().getContentPaneBackgroundTexture(), TileMode.TILE_BOTH);
        }
        return new Panel(false, width, height, HUD.getTheme().getContentPaneBackgroundColor(), HUD.getTheme().getContentPaneBackgroundTexture(), TileMode.TILE_BOTH);
    }

    public static Panel createContentPane(float width, float height) {
        return Panel.createContentPane(width, height, false);
    }
}

