/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import java.util.ArrayList;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listeners.QuadDividerListener;
import org.xith3d.ui.hud.listeners.WidgetLocationListener;
import org.xith3d.ui.hud.utils.HUDPickResult;
import org.xith3d.ui.hud.widgets.Image;

public class QuadDivider
extends Widget {
    public static final float DIVIDER_WIDTH = 10.0f;
    private Colorf earlyDivColor;
    private float earlyVertDivLeft = -1.0f;
    private float earlyHorizDivTop = -1.0f;
    private Image horizontalDivider;
    private Image verticalDivider;
    private EventEngine eventEngine = new EventEngine();
    private float leftWidth = -1.0f;
    private float rightWidth = -1.0f;
    private float topHeight = -1.0f;
    private float bottomHeight = -1.0f;
    private float rightLeft = -1.0f;
    private float bottomTop = -1.0f;
    private final ArrayList<QuadDividerListener> listeners = new ArrayList(1);

    protected void updatePanelSizes() {
        float vertDivLeft;
        float horizDivTop;
        if (this.isInitialized()) {
            horizDivTop = this.horizontalDivider.getTop();
            vertDivLeft = this.verticalDivider.getLeft();
        } else {
            horizDivTop = this.earlyHorizDivTop < 0.0f ? this.getHeight() / 2.0f - 5.0f : this.earlyHorizDivTop;
            vertDivLeft = this.earlyVertDivLeft < 0.0f ? this.getWidth() / 2.0f - 5.0f : this.earlyVertDivLeft;
        }
        this.leftWidth = vertDivLeft;
        this.rightWidth = this.getWidth() - (vertDivLeft + 10.0f);
        this.topHeight = horizDivTop;
        this.bottomHeight = this.getHeight() - (horizDivTop + 10.0f);
        this.rightLeft = vertDivLeft + 10.0f;
        this.bottomTop = horizDivTop + 10.0f;
    }

    public void setDividerColor(Colorf color) {
        if (this.isInitialized()) {
            this.horizontalDivider.setColor(color);
            this.verticalDivider.setColor(color);
        } else {
            this.earlyDivColor = color;
        }
    }

    public void setVerticalDividerLeft(float vertLeft) {
        if (!this.isInitialized()) {
            this.earlyVertDivLeft = vertLeft;
        } else {
            this.verticalDivider.setLocation(vertLeft, 0.0f);
        }
        this.updatePanelSizes();
    }

    public void setHorizontalDividerTop(float horizTop) {
        if (!this.isInitialized()) {
            this.earlyHorizDivTop = horizTop;
        } else {
            this.horizontalDivider.setLocation(0.0f, horizTop);
        }
        this.updatePanelSizes();
    }

    public final float getLeftWidth() {
        return this.leftWidth;
    }

    public final float getRightWidth() {
        return this.rightWidth;
    }

    public final float getTopHeight() {
        return this.topHeight;
    }

    public final float getBottomHeight() {
        return this.bottomHeight;
    }

    public final float getRightLeft() {
        return this.rightLeft;
    }

    public final float getBottomTop() {
        return this.bottomTop;
    }

    public QuadPanels getPanelUnderMouse(int canvasX, int canvasY) {
        if (this.getHUD() == null) {
            return null;
        }
        Point2f p = Point2f.fromPool();
        this.getLocationPixels2HUD_(canvasX, canvasY, p);
        QuadPanels qp = null;
        if (p.getX() >= 0.0f && p.getX() <= this.getLeftWidth()) {
            if (p.getY() >= 0.0f && p.getY() <= this.getTopHeight()) {
                qp = QuadPanels.UPPER_LEFT;
            } else if (p.getY() >= this.getBottomTop() && p.getY() <= this.getHeight()) {
                qp = QuadPanels.LOWER_LEFT;
            }
        } else if (p.getX() >= this.getRightLeft() && p.getX() <= this.getWidth()) {
            if (p.getY() >= 0.0f && p.getY() <= this.getTopHeight()) {
                qp = QuadPanels.UPPER_RIGHT;
            } else if (p.getY() >= this.getBottomTop() && p.getY() <= this.getHeight()) {
                qp = QuadPanels.LOWER_RIGHT;
            }
        }
        Point2f.toPool((Point2f)p);
        return qp;
    }

    public void addQuadDividerListener(QuadDividerListener l) {
        this.listeners.add(l);
    }

    public void removeQuadDividerListener(QuadDividerListener l) {
        this.listeners.remove(l);
    }

    public HUDPickResult pick(int canvasX, int canvasY, HUDPickResult.HUDPickReason pickReason, MouseButton button, long when, long meta, int flags) {
        Tuple2f locP = Tuple2f.fromPool();
        this.getLocationPixels2HUD_(canvasX, canvasY, locP);
        float pickXHUD = locP.getX();
        float pickYHUD = locP.getY();
        Tuple2f.toPool((Tuple2f)locP);
        this.getWidgetAssembler().pick(canvasX, canvasY, pickXHUD, pickYHUD, pickReason, button, when, meta, flags);
        return null;
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        texCanvas.getImage().clear(true, null);
    }

    protected void init() {
        this.horizontalDivider = new Image(this.getWidth(), 10.0f, this.earlyDivColor);
        this.verticalDivider = new Image(10.0f, this.getHeight(), this.earlyDivColor);
        this.earlyDivColor = null;
        this.horizontalDivider.setDraggable(true);
        this.verticalDivider.setDraggable(true);
        this.horizontalDivider.addLocationListener(this.eventEngine);
        this.verticalDivider.addLocationListener(this.eventEngine);
        if (this.earlyHorizDivTop < 0.0f) {
            this.earlyHorizDivTop = this.getHeight() / 2.0f - 5.0f;
        }
        if (this.earlyVertDivLeft < 0.0f) {
            this.earlyVertDivLeft = this.getWidth() / 2.0f - 5.0f;
        }
        this.getWidgetAssembler().addWidget(this.horizontalDivider, 0.0f, this.earlyHorizDivTop);
        this.getWidgetAssembler().addWidget(this.verticalDivider, this.earlyVertDivLeft, 0.0f);
        this.updatePanelSizes();
    }

    public QuadDivider(float width, float height, Colorf dividerColor) {
        super(true, true, width, height);
        this.setFocussable(false);
        this.earlyDivColor = dividerColor;
        this.updatePanelSizes();
    }

    public QuadDivider(float width, float height) {
        this(width, height, Colorf.PINK);
    }

    private class EventEngine
    extends ScheduledOperationImpl
    implements WidgetLocationListener {
        private boolean eventBlocked;

        public void onWidgetDragStarted(Widget widget) {
        }

        public void onWidgetDragStopped(Widget widget) {
        }

        public void onWidgetLocationChanged(Widget widget, float oldLeft, float oldTop, float newLeft, float newTop) {
            if (this.eventBlocked) {
                return;
            }
            this.eventBlocked = true;
            if (widget == QuadDivider.this.horizontalDivider && widget.getLeft() != 0.0f) {
                widget.setLocation(0.0f, widget.getTop());
            }
            if (widget == QuadDivider.this.verticalDivider && widget.getTop() != 0.0f) {
                widget.setLocation(widget.getLeft(), 0.0f);
            }
            this.eventBlocked = false;
            HUD hud = QuadDivider.this.getHUD();
            if (hud != null) {
                hud.getOperationScheduler().scheduleOperation(this);
            }
        }

        public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
            QuadDivider.this.updatePanelSizes();
            for (int i = 0; i < QuadDivider.this.listeners.size(); ++i) {
                ((QuadDividerListener)QuadDivider.this.listeners.get(i)).onDividerResized(QuadDivider.this, QuadDivider.this.leftWidth, QuadDivider.this.rightWidth, QuadDivider.this.topHeight, QuadDivider.this.bottomHeight);
            }
        }

        public EventEngine() {
            super(false);
            this.eventBlocked = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QuadPanels {
        UPPER_LEFT,
        UPPER_RIGHT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }
}

