/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import java.util.ArrayList;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Dim2i;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.listeners.SliderListener;
import org.xith3d.ui.hud.utils.DrawUtils;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;

public class Slider
extends Widget {
    private int heightInPx;
    private Texture2D leftTex;
    private Texture2D rightTex;
    private Texture2D bodyTex;
    private Texture2D valueMarkTex;
    private Texture2D handleTex;
    private int handleYOffset;
    private int currentHandlePosPx = -1;
    private int forcedHandlePosPx = -1;
    private boolean isSliding = false;
    private float slideStartMousePos;
    private int slideStartHandlePos;
    private int minValue;
    private int maxValue;
    private int value;
    private boolean smoothSliding;
    private final ArrayList<SliderListener> sliderListeners = new ArrayList();

    public void setHandleYOffset(int yOffset) {
        this.handleYOffset = yOffset;
        this.setTextureDirty();
    }

    public final int getHandleYOffset() {
        return this.handleYOffset;
    }

    protected int getMousePosition(int currentHandlePosPx, int mouseX, int mouseY) {
        int halfHandleSize = HUDTextureUtils.getTextureWidth(this.handleTex) / 2;
        if (mouseX < currentHandlePosPx - halfHandleSize) {
            return -1;
        }
        if (mouseX > currentHandlePosPx + halfHandleSize) {
            return 1;
        }
        return 0;
    }

    protected void onMouseButtonPressed(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        super.onMouseButtonPressed(button, x, y, when, lastWhen, isTopMost, hasFocus);
        if (isTopMost && this.getMaxValue() > this.getMinValue()) {
            Dim2i buffer = Dim2i.fromPool();
            this.getSizeHUD2Pixels_(x, y, buffer);
            int localX = buffer.getWidth();
            int localY = buffer.getHeight();
            Dim2i.toPool((Dim2i)buffer);
            if (this.getMousePosition(this.currentHandlePosPx, localX, localY) == 0) {
                this.bindToGlobalMouseMovement();
                this.slideStartHandlePos = this.currentHandlePosPx;
                this.slideStartMousePos = x;
                this.isSliding = true;
            }
        }
    }

    protected void onMouseButtonReleased(MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
        super.onMouseButtonReleased(button, x, y, when, lastWhen, isTopMost, hasFocus);
        this.isSliding = false;
        if (this.getSmoothSliding()) {
            this.setTextureDirty();
        }
    }

    protected void onMouseMoved(float x, float y, int buttonsState, long when, boolean isTopMost, boolean hasFocus) {
        super.onMouseMoved(x, y, buttonsState, when, isTopMost, hasFocus);
        if (this.isSliding && this.getMaxValue() > this.getMinValue()) {
            int oldForcedHandlePosPx = this.forcedHandlePosPx;
            float dx = x - this.slideStartMousePos;
            int leftWidth = HUDTextureUtils.getTextureWidth(this.leftTex);
            int rightWidth = HUDTextureUtils.getTextureWidth(this.rightTex);
            Dim2i buffer = Dim2i.fromPool();
            this.getSizeHUD2Pixels_(this.getWidth(), 0.0f, buffer);
            int widgetWidthPx = buffer.getWidth();
            this.getSizeHUD2Pixels_((float)this.slideStartHandlePos + dx, 0.0f, buffer);
            int slideHandlePos = buffer.getWidth();
            Dim2i.toPool((Dim2i)buffer);
            int barRestWidth = widgetWidthPx - leftWidth - rightWidth;
            this.forcedHandlePosPx = Math.max(leftWidth, Math.min(slideHandlePos, barRestWidth + leftWidth));
            int newValue = Math.round((float)((this.forcedHandlePosPx - leftWidth) * (this.getMaxValue() - this.getMinValue())) / (float)barRestWidth) + this.getMinValue();
            if (!this.getSmoothSliding()) {
                this.forcedHandlePosPx = leftWidth + barRestWidth * (newValue - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
            }
            if (newValue != this.getValue()) {
                this.setValue(newValue);
            } else if (this.forcedHandlePosPx != oldForcedHandlePosPx) {
                this.setTextureDirty();
            }
        }
    }

    public void setMinValue(int minValue) {
        if (minValue > this.maxValue) {
            throw new IllegalArgumentException("minValue must never be greater than maxValue.");
        }
        if (this.minValue == minValue) {
            return;
        }
        this.minValue = minValue;
        this.setTextureDirty();
    }

    public final int getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(int maxValue) {
        if (maxValue < this.minValue) {
            throw new IllegalArgumentException("maxValue must never be less than minValue.");
        }
        if (this.maxValue == maxValue) {
            return;
        }
        this.maxValue = maxValue;
        this.setTextureDirty();
    }

    public final int getMaxValue() {
        return this.maxValue;
    }

    public void setMinAndMax(int minValue, int maxValue) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must be <= maxValue.");
        }
        if (minValue == this.minValue && maxValue == this.maxValue) {
            return;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.setTextureDirty();
    }

    public void setMinMaxAndValue(int minValue, int maxValue, int value) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must be <= maxValue.");
        }
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException("value must be >= minValue and <= maxValue.");
        }
        if (minValue == this.minValue && maxValue == this.maxValue) {
            return;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = value;
        this.setTextureDirty();
    }

    protected void onSliderValueChanged(int oldValue, int newValue) {
        for (int i = 0; i < this.sliderListeners.size(); ++i) {
            this.sliderListeners.get(i).onSliderValueChanged(this, newValue);
        }
    }

    public boolean setValue(int value) {
        value = Math.max(this.getMinValue(), Math.min(value, this.getMaxValue()));
        if (value == this.value) {
            return false;
        }
        int oldValue = this.value;
        this.value = value;
        this.setTextureDirty();
        this.onSliderValueChanged(oldValue, value);
        return true;
    }

    public final int getValue() {
        return this.value;
    }

    public void addSliderListener(SliderListener l) {
        this.sliderListeners.add(l);
    }

    public boolean removeSliderListener(SliderListener l) {
        return this.sliderListeners.remove(l);
    }

    public void setSmoothSliding(boolean b) {
        this.smoothSliding = b;
    }

    public final boolean getSmoothSliding() {
        return this.smoothSliding;
    }

    protected int drawHandle(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, Texture2D handleTex, int forcedHandlePos) {
        int handleSize = HUDTextureUtils.getTextureWidth(handleTex);
        int handlePos = forcedHandlePos >= 0 ? forcedHandlePos : width * (this.getValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
        DrawUtils.drawImage(null, handleTex, null, texCanvas, offsetX + handlePos - handleSize / 2, offsetY, handleSize, height);
        return handlePos;
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        if (drawsSelf) {
            texCanvas.getImage().clear(offsetX, offsetY, width, height, true, null);
        }
        int leftWidth = HUDTextureUtils.getTextureWidth(this.leftTex);
        int rightWidth = HUDTextureUtils.getTextureWidth(this.rightTex);
        int bodyWidth = width - leftWidth - rightWidth;
        DrawUtils.drawImage(null, this.leftTex, null, texCanvas, offsetX, offsetY, width, height);
        DrawUtils.drawImage(null, this.bodyTex, TileMode.TILE_X, texCanvas, offsetX + leftWidth, offsetY, bodyWidth, height);
        DrawUtils.drawImage(null, this.rightTex, null, texCanvas, offsetX + width - rightWidth, offsetY, rightWidth, height);
        if (this.valueMarkTex != null) {
            int valueMarkWidth = HUDTextureUtils.getTextureWidth(this.valueMarkTex);
            int valueMarkHeight = HUDTextureUtils.getTextureHeight(this.valueMarkTex);
            int n = this.getMaxValue() - this.getMinValue();
            for (int i = 0; i <= n; ++i) {
                int pos = bodyWidth * i / n;
                DrawUtils.drawImage(null, this.valueMarkTex, null, texCanvas, offsetX + leftWidth + pos - valueMarkWidth / 2 - 1, offsetY + height - valueMarkHeight, valueMarkWidth, valueMarkHeight);
            }
        }
        if (this.getMaxValue() > this.getMinValue()) {
            this.currentHandlePosPx = leftWidth + this.drawHandle(texCanvas, offsetX + leftWidth, offsetY, width - leftWidth - rightWidth, height, this.handleTex, this.isSliding ? this.forcedHandlePosPx - leftWidth : -1);
        }
    }

    protected void init() {
        if (this.heightInPx > 0) {
            Dim2f buffer = Dim2f.fromPool();
            this.getSizePixels2HUD_(0, this.heightInPx, buffer);
            this.setSize(this.getWidth(), buffer.getHeight(), true);
            Dim2f.toPool((Dim2f)buffer);
            this.setTextureDirty();
        }
    }

    public Slider(float width, float height, Description desc) {
        super(false, false, width, height);
        this.heightInPx = height < 0.0f ? desc.getHeight() : -1;
        this.leftTex = desc.getLeftTexture();
        this.rightTex = desc.getRightTexture();
        this.bodyTex = desc.getBodyTexture();
        this.valueMarkTex = desc.getValueMarkTexture();
        this.handleTex = desc.getHandleTexture();
        this.handleYOffset = desc.getHandleButtonYOffset();
        this.minValue = 0;
        this.maxValue = 100;
        this.value = 0;
        this.smoothSliding = desc.getSmoothSliding();
    }

    public Slider(float width, Description desc) {
        this(width, -1.0f, desc);
    }

    public Slider(float width, float height) {
        this(width, height, HUD.getTheme().getSliderDescription());
    }

    public Slider(float width) {
        this(width, HUD.getTheme().getSliderDescription());
    }

    public static class Description
    extends Widget.DescriptionBase {
        private Texture2D leftTexture;
        private Texture2D bodyTexture;
        private Texture2D valueMarkTexture;
        private Texture2D rightTexture;
        private int height;
        private Texture2D handleTexture;
        private int handleYOffset;
        private boolean smoothSliding;

        public void setHeight(int height) {
            this.height = height;
        }

        public final int getHeight() {
            return this.height;
        }

        public void setLeftTexture(Texture2D texture) {
            this.leftTexture = texture;
        }

        public void setLeftTexture(String texture) {
            this.setLeftTexture(HUDTextureUtils.getTexture(texture, true));
        }

        public final Texture2D getLeftTexture() {
            return this.leftTexture;
        }

        public void setRightTexture(Texture2D texture) {
            this.rightTexture = texture;
        }

        public void setRightTexture(String texture) {
            this.setRightTexture(HUDTextureUtils.getTexture(texture, true));
        }

        public final Texture2D getRightTexture() {
            return this.rightTexture;
        }

        public void setBodyTexture(Texture2D texture) {
            this.bodyTexture = texture;
        }

        public void setBodyTexture(String texture) {
            this.setBodyTexture(HUDTextureUtils.getTexture(texture, true));
        }

        public final Texture2D getBodyTexture() {
            return this.bodyTexture;
        }

        public void setValueMarkTexture(Texture2D texture) {
            this.valueMarkTexture = texture;
        }

        public void setValueMarkTexture(String texture) {
            this.setValueMarkTexture(HUDTextureUtils.getTexture(texture, true));
        }

        public final Texture2D getValueMarkTexture() {
            return this.valueMarkTexture;
        }

        public void setHandleTexture(Texture2D texture) {
            this.handleTexture = texture;
        }

        public void setHandleTexture(String texture) {
            this.setHandleTexture(HUDTextureUtils.getTexture(texture, true));
        }

        public final Texture2D getHandleTexture() {
            return this.handleTexture;
        }

        public void setHandleButtonYOffset(int yOffset) {
            this.handleYOffset = yOffset;
        }

        public final int getHandleButtonYOffset() {
            return this.handleYOffset;
        }

        public void setSmoothSliding(boolean b) {
            this.smoothSliding = b;
        }

        public final boolean getSmoothSliding() {
            return this.smoothSliding;
        }

        public void set(Description desc) {
            this.height = desc.height;
            this.leftTexture = desc.leftTexture;
            this.bodyTexture = desc.bodyTexture;
            this.valueMarkTexture = desc.valueMarkTexture;
            this.rightTexture = desc.rightTexture;
            this.handleTexture = desc.handleTexture;
            this.handleYOffset = desc.handleYOffset;
            this.smoothSliding = desc.smoothSliding;
        }

        public Description clone() {
            return new Description(this);
        }

        private Description(Description desc) {
            this.set(desc);
        }

        public Description(int height, Texture2D leftTexture, Texture2D rightTexture, Texture2D bodyTexture, Texture2D valueMarkTexture, Texture2D handleTexture, int handleYOffset, boolean smoothSliding) {
            this.height = height;
            this.leftTexture = leftTexture;
            this.bodyTexture = bodyTexture;
            this.rightTexture = rightTexture;
            this.valueMarkTexture = valueMarkTexture;
            this.handleTexture = handleTexture;
            this.handleYOffset = handleYOffset;
            this.smoothSliding = smoothSliding;
        }

        public Description(int height, String leftTexture, String rightTexture, String bodyTexture, String valueMarkTexture, String handleTexture, int handleYOffset, boolean smoothSliding) {
            this(height, HUDTextureUtils.getTexture(leftTexture, true), HUDTextureUtils.getTexture(rightTexture, true), HUDTextureUtils.getTexture(bodyTexture, true), HUDTextureUtils.getTexture(valueMarkTexture, true), HUDTextureUtils.getTexture(handleTexture, true), handleYOffset, smoothSliding);
        }
    }
}

