/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Dim2i;
import org.openmali.vecmath2.Colorf;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.OperationScheduler;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.Border;
import org.xith3d.ui.hud.listeners.TextFieldListener;
import org.xith3d.ui.hud.utils.Cursor;
import org.xith3d.ui.hud.utils.DrawUtils;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.utils.TileMode;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;

public class TextField
extends Label {
    private String dispText = "";
    private static final CaretBlinker blinker = new CaretBlinker(500000L);
    private final Texture2D caretTex;
    private int caretPosByChars;
    private float caretLeftHUD;
    private boolean editable = true;
    private char echoChar = (char)42;
    private boolean echoMode = false;
    private char[] ignoredChars = new char[]{'^'};
    private final ArrayList<TextFieldListener> listeners = new ArrayList();
    private static Graphics2D graphics = new BufferedImage(16, 16, 5).createGraphics();

    public void addTextFieldListener(TextFieldListener l) {
        this.listeners.add(l);
    }

    public void removeTextFieldListener(TextFieldListener l) {
        this.listeners.remove(l);
    }

    public void setEditable(boolean editable) {
        if (editable == this.editable) {
            return;
        }
        this.editable = editable;
        if (editable && this.hasFocus(true)) {
            blinker.start(this, this.getHUD().getOperationScheduler());
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    private final float getCharWidth(char ch) {
        FontMetrics metrics = graphics.getFontMetrics(this.getFont(!this.isEnabled()).getAWTFont(this.getHUD()));
        Rectangle2D bounds = metrics.getStringBounds(String.valueOf(ch), graphics);
        return (float)bounds.getWidth();
    }

    private final float getEchoCharWidth() {
        return this.getCharWidth(this.getEchoChar());
    }

    private float getCharWidth(int i) {
        if (i >= this.getDisplayedText().length()) {
            return 0.0f;
        }
        return this.getCharWidth(this.getDisplayedText().charAt(i));
    }

    private final float computeCaretPos() {
        FontMetrics metrics = graphics.getFontMetrics(this.getFont(!this.isEnabled()).getAWTFont(this.getHUD()));
        Rectangle2D bounds = metrics.getStringBounds(this.getDisplayedText().substring(0, this.caretPosByChars), graphics);
        return (float)bounds.getWidth();
    }

    private final void resetTextOffset() {
        this.setTextOffset(0, 0);
    }

    private void updateCaretPosition() {
        if (this.getHUD() == null) {
            return;
        }
        this.caretLeftHUD = 0.0f;
        this.caretLeftHUD = this.isEchoMode() ? (this.caretLeftHUD += (float)this.caretPosByChars * this.getEchoCharWidth()) : (this.caretLeftHUD += this.computeCaretPos());
        if (this.getDisplayedText().length() == 0) {
            this.resetTextOffset();
        } else {
            int textOffset = this.getTextOffsetX();
            int offsetIdx = -1;
            while ((float)textOffset + this.caretLeftHUD < 0.0f) {
                textOffset = (int)((float)textOffset + this.getCharWidth(++offsetIdx));
            }
            int widthPX = this.getContentWidthPX();
            offsetIdx = this.getText().length();
            while ((float)textOffset + this.caretLeftHUD > (float)widthPX) {
                textOffset = (int)((float)textOffset - this.getCharWidth(--offsetIdx));
            }
            this.setTextOffset(textOffset, this.getTextOffsetY());
        }
        this.caretLeftHUD += (float)this.getTextOffsetX();
        Dim2f buffer = Dim2f.fromPool();
        this.caretLeftHUD = this.getSizePixels2HUD_((int)this.caretLeftHUD, 0, buffer).getWidth();
        Dim2f pixel = buffer;
        this.getSizeOfPixels_(1, 1, pixel);
        this.caretLeftHUD += (float)this.getPaddingLeft();
        if (this.getBorder() != null) {
            this.caretLeftHUD += (float)this.getBorder().getLeftWidth();
        }
        Dim2f.toPool((Dim2f)buffer);
        this.updateTranslation();
    }

    public void setCaretPosition(int pos) {
        this.caretPosByChars = pos;
        this.caretPosByChars = Math.max(this.caretPosByChars, 0);
        this.caretPosByChars = Math.min(this.caretPosByChars, this.getDisplayedText().length());
        this.updateCaretPosition();
    }

    public final int getCaretPosition() {
        return this.caretPosByChars;
    }

    public void setEchoChar(char echoChar) {
        this.echoChar = echoChar;
    }

    public final char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoMode(boolean echoMode, char echoChar) {
        this.echoMode = echoMode;
        this.setEchoChar(echoChar);
        this.updateText();
    }

    public void setEchoMode(boolean echoMode) {
        this.setEchoMode(echoMode, this.getEchoChar());
    }

    public boolean isEchoMode() {
        return this.echoMode;
    }

    public void setIgnoredChars(char ... ignoredChars) {
        this.ignoredChars = ignoredChars;
    }

    public char[] getIgnoredChars() {
        return this.ignoredChars;
    }

    private void updateDisplayedText() {
        String text = this.getText();
        if (this.isEchoMode()) {
            char[] chars = new char[text.length()];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.getEchoChar();
            }
            this.dispText = new String(chars);
        } else {
            this.dispText = text;
        }
    }

    public String getDisplayedText() {
        return this.dispText;
    }

    protected void updateText() {
        this.updateDisplayedText();
        super.updateText();
    }

    private void setTextInternal(String text) {
        super.setText(text);
        this.updateCaretPosition();
    }

    public void setText(String text) {
        this.caretPosByChars = 0;
        this.resetTextOffset();
        this.setTextInternal(text);
    }

    public void setFont(HUDFont font) {
        super.setFont(font);
        this.updateCaretPosition();
    }

    protected boolean blocksFocusMoveDeviceComponent(DeviceComponent dc) {
        if (dc == Keys.LEFT) {
            return true;
        }
        return dc == Keys.RIGHT;
    }

    protected void onKeyPressed(Key key, int modifierMask, long when) {
        super.onKeyPressed(key, modifierMask, when);
        if (!this.isEditable() || !this.isEnabled()) {
            return;
        }
        switch (key.getKeyID()) {
            case LEFT: {
                this.caretPosByChars = Math.max(0, this.caretPosByChars - 1);
                this.updateCaretPosition();
                this.setTextureDirty();
                break;
            }
            case RIGHT: {
                this.caretPosByChars = Math.min(this.caretPosByChars + 1, this.getDisplayedText().length());
                this.updateCaretPosition();
                this.setTextureDirty();
                break;
            }
            case HOME: {
                this.caretPosByChars = 0;
                this.updateCaretPosition();
                this.setTextureDirty();
                break;
            }
            case END: {
                this.caretPosByChars = this.getDisplayedText().length();
                this.updateCaretPosition();
                this.setTextureDirty();
            }
        }
    }

    protected void onKeyTyped(char ch, int modifierMask, long when) {
        block12: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                super.onKeyTyped(ch, modifierMask, when);
                                if (!this.isEditable() || !this.isEnabled()) {
                                    return;
                                }
                                if (ch != '\b') break block11;
                                if (this.caretPosByChars > 0) {
                                    String leftPart = this.caretPosByChars > 0 ? this.getText().substring(0, this.caretPosByChars - 1) : "";
                                    String rightPart = this.caretPosByChars < this.getText().length() ? this.getText().substring(this.caretPosByChars) : "";
                                    --this.caretPosByChars;
                                    this.setTextInternal(leftPart + rightPart);
                                    this.setTextureDirty();
                                }
                                for (int i = 0; i < this.listeners.size(); ++i) {
                                    this.listeners.get(i).onCharDeleted(this);
                                }
                                break block12;
                            }
                            if (ch != '\u007f') break block13;
                            if (this.caretPosByChars < this.getText().length()) {
                                String leftPart = this.caretPosByChars > 0 ? this.getText().substring(0, this.caretPosByChars) : "";
                                String rightPart = this.caretPosByChars < this.getText().length() ? this.getText().substring(this.caretPosByChars + 1) : "";
                                this.setTextInternal(leftPart + rightPart);
                                this.setTextureDirty();
                            }
                            for (int i = 0; i < this.listeners.size(); ++i) {
                                this.listeners.get(i).onCharDeleted(this);
                            }
                            break block12;
                        }
                        if (ch != '\u001b') break block14;
                        for (int i = 0; i < this.listeners.size(); ++i) {
                            this.listeners.get(i).onEscapeHit(this);
                        }
                        break block12;
                    }
                    if (ch != '\t') break block15;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).onTabHit(this);
                    }
                    break block12;
                }
                if (ch != '\n' && ch != '\r') break block16;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.get(i).onEnterHit(this);
                }
                break block12;
            }
            boolean ignored = false;
            if (this.ignoredChars != null) {
                for (int i = 0; i < this.ignoredChars.length; ++i) {
                    if (this.ignoredChars[i] != ch) continue;
                    ignored = true;
                    break;
                }
            }
            if (ignored) break block12;
            String leftPart = this.caretPosByChars > 0 ? this.getText().substring(0, this.caretPosByChars) : "";
            String rightPart = this.caretPosByChars < this.getText().length() ? this.getText().substring(this.caretPosByChars) : "";
            ++this.caretPosByChars;
            this.setTextInternal(leftPart + ch + rightPart);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).onCharTyped(this, ch);
            }
        }
    }

    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        this.updateCaretPosition();
    }

    protected void onFocusGained() {
        super.onFocusGained();
        if (this.isEditable()) {
            blinker.start(this, this.getHUD().getOperationScheduler());
        }
    }

    protected void onFocusLost() {
        super.onFocusLost();
        blinker.stop();
    }

    protected void onAttachedToHUD(HUD hud) {
        super.onAttachedToHUD(hud);
        this.updateCaretPosition();
    }

    protected void onDetachedFromHUD(HUD hud) {
        super.onDetachedFromHUD(hud);
        if (blinker != null) {
            blinker.stop();
        }
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
        super.drawWidget(texCanvas, offsetX, offsetY, width, height, drawsSelf);
        if (blinker.caretImage.isVisible()) {
            Dim2i buffer = Dim2i.fromPool();
            this.getSizeHUD2Pixels_(this.caretLeftHUD, 0.0f, buffer);
            int caretLeftPX = buffer.getWidth();
            Dim2i.toPool((Dim2i)buffer);
            int caretWidth = HUDTextureUtils.getTextureWidth(this.caretTex);
            DrawUtils.drawImage(null, this.caretTex, TileMode.STRETCH, texCanvas, offsetX + caretLeftPX - this.getPaddingLeft(), offsetY + 1, caretWidth, this.getContentHeightPX() - 2);
        }
    }

    protected void init() {
        super.init();
        this.updateDisplayedText();
        this.setText(this.getText());
    }

    public TextField(boolean isHeavyWeight, float width, float height, String text, Description textFieldDesc) {
        super(isHeavyWeight, true, width, height, text, textFieldDesc);
        this.setFocussable(true);
        this.setBorder(textFieldDesc.getBorderDescription());
        this.caretTex = textFieldDesc.getCaretTexture() != null ? textFieldDesc.getCaretTexture() : HUD.getTheme().getTextFieldDescription().getCaretTexture();
        this.caretPosByChars = 0;
        this.resetTextOffset();
        this.setCursor(Cursor.Type.TEXT);
    }

    private static Description getDesc(HUDFont font, Colorf color, TextAlignment alignment) {
        Description desc = HUD.getTheme().getTextFieldDescription();
        if (font != null) {
            desc.setFont(font, false);
            desc.setFont(Label.Description.deriveDisabledFont(font), false);
        }
        if (color != null) {
            desc.setFontColor(color, false);
        }
        if (alignment != null) {
            desc.setAlignment(alignment);
        }
        return desc;
    }

    public TextField(boolean isHeavyWeight, float width, float height, String text, HUDFont font, Colorf color, TextAlignment alignment) {
        this(isHeavyWeight, width, height, text, TextField.getDesc(font, color, alignment));
    }

    public TextField(boolean isHeavyWeight, float width, float height, String text) {
        this(isHeavyWeight, width, height, text, HUD.getTheme().getTextFieldDescription());
    }

    public TextField(boolean isHeavyWeight, float width, float height) {
        this(isHeavyWeight, width, height, "", HUD.getTheme().getTextFieldDescription());
    }

    public TextField(float width, float height, String text, Description textFieldDesc) {
        this(false, width, height, text, textFieldDesc);
    }

    public TextField(float width, float height, String text, HUDFont font, Colorf color, TextAlignment alignment) {
        this(false, width, height, text, TextField.getDesc(font, color, alignment));
    }

    public TextField(float width, float height, String text) {
        this(false, width, height, text, HUD.getTheme().getTextFieldDescription());
    }

    public TextField(float width, float height) {
        this(false, width, height, "", HUD.getTheme().getTextFieldDescription());
    }

    private static class CaretBlinker
    extends Interval {
        private TextField currentTextField = null;
        private final Image caretImage = new Image(1.0f, 16.0f, HUD.getTheme().getTextCaretTexture("black"), TileMode.STRETCH);

        protected void onIntervalHit(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
            super.onIntervalHit(gameTime, frameTime, timingMode);
            this.caretImage.setVisible(this.currentTextField.isEditable() && this.currentTextField.hasFocus(true) && !this.caretImage.isVisible());
            this.currentTextField.setTextureDirty();
        }

        private void init() {
            this.currentTextField.updateCaretPosition();
            this.caretImage.setVisible(this.currentTextField.isEditable() && this.currentTextField.hasFocus(true));
            this.currentTextField.setTextureDirty();
        }

        public void start(TextField textField, OperationScheduler opScheder) {
            if (this.caretImage != null && this.caretImage.getContainer() != null) {
                this.caretImage.detach();
            }
            this.currentTextField = textField;
            this.init();
            if (!this.isAlive()) {
                opScheder.addInterval(this);
            }
        }

        public void stop() {
            super.kill();
            if (this.caretImage != null) {
                this.caretImage.setVisible(false);
                this.caretImage.detach();
            }
        }

        public CaretBlinker(long rate) {
            super(rate);
            this.caretImage.setVisible(false);
            this.stop();
        }
    }

    public static class Description
    extends Label.Description {
        private Border.Description borderDesc;
        private Texture2D caretTexture;

        public void setBorderDescription(Border.Description borderDesc) {
            this.borderDesc = borderDesc;
        }

        public final Border.Description getBorderDescription() {
            return this.borderDesc;
        }

        public void setCaretTexture(Texture2D texture) {
            this.caretTexture = texture;
        }

        public void setCaretTexture(String texture) {
            this.setCaretTexture(HUD.getTheme().getTextCaretTexture(texture));
        }

        public final Texture2D getCaretTexture() {
            return this.caretTexture;
        }

        public void set(Description template) {
            super.set(template);
            this.borderDesc = template.borderDesc.clone();
            this.caretTexture = template.caretTexture;
        }

        public Description clone() {
            return new Description(this);
        }

        protected Description(Description template) {
            super(template);
            this.set(template);
        }

        public Description(Label.Description labelDesc, Border.Description borderDesc, Texture2D caretTexture) {
            super(labelDesc);
            this.borderDesc = borderDesc;
            this.caretTexture = caretTexture;
        }

        public Description(Label.Description labelDesc, Border.Description borderDesc, String caretTexture) {
            this(labelDesc, borderDesc, HUDTextureUtils.getTexture(caretTexture, true));
        }

        public Description(Label.Description labelDesc, Border.Description borderDesc) {
            this(labelDesc, borderDesc, (Texture2D)null);
        }
    }
}

