/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Rect2i;
import org.openmali.vecmath2.Tuple2i;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.base.Widget;

public class Widget3D
extends Widget {
    private final RenderPassConfig rpConfig;

    public final RenderPassConfig getRenderPassConfig() {
        return this.rpConfig;
    }

    protected void onLocationChanged(float oldLeft, float oldTop, float newLeft, float newTop) {
        super.onLocationChanged(oldLeft, oldTop, newLeft, newTop);
        if (this.getHUD() != null) {
            Tuple2i loc2 = Tuple2i.fromPool();
            float x = newLeft;
            float y = newTop;
            if (this.getBorder() != null) {
                x += (float)this.getBorder().getLeftWidth();
                y += (float)this.getBorder().getTopHeight();
            }
            this.getLocationHUD2Pixels_(x, y, loc2);
            Rect2i viewport = this.rpConfig.getViewport();
            if (viewport == null) {
                viewport = new Rect2i();
                this.rpConfig.setViewport(viewport);
            }
            viewport.setLocation(loc2.getX(), loc2.getY());
            Tuple2i.toPool((Tuple2i)loc2);
        }
    }

    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        if (this.getHUD() != null) {
            Dim2i size2 = Dim2i.fromPool();
            float w = newWidth;
            float h = newHeight;
            if (this.getBorder() != null) {
                w -= (float)(this.getBorder().getLeftWidth() + this.getBorder().getRightWidth());
                h -= (float)(this.getBorder().getTopHeight() + this.getBorder().getBottomHeight());
            }
            this.getSizeHUD2Pixels_(w, h, size2);
            Rect2i viewport = this.rpConfig.getViewport();
            if (viewport == null) {
                viewport = new Rect2i();
                this.rpConfig.setViewport(viewport);
            }
            viewport.setSize(size2.getWidth(), size2.getHeight());
            Dim2i.toPool((Dim2i)size2);
        }
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
    }

    protected void init() {
    }

    public Widget3D(float width, float height, RenderPassConfig rpConfig) {
        super(false, false, width, height);
        this.rpConfig = rpConfig;
    }
}

