/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.xith3d.scenegraph.Node;
import org.xith3d.ui.swingui.UIDraggingInformation;
import org.xith3d.ui.swingui.UIOverlay;
import org.xith3d.ui.swingui.UIOverlayInterface;

public class UIDraggingWindow
implements UIOverlayInterface {
    private UIDraggingInformation di = null;
    private UIOverlay overlay;
    boolean dirty = false;
    boolean canDrop = false;
    private BufferedImage image = new BufferedImage(32, 32, 2);

    public void getSize(Dimension dim) {
        dim.setSize(32, 32);
    }

    public UIDraggingInformation getDraggingInterface() {
        return this.di;
    }

    public void setDi(UIDraggingInformation di) {
        this.di = di;
        this.dirty = true;
    }

    public void update() {
        if (this.dirty) {
            if (this.di != null) {
                Graphics g = this.image.getGraphics();
                g.drawImage(this.di.getIconBackground(), 0, 0, null);
                if (this.di.getIcon() != null) {
                    g.drawImage(this.di.getIcon(), 0, 0, null);
                }
                if (this.canDrop) {
                    g.drawImage(this.di.getIconCanDrop(), 0, 0, null);
                }
                g.dispose();
            } else {
                Graphics g = this.image.getGraphics();
                g.setColor(Color.black);
                g.fillRect(0, 0, 32, 32);
                g.setColor(Color.yellow);
                g.drawRect(0, 0, 32, 32);
            }
            this.overlay.repaint(this.image);
            this.dirty = false;
        }
    }

    public void setCanDrop(boolean drop) {
        this.canDrop = drop;
        this.dirty = true;
    }

    public Node getRoot() {
        return this.overlay.getRoot();
    }

    public boolean isOpaque() {
        return false;
    }

    public UIDraggingWindow() {
        this.overlay = new UIOverlay(32, 32, false, true);
    }
}

