/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.jagatoo.image.DirectBufferedImage;
import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.openmali.vecmath2.Colorf;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.View;
import org.xith3d.ui.swingui.UIDirtyRegion;
import org.xith3d.ui.swingui.UISubOverlayBase;
import org.xith3d.ui.swingui.UISubOverlayOptimized;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIOverlay {
    protected static final Boolean DEBUG = null;
    public static final int BACKGROUND_NONE = 0;
    public static final int BACKGROUND_COPY = 1;
    private BufferedImage canvas;
    private boolean clipAlpha;
    private boolean blendAlpha;
    private int imageType;
    private List<UISubOverlayBase> subOverlays;
    protected int width;
    protected int height;
    protected Group consoleBG;
    private RenderingAttributes ra = null;
    private PolygonAttributes pa = null;
    private TextureAttributes ta = null;
    private TransparencyAttributes tra = null;
    private boolean dirty = false;
    private boolean painting = false;
    private boolean owned = false;
    int backgroundMode = 0;
    private BufferedImage backgroundImage = null;
    private Object mutex;
    static int testNum = 0;

    public boolean isOwned() {
        return this.owned;
    }

    public boolean isOpaque() {
        return !this.blendAlpha;
    }

    protected void initialize() {
    }

    public void setPosition(int x, int y) {
    }

    public Node getRoot() {
        return this.consoleBG;
    }

    private void createSubOverlays() {
        this.subOverlays = new ArrayList<UISubOverlayBase>();
        int numCols = 0;
        int[] cols = new int[20];
        for (int w = this.width; w > 0; w -= cols[numCols++]) {
            int p = this.optimalPower(w, 32) - 1;
            if (p > w) {
                p = w;
            }
            cols[numCols] = p;
        }
        int numRows = 0;
        int[] rows = new int[20];
        for (int h = this.height; h > 0; h -= rows[numRows++]) {
            int p = this.optimalPower(h, 32);
            if (p > h) {
                p = h;
            }
            rows[numRows] = p;
        }
        int yStart = 0;
        int yStop = rows[0] - 1;
        for (int row = 0; row < numRows; ++row) {
            int xStart = 0;
            int xStop = cols[0] - 1;
            for (int col = 0; col < numCols; ++col) {
                UISubOverlayOptimized s = new UISubOverlayOptimized(this, xStart, yStart, xStop, yStop);
                this.subOverlays.add(s);
                this.consoleBG.addChild(s.getShape());
                if (col >= numCols - 1) continue;
                xStart = xStop + 1;
                xStop += cols[col + 1];
            }
            if (row >= numRows - 1) continue;
            yStart = yStop + 1;
            yStop += rows[row + 1];
        }
    }

    private int optimalPower(int value, int threshhold) {
        int n;
        for (n = 2; n < value; n *= 2) {
            if (n * 2 > 512) {
                return 512;
            }
            if (n * 2 <= value) continue;
            if (n * 2 - value < threshhold) {
                return n * 2;
            }
            return n;
        }
        return n;
    }

    public boolean getClipAlpha() {
        return this.clipAlpha;
    }

    public boolean getBlendAlpha() {
        return this.blendAlpha;
    }

    public int getImageType() {
        return this.imageType;
    }

    public RenderingAttributes getRenderingAttributes() {
        return this.ra;
    }

    public PolygonAttributes getPolygonAttributes() {
        return this.pa;
    }

    public TextureAttributes getTextureAttributes() {
        return this.ta;
    }

    public TransparencyAttributes getTransparencyAttributes() {
        return this.tra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveToBackbuffer() {
        Object object = this.mutex;
        synchronized (object) {
            this.painting = true;
            int n = this.subOverlays.size();
            for (int i = 0; i < n; ++i) {
                UISubOverlayOptimized s = (UISubOverlayOptimized)this.subOverlays.get(i);
                s.update(this.canvas, s.getBounds());
            }
            this.dirty = true;
            this.painting = false;
        }
    }

    protected Graphics2D getPreppedCanvas() {
        if (this.backgroundMode == 1 && this.backgroundImage != null) {
            this.canvas.setData(this.backgroundImage.getRaster());
        }
        Graphics2D g = (Graphics2D)this.canvas.getGraphics();
        return g;
    }

    public void repaintChanged(BufferedImage image, ArrayList<?> dirtyAreas) {
        int n = this.subOverlays.size();
        for (int i = 0; i < n; ++i) {
            UISubOverlayOptimized s = (UISubOverlayOptimized)this.subOverlays.get(i);
            Rectangle sbounds = s.getBounds();
            int nn = dirtyAreas.size();
            for (int j = 0; j < nn; ++j) {
                Rectangle r = ((UIDirtyRegion)dirtyAreas.get(j)).getAbsDirty();
                if (!r.intersects(sbounds)) continue;
                s.update(image, r);
            }
        }
        this.dirty = true;
    }

    public void repaint(BufferedImage image) {
        int n = this.subOverlays.size();
        for (int i = 0; i < n; ++i) {
            UISubOverlayOptimized s = (UISubOverlayOptimized)this.subOverlays.get(i);
            Rectangle sbounds = s.getBounds();
            s.update(image, sbounds);
        }
        this.dirty = true;
    }

    public void repaint() {
        Graphics2D g = this.getPreppedCanvas();
        this.paint(g);
        g.dispose();
        this.moveToBackbuffer();
    }

    public void getSize(Dimension dim) {
        dim.width = this.width;
        dim.height = this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (this.dirty && !this.painting) {
            Object object = this.mutex;
            synchronized (object) {
                int n = this.subOverlays.size();
                for (int i = 0; i < n; ++i) {
                    UISubOverlayBase s = this.subOverlays.get(i);
                    if (!s.dirty) continue;
                    s.swap();
                }
                this.dirty = false;
            }
        }
    }

    public void setVisible(boolean yes) {
        throw new Error("Implementation removed. Please talk to the author!");
    }

    public void paint(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(Color.red);
        g.fillOval(1, 1, this.width - 2, this.height - 2);
        g.setColor(Color.yellow);
        g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
        g.setColor(Color.cyan);
        g.drawLine(0, 0, this.width - 1, 0);
        g.setColor(Color.green);
        g.drawLine(0, 0, 0, this.height - 1);
        g.setColor(Color.magenta);
        g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
    }

    protected View getView() {
        return null;
    }

    protected void attachNode(Node node) {
        this.consoleBG.addChild(node);
    }

    private DirectBufferedImage getAppropriateImage() {
        if (this.clipAlpha || this.blendAlpha) {
            return DirectBufferedImage.makeDirectImageRGBA((int)this.width, (int)this.height);
        }
        return DirectBufferedImage.makeDirectImageRGB((int)this.width, (int)this.height);
    }

    public BufferedImage getBackgroundImage() {
        if (this.backgroundImage == null) {
            return this.getAppropriateImage();
        }
        return this.backgroundImage;
    }

    public void setBackgroundColor(Color c) {
        if (this.backgroundImage == null) {
            this.backgroundImage = this.getAppropriateImage();
        }
        int[] pixels = new int[this.width * this.height];
        int rgb = c.getRGB();
        for (int i = 0; i < this.width * this.height; ++i) {
            pixels[i] = rgb;
        }
        this.backgroundImage.setRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        this.backgroundMode = 1;
    }

    public void setBackgroundImage(BufferedImage bi) {
        this.backgroundImage = bi;
        this.backgroundMode = bi == null ? 0 : 1;
    }

    public void setBackgroundMode(int mode) {
        this.backgroundMode = mode;
    }

    public UIOverlay(int width, int height, boolean clipAlpha, boolean blendAlpha, boolean owned, float offset, boolean readDepthBuffer) {
        this.owned = owned;
        this.width = width;
        this.height = height;
        this.blendAlpha = blendAlpha;
        this.clipAlpha = clipAlpha;
        this.canvas = this.getAppropriateImage();
        this.ra = new RenderingAttributes();
        if (clipAlpha) {
            this.ra.setAlphaTestFunction(RenderingAttributes.NOT_EQUAL);
            this.ra.setAlphaTestValue(0.0f);
        }
        this.ra.setDepthBufferEnabled(false);
        this.ra.setDepthBufferWriteEnabled(false);
        this.ra.setIgnoreVertexColors(true);
        this.pa = new PolygonAttributes();
        this.pa.setBackFaceNormalFlip(false);
        this.pa.setFaceCullMode(FaceCullMode.NONE);
        this.pa.setDrawMode(DrawMode.FILL);
        this.pa.setPolygonOffsetFactor(offset);
        this.ta = new TextureAttributes();
        this.ta.setTextureMode(TextureAttributes.REPLACE);
        this.ta.setPerspectiveCorrectionMode(TextureAttributes.NICEST);
        if (clipAlpha || blendAlpha) {
            this.tra = new TransparencyAttributes(TransparencyAttributes.BLENDED, 1.0f);
            this.ta.setTextureBlendColor(new Colorf(0.0f, 0.0f, 0.0f, 1.0f));
        }
        this.consoleBG = new Group();
        X3DLog.debug("Overlay : ", width, "x", height);
        this.createSubOverlays();
        this.initialize();
        this.mutex = new Object();
    }

    public UIOverlay(int width, int height, boolean clipAlpha, boolean blendAlpha, boolean owned) {
        this(width, height, clipAlpha, blendAlpha, owned, 0.0f, true);
    }

    public UIOverlay(int width, int height, boolean clipAlpha, boolean blendAlpha) {
        this(width, height, clipAlpha, blendAlpha, false);
    }
}

