/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.swingui;

import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.xith3d.ui.swingui.UIDirtyRegion;

public class UIRepaintManager
extends RepaintManager {
    private HashMap<JComponent, UIDirtyRegion> map = new HashMap();

    public void markCompletelyDirty(JComponent aComponent) {
        super.markCompletelyDirty(aComponent);
        UIDirtyRegion dr = this.map.get(aComponent);
        if (dr == null) {
            dr = new UIDirtyRegion(aComponent, aComponent.getBounds(), null);
            this.map.put(aComponent, dr);
        } else {
            dr.setCompDirty(aComponent.getBounds());
        }
    }

    public void paintDirtyRegions() {
        super.paintDirtyRegions();
    }

    public void removeUIDirtyRegion(JComponent c) {
        this.map.remove(c);
        super.markCompletelyClean(c);
    }

    public boolean isDirty() {
        return this.map.size() > 0;
    }

    public void clear() {
        this.map.clear();
    }

    public UIDirtyRegion getUIDirtyRegion(JComponent c) {
        UIDirtyRegion dr = this.map.get(c);
        return dr;
    }

    public void addDirtyRegion(JComponent aComponent, int x, int y, int w, int h) {
        super.addDirtyRegion(aComponent, x, y, w, h);
        UIDirtyRegion dr = this.map.get(aComponent);
        if (dr == null) {
            dr = new UIDirtyRegion(aComponent, new Rectangle(x, y, w, h), null);
            this.map.put(aComponent, dr);
        } else {
            dr.setCompDirty(dr.getCompDirty().union(new Rectangle(x, y, w, h)));
        }
    }
}

