/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.swingui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.jagatoo.image.DirectBufferedImage;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.ui.swingui.UIOverlay;
import org.xith3d.ui.swingui.UISubOverlayBase;
import org.xith3d.utility.logging.X3DLog;

public class UISubOverlay
extends UISubOverlayBase {
    private BufferedImage a;
    private BufferedImage b;
    private TextureImage2D icA;
    private TextureImage2D icB;
    private Texture2D tex;
    private boolean frontBuffer;

    protected void updateBackBufferByDraw(BufferedImage fullImage) {
        BufferedImage backBuffer = this.frontBuffer ? this.b : this.a;
        this.dirty = true;
        Graphics g = backBuffer.getGraphics();
        g.drawImage(fullImage, 0, 0, this.width, this.height, this.lx, this.overlay.height - this.ly, this.ux + 1, this.overlay.height - this.uy - 1, null);
    }

    public void updateBackBuffer(DirectBufferedImage fullImage) {
        BufferedImage backBuffer = this.frontBuffer ? this.b : this.a;
        this.dirty = true;
        int w = fullImage.getWidth();
        ByteBuffer fullBytes = fullImage.getByteBuffer();
        ByteBuffer backBytes = ((DirectBufferedImage)backBuffer).getByteBuffer();
        int size = fullImage.getDirectType() == DirectBufferedImage.Type.DIRECT_RGBA ? 4 : 3;
        byte[] buffer = new byte[this.width * size];
        for (int i = 0; i < this.height; ++i) {
            int y = this.overlay.height - this.uy + i - 1;
            int yy = this.texHeight - i - 1 - (this.texHeight - this.height);
            fullBytes.get(buffer, (w * y + this.lx) * size, this.width * size);
            backBytes.put(buffer, yy * this.texWidth * size, this.width * size);
        }
    }

    public void swap() {
        if (this.frontBuffer) {
            this.tex.setImage(0, this.icB);
        } else {
            this.tex.setImage(0, this.icA);
        }
        this.frontBuffer = !this.frontBuffer;
        this.dirty = false;
    }

    protected UISubOverlay(UIOverlay overlay, int lx, int ly, int ux, int uy) {
        super(overlay, lx, ly, ux, uy);
        boolean hasAlpha;
        boolean bl = hasAlpha = overlay.getBlendAlpha() || overlay.getClipAlpha();
        if (hasAlpha) {
            this.a = DirectBufferedImage.makeDirectImageRGBA((int)this.texWidth, (int)this.texHeight);
            this.b = DirectBufferedImage.makeDirectImageRGBA((int)this.texWidth, (int)this.texHeight);
        } else {
            this.a = DirectBufferedImage.makeDirectImageRGB((int)this.texWidth, (int)this.texHeight);
            this.b = DirectBufferedImage.makeDirectImageRGB((int)this.texWidth, (int)this.texHeight);
        }
        TextureImageFormat tiFormat = hasAlpha ? TextureImageFormat.RGBA : TextureImageFormat.RGB;
        this.icA = new TextureImage2D(tiFormat, this.a, true);
        this.icB = new TextureImage2D(tiFormat, this.b, true);
        X3DLog.debug("Sub-overlay : ", this.width, ",", this.height, " -> ", this.texWidth, ",", this.texHeight, " : ", lx, "," + ly, " - ", ux, ",", uy);
        this.tex = new Texture2D(hasAlpha ? TextureFormat.RGBA : TextureFormat.RGB);
        this.tex.setBoundaryModes(TextureBoundaryMode.CLAMP_TO_EDGE, TextureBoundaryMode.CLAMP_TO_EDGE);
        this.tex.setFilter(TextureFilter.POINT);
        this.tex.setImage(0, this.icA);
        this.ap.setTexture(this.tex);
        this.frontBuffer = true;
    }
}

