/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.text2d;

import java.awt.Font;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.ui.text2d.Character2D;
import org.xith3d.ui.text2d.TextAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line2D
extends TransformGroup {
    private Font font;
    private String charId;
    private TextAlignment align;
    private Colorf color = new Colorf();
    private String text = "";
    private Vector<Character2D> characters;
    private List<Character2D> unmodCharacters;
    private Tuple2f size;
    private Vector3f tmpVec = new Vector3f();
    private TransparencyAttributes cachedTA = null;

    public List<Character2D> getCharacters() {
        return this.unmodCharacters;
    }

    public void setText(String newText) {
        Transform3D t3d;
        while (this.characters.size() > newText.length()) {
            Character2D c = this.characters.remove(this.characters.size() - 1);
            this.removeChild(c.getParent());
        }
        float offsetX = 0.0f;
        this.characters.ensureCapacity(newText.length());
        for (int i = 0; i < newText.length(); ++i) {
            TransformGroup tg;
            Character2D currChar;
            if (this.characters.size() <= i) {
                currChar = this.font == null ? Character2D.loadCharacter(newText.charAt(i), this.color, this.charId) : Character2D.loadCharacter(newText.charAt(i), this.color, this.font);
                if (currChar != null) {
                    this.characters.add(currChar);
                    tg = new TransformGroup();
                    tg.addChild(currChar);
                    this.addChild(tg);
                }
            } else if (this.characters.get(i).getChar() != newText.charAt(i)) {
                currChar = Character2D.loadCharacter(newText.charAt(i), this.color, this.charId);
                int oldShapeIndex = this.characters.get(i).getParent().indexOf(this.characters.get(i));
                this.characters.get(i).getParent().setChild(currChar, oldShapeIndex);
                this.characters.set(i, currChar);
            } else {
                currChar = this.characters.get(i);
            }
            if (currChar == null) continue;
            tg = (TransformGroup)currChar.getParent();
            t3d = tg.getTransform();
            t3d.setTranslation(offsetX, 0.0f, 0.0f);
            tg.setTransform(t3d);
            offsetX += currChar.getWidth();
        }
        if (newText.length() == 0) {
            this.size.set(0.0f, 0.0f);
        } else {
            float width = 0.0f;
            for (int i = 0; i < this.characters.size(); ++i) {
                width += this.characters.get(i).getSize().getX();
            }
            this.size.set(width, this.characters.get(0).getSize().getY());
        }
        t3d = this.getTransform();
        t3d.getTranslation(this.tmpVec);
        if (this.align.isHCenterAligned()) {
            this.tmpVec.setX(-(this.size.getX() / 2.0f));
        } else if (this.align.isRightAligned()) {
            this.tmpVec.setX(-this.size.getX());
        }
        t3d.setTranslation((Tuple3f)this.tmpVec);
        this.setTransform(t3d);
        this.text = newText;
    }

    public String getText() {
        return this.text;
    }

    public Character2D char2DAt(int index) {
        return this.characters.get(index);
    }

    public Tuple2f getSize() {
        return this.size;
    }

    public Font getFont() {
        return this.font;
    }

    protected String getCharId() {
        return this.charId;
    }

    public TextAlignment getAlign() {
        return this.align;
    }

    public void setColor(float r, float g, float b) {
        this.color.set(r, g, b);
        for (int i = 0; i < this.characters.size(); ++i) {
            this.characters.get(i).setColor(this.color);
        }
    }

    public void setColor(Colorf color) {
        this.setColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Colorf getColor() {
        return this.color;
    }

    protected void setTransparency(TransparencyAttributes ta) {
        this.cachedTA = ta;
        for (int i = 0; i < this.characters.size(); ++i) {
            this.characters.get(i).getAppearance().setTransparencyAttributes(this.cachedTA);
        }
    }

    public void setTransparency(float transparency) {
        if (this.cachedTA != null) {
            this.cachedTA.setTransparency(transparency);
            return;
        }
        this.cachedTA = new TransparencyAttributes(TransparencyAttributes.BLENDED, transparency);
        this.setTransparency(this.cachedTA);
    }

    public float getTransparency() {
        if (this.cachedTA == null) {
            return 0.0f;
        }
        return this.cachedTA.getTransparency();
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.getText() + "]";
    }

    protected Line2D(String string, float r, float g, float b, String charId, TextAlignment align) {
        this.charId = charId;
        this.align = align;
        this.color.set(r, g, b);
        this.size = new Point2f();
        this.characters = new Vector(string.length());
        this.unmodCharacters = Collections.unmodifiableList(this.characters);
        this.setText(string);
    }

    protected Line2D(String string, Colorf color, String charId, TextAlignment align) {
        this(string, color.getRed(), color.getGreen(), color.getBlue(), charId, align);
    }

    public Line2D(String string, float r, float g, float b, Font font, TextAlignment align) {
        this.charId = font.getName() + "-" + font.getSize() + "-" + font.getStyle();
        this.font = font;
        this.align = align;
        this.color.set(r, g, b);
        this.size = new Point2f();
        this.characters = new Vector();
        this.unmodCharacters = Collections.unmodifiableList(this.characters);
        this.setText(string);
    }

    public Line2D(String string, Colorf color, Font font, TextAlignment align) {
        this(string, color.getRed(), color.getGreen(), color.getBlue(), font, align);
    }
}

