/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.text2d;

import java.awt.Font;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openmali.spatial.bodies.Frustum;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.UpdatableNode;
import org.xith3d.scenegraph.View;
import org.xith3d.ui.text2d.Line2D;
import org.xith3d.ui.text2d.TextAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Text2D
extends TransformGroup
implements UpdatableNode {
    private String text;
    private Font font;
    private Colorf color = new Colorf();
    private TextAlignment align;
    private Tuple2f size;
    private Vector3f tmpVec = new Vector3f();
    private boolean dirty = false;
    private List<Line2D> lines;
    private List<Line2D> unmodLines;
    private TransparencyAttributes cachedTA = null;

    public List<Line2D> getLines() {
        return this.unmodLines;
    }

    public void setColor(float r, float g, float b) {
        for (int i = 0; i < this.lines.size(); ++i) {
            this.lines.get(i).setColor(r, g, b);
        }
        this.color.set(r, g, b);
    }

    public void setColor(Colorf color) {
        this.setColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Colorf getColor() {
        return this.color;
    }

    public float getRedValue() {
        return this.color.getRed();
    }

    public float getBlueValue() {
        return this.color.getGreen();
    }

    public float getGreenValue() {
        return this.color.getBlue();
    }

    public void setTransparency(float transparency) {
        if (this.cachedTA != null) {
            this.cachedTA.setTransparency(transparency);
            return;
        }
        this.cachedTA = new TransparencyAttributes(TransparencyAttributes.BLENDED, transparency);
        for (int i = 0; i < this.lines.size(); ++i) {
            this.lines.get(i).setTransparency(this.cachedTA);
        }
    }

    public float getTransparency() {
        if (this.cachedTA == null) {
            return 0.0f;
        }
        return this.cachedTA.getTransparency();
    }

    public Tuple2f getSize() {
        return this.size;
    }

    public void setFont(Font font) {
        this.font = font;
        this.dirty = true;
    }

    public void setFont(String fontname) {
        this.font = this.font != null ? new Font(fontname, this.font.getStyle(), this.font.getSize()) : new Font(fontname, 0, 12);
        this.dirty = true;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFontFlags(int fontFlags) {
        this.font = this.font != null ? new Font(this.font.getName(), fontFlags, this.font.getSize()) : new Font("Monospace", fontFlags, 12);
        this.dirty = true;
    }

    public void setResolution(int resolution) {
        this.font = this.font != null ? new Font(this.font.getName(), this.font.getStyle(), resolution) : new Font("Monospace", 0, resolution);
        this.dirty = true;
    }

    public void setAlignment(TextAlignment alignment) {
        this.align = alignment;
        this.dirty = true;
    }

    public TextAlignment getAlignment() {
        return this.align;
    }

    @Override
    public boolean update(View view, Frustum frustum, long nanoTime, long nanoStep) {
        if (this.dirty) {
            this.removeAllChildren();
            this.lines.clear();
            this.setText(this.text);
            this.dirty = false;
        }
        return true;
    }

    public void setText(String newText) {
        Transform3D t3d;
        TextAlignment lineAlign = null;
        if (this.align.isLeftAligned()) {
            lineAlign = TextAlignment.TOP_LEFT;
        } else if (this.align.isHCenterAligned()) {
            lineAlign = TextAlignment.TOP_CENTER;
        } else if (this.align.isRightAligned()) {
            lineAlign = TextAlignment.TOP_RIGHT;
        }
        StringTokenizer lineTokens = new StringTokenizer(newText, "\n\f");
        float offsetY = 0.0f;
        int index = 0;
        while (lineTokens.hasMoreTokens()) {
            Line2D currLine;
            if (this.lines.size() <= index) {
                currLine = new Line2D(lineTokens.nextToken(), this.color, this.font, lineAlign);
                this.lines.add(currLine);
                this.addChild(currLine);
                t3d = currLine.getTransform();
                t3d.getTranslation(this.tmpVec);
                this.tmpVec.setY(offsetY);
                t3d.setTranslation((Tuple3f)this.tmpVec);
                currLine.setTransform(t3d);
                offsetY -= currLine.getSize().getY();
            } else {
                currLine = this.lines.get(index);
                t3d = currLine.getTransform();
                t3d.getTranslation(this.tmpVec);
                this.tmpVec.setY(offsetY);
                t3d.setTranslation((Tuple3f)this.tmpVec);
                currLine.setTransform(t3d);
                currLine.setText(lineTokens.nextToken());
                offsetY -= currLine.getSize().getY();
            }
            ++index;
        }
        for (int i = this.lines.size() - 1; i >= index; --i) {
            this.removeChild(this.lines.get(i));
            this.lines.remove(i);
        }
        if (newText.length() == 0) {
            this.size.set(0.0f, 0.0f);
        } else {
            float width = 0.0f;
            float height = 0.0f;
            for (int i = 0; i < this.lines.size(); ++i) {
                Line2D line = this.lines.get(i);
                if (line.getSize().getX() > width) {
                    width = line.getSize().getX();
                }
                height += line.getSize().getY();
            }
            this.size.set(width, height);
        }
        t3d = this.getTransform();
        if (this.align.isVCenterAligned()) {
            t3d.setTranslation(0.0f, this.size.getY() / 2.0f, 0.0f);
        } else if (this.align.isBottomAligned()) {
            t3d.setTranslation(0.0f, this.size.getY(), 0.0f);
        }
        this.setTransform(t3d);
        this.text = newText;
    }

    public Text2D(String text, float r, float g, float b, Font font, TextAlignment alignFlags) {
        this.color.set(r, g, b);
        this.font = font;
        this.align = alignFlags;
        this.size = new Point2f();
        this.lines = new Vector<Line2D>(1);
        this.unmodLines = Collections.unmodifiableList(this.lines);
        this.setText(text);
    }

    public Text2D(String text, Colorf color, Font font, TextAlignment alignFlags) {
        this(text, color.getRed(), color.getGreen(), color.getBlue(), font, alignFlags);
    }

    public Text2D(String text, float r, float g, float b, String fontname, int fontFlags, int resolution, TextAlignment alignFlags) {
        this(text, r, g, b, new Font(fontname, fontFlags, resolution), alignFlags);
    }

    public Text2D(String text, Colorf color, String fontname, int fontFlags, int resolution, TextAlignment alignFlags) {
        this(text, color.getRed(), color.getGreen(), color.getBlue(), fontname, fontFlags, resolution, alignFlags);
    }

    public Text2D(String text, Colorf color) {
        this(text, color, "Monospace", 1, 12, TextAlignment.CENTER_CENTER);
    }

    public Text2D(String text, TextAlignment alignFlags) {
        this(text, 1.0f, 1.0f, 1.0f, "Monospace", 1, 12, alignFlags);
    }

    public Text2D(String text) {
        this(text, 1.0f, 1.0f, 1.0f, "Monospace", 1, 12, TextAlignment.CENTER_CENTER);
    }
}

