/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.camera.flight;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.IntervalListener;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.utility.camera.flight.CameraFlight;

public class CameraFlightRecorder
extends Interval
implements IntervalListener {
    private Transformable view;
    private long t1;
    private long t2;
    private Matrix3f viewRot = new Matrix3f();
    private Point3f viewPos = new Point3f();
    private OutputStream output;

    private void writeString(String str) {
        try {
            for (int i = 0; i < str.length(); ++i) {
                this.output.write(str.charAt(i));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeRotPos(Matrix3f rot, Point3f pos, long deltaTime) {
        this.writeString(String.valueOf(rot.m00()) + " " + String.valueOf(rot.m01()) + " " + String.valueOf(rot.m02()) + "\n");
        this.writeString(String.valueOf(rot.m10()) + " " + String.valueOf(rot.m11()) + " " + String.valueOf(rot.m12()) + "\n");
        this.writeString(String.valueOf(rot.m20()) + " " + String.valueOf(rot.m21()) + " " + String.valueOf(rot.m22()) + "\n");
        this.writeString(String.valueOf(pos.getX()) + " " + String.valueOf(pos.getY()) + " " + String.valueOf(pos.getZ()) + "\n");
        this.writeString(String.valueOf(deltaTime) + "\n\n");
    }

    private void writeRotPos(Transformable transformNode, long deltaTime) {
        transformNode.getTransform().getRotation(this.viewRot);
        transformNode.getTransform().get((Tuple3f)this.viewPos);
        this.writeRotPos(this.viewRot, this.viewPos, deltaTime);
    }

    public void onIntervalHit(Interval interval, long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.t1 >= 0L && interval == this) {
            this.t2 = gameTime;
            this.writeRotPos(this.view, this.t2 - this.t1);
            this.t1 = this.t2;
        }
    }

    public void startRecord(long startTime, File file, CameraFlight.Format format) {
        try {
            this.output = new FileOutputStream(file);
            this.output.write(String.valueOf(format.getByte()).codePointAt(0));
            this.output.write(10);
            this.output.write(10);
            if (format == CameraFlight.Format.COMPRESSED) {
                this.output = new DeflaterOutputStream(this.output);
            }
            this.output = new BufferedOutputStream(this.output);
            this.writeRotPos(this.view, 0L);
            this.t1 = startTime;
            System.out.println("CameraFlight record started.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startRecord(long startTime, String filename, CameraFlight.Format format) {
        this.startRecord(startTime, new File(filename), format);
    }

    public void startRecord(long startTime, File file) {
        this.startRecord(startTime, file, CameraFlight.Format.UNCOMPRESSED);
    }

    public void startRecord(long startTime, String filename) {
        this.startRecord(startTime, new File(filename), CameraFlight.Format.UNCOMPRESSED);
    }

    public void stopRecord() {
        try {
            this.output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.t1 = -1L;
        System.out.println("CameraFlight record stopped.");
    }

    public CameraFlightRecorder(Transformable view, long resolution) {
        super(resolution);
        this.view = view;
        this.t1 = -1L;
    }
}

